<?php

print <<< HTML_WEB_PAGE

<!DOCTYPE HTML>

<head>
<title>General Ephemeris Info</title>

<style>
BODY {color:white; background:black;}
PRE {
     font-family:monospace; font-size:11pt; font-weight:bold;color:black;
     background:white; padding:8px; border-radius:8px;
    }
::selection{background-color:yellow !important; color:black !important;}
::-moz-selection{background-color:yellow !important; color:black !important;}
</style>
</head>

<body>
<br>
<pre style='width:666px;'>
##############################################################################
GENERAL INFORMATION FOR THE CUSTOM EXPERIMENTAL EPHEMERIS

NASA/JPL Horizons General Ephemeris Tool + Data Query Portal

Built around the NASA/JPL Horizons API

The program also emulates several TelNet functions.
telnet://horizons.jpl.nasa.gov:6775

AUTHOR   : Jay Tanner - 2025
LANGUAGE : PHP v8.2.12

LICENSE  : Public Domain

------------------------------------------------------------------------------
This program was intended to serve as a customized interface to the NASA/JPL
Horizons API with the possibility of adding extended functions.

The following text explains the basic input elements.

I used my own home coordinates in central New York State, USA as the default
HOME coordinates.

If you have a desktop web server with an Internet connection, you can run
this program locally from your desktop via any standard web browser and set
the HOME defaults to your own home location by editing the source code.

------------------------------------------------------------------------------
NASA/JPL Object ID#,  Record #, Query or Special Directive [...]

This is the main prompt where you enter the NASA/JPL target body ID or query.
Generally, the target body ID or query is NOT case sensitive.

In most cases, the target ID number is its record number in the JPL database.

In some cases, it can be a unique name, such as Vesta or Ceres.

When specifying an asteroid number, always append a semicolon (;) to it.
For example, 301; with a semicolon, refers to asteroid #301 Bavaria (A890 WA)
Without the semicolon, 301 refers to our moon (Luna).  (Planet #3, Moon #01).

Entering Juno at the prompt, returns more than one possibility.  There is an
asteroid named Juno, and two spacecraft with Juno in their names.

For the asteroid Juno, simply attach a semicolon (Juno;) to solve the problem
or use its asteroid number, 3; with the semicolon.

------------------------------------------------------------------------------
Optional Location Name = Any optional text label or location name.

This is an optional location name or label to attach to the ephemeris output
if you want to display the observer location in the ephemeris.

------------------------------------------------------------------------------
Base Time Scale = UT|TT

By default, UT is the base time scale used for the computations. The Time Zone
is applied to this base time scale.  When the Time Zone equates to zero, then
the local time equates to UT.

When the TT scale is used, the Time Zone setting is ignored.

------------------------------------------------------------------------------
START: Calendar Date and Time
STOP:  Calendar Date and Time

This is the range of dates for which to compute an ephemeris or table.  It
can compute a single computation or a full ephemeris table.

Date and time string format:


------------------------------------------------------------------------------
Time Zone = 00:00 &plusmn; 14:00

This is the local Time Zone offset from UT.  It is applied only if UT is the
Base Time Scale.  It is ignored if the TT scale is selected.

------------------------------------------------------------------------------
Daylight/Summer Time = Yes|No

Yes = Assume Daylight Saving Time
No  = Assume Standard Time

------------------------------------------------------------------------------
Step Size

This is the interval between the ephemeris table computations.

Possible time units are:  Minutes | Hours | Days | MOnths | Years

------------------------------------------------------------------------------
GPS Longitude   +Pos = East
GPS Latitude    +Pos = North

These are the geographic GPS coordinates of the observer on Earth.

These coordinates can be entered as single decimal degree values or
as degrees, minutes and seconds values separated by spaces.

These coordinates are ignored for geocentric ephemerides.

------------------------------------------------------------------------------
&plusmn; Sea Level Altitude

This is the observer's altitude above or below sea level in meters.

This setting is ignored for geocentric ephemerides.

------------------------------------------------------------------------------
Reference System = ICRF|B1950

There are two reference systems available.

ICRF (International Celestial Reference Frame) = Default
This is for apparent local or geocentric astronomical coordinates.
NOTE: For ICRF RA and declination, use quantity #1.

B1950/FK4
This is for astrometric (star chart coordinates).
NOTE: For B1950/FK4 RA and declination, use quantity #1.

------------------------------------------------------------------------------
Use Geocentric Coords = Yes|No (Default = Yes)

Yes = Generate a geocentric ephemeris.
No  = Generate a local ephemeris for a given location.

------------------------------------------------------------------------------
Angle Output DEG or HMS = HMS|DEG

HMS = Output angles in sexagesimal format (HMS|DMS) format.
DEG = Output angles in decimal format.

------------------------------------------------------------------------------
Apply Refraction = Yes|No

Yes = Apply optional refraction to computed sky coordinates.
No  = Return raw airless sky coordinates, without refraction.

Refraction is ignored for geocentric ephemerides.

------------------------------------------------------------------------------
Include Object Data = Yes|No

Yes = Show the basic target object physical data.
No  = Do not show the target object data in the ephemeris.

------------------------------------------------------------------------------
Include Julian Date = Yes|No

Yes = Include the Julian Date in the ephemeris output.
No  = Suppress the Julian Date in the ephemeris output.

------------------------------------------------------------------------------
Include Ephem Header = Yes|No

Yes = Include the ephemeris parameters header in the ephemeris.  This header
lists all the basic parameters used for the ephemeris.

No  = Do not include the ephemeris parameters header in the ephemeris.

------------------------------------------------------------------------------
Include Ephem Footer = Yes|No

Yes = Include the ephemeris parameters footer in the ephemeris. The footer
explains the meanings of the contents of the ephemeris columns. When you are
not quite sure what a column means, reading this explanatory footer may help.

No  = Do not include the ephemeris parameters footer in the ephemeris.

------------------------------------------------------------------------------
Distance (Range) Units = AU|KM

Distances may be output in Astronomical Units (AU) or kilometers (KM).

------------------------------------------------------------------------------
Suppress Range Rate = Yes|No

Yes = Suppress showing the range rate output in the ephemeris.
No  = Show the range rate output in the ephemeris.

The range rate is the radial velocity of the target body towards or away from
the observer. Negative = Approaching | Positive = Receding.  This value may
selectively be suppressed and not displayed after the distance.

------------------------------------------------------------------------------
DEMO | RESET | NOW |HOME

These are special experimental features mostly used for testing purposes in
the background.

DEMO
This emulates the demo HTTP Request for Mars found on the NASA web page:
https://ssd-api.jpl.nasa.gov/doc/horizons.html

RESET
This reset the program to all its initial defaults.

NOW
This resets to the current time.

HOME
This resets all home-based parameters.
This means whatever home coordinates you decide to hard-code into the program.
Initially, the author's home coordinates, for running from the desktop. This
can be changed by editing the source code.

******************************************************************************
******************************************************************************
BELOW ARE SPECIAL OPERATIONS THAT OPEN IN NEW TABS.  THESE OPERATION ARE
EXTERNAL TO THE INTERFACE PROGRAM BUT USE A SHARED COOKIE.  THIS ALLOWS
THE PROGRAM TO BE EXPANDED UPON BY EASILY ADDING EXTERNAL ATTACHMENTS
WITH MINIMAL CHANGES TO THE INTERFACE CODING.

IF A TAB IS ALREADY OPEN, SIMPLY REFRESH THE PAGE TO UPDATE IT FOR ANY CHANGES
MADE TO THE INPUT INTERFACE SETTINGS.

------------------------------------------------------------------------------
Moon Phase Table

This displays all the lunar phases within the given date range at the given
step intervals.  By default, it displays mini images of moon phases from the
current date to the end of the month.

------------------------------------------------------------------------------
Moon Phase Angle Table

This computes a numerical table of moon phases within the given date range at
the given step intervals.

------------------------------------------------------------------------------
Rise/Transit/Set Times

This generates a table of rise/transit/set times for the selected target body
within the given date range at the given step intervals.

------------------------------------------------------------------------------
DDD = Not Yet Defined. For future use.

------------------------------------------------------------------------------
</pre>

<!-- For extra scrolling space at bottom --->
<br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>



HTML_WEB_PAGE;

?>



