<?PHP

/*

   THIS PROGRAM COMPUTES A GENERAL CALENDAR FOR ANY
   GIVEN YEAR ON THE JULIAN OR GREGORIAN CALENDARS.

   v1.0

*/


// Initialize cookies
   ob_start();

   $_COOKIE_NAME_ = "GeneralCalendarForAnyYearSettings";

   $cYear = gmdate("Y");

   $_ACTION_FILE_NAME_ = $_SERVER['SCRIPT_NAME'];

   $_HTML_TITLE_       = 'General Calendar For Any Year';

   $_HEADER_           = 'General Calendar For Any Year';

   $_CSS_PATH_         = '';

   $out = "";

// ===========================================================
// Set cookie expiration date to 30 days.
//
// This value must be the number of seconds as measured from
// the moment the cookie is created.  To set the cookie to
// expire in 30 days, simply multiply the number of days
// by 86400 seconds per day.

   $ToExpire = 30 * 86400;



// =======================================
// Do this if "Submit" button was clicked.

   if (IsSet($_POST["Submit"]))

  {
       $y = trim($_POST["y"]);

       if ($y == '') {$y = GMDate('Y');}

       $CookieDataString = "$y";

       setcookie ($_COOKIE_NAME_, $CookieDataString, time() + $ToExpire);
  }


   else


// ======================================================
// Do this if program was called externally via URL link.

      {

// ========================================================
// If a cookie exists, then recall interface value from it.

   if (IsSet($_COOKIE[$_COOKIE_NAME_]))

      {

       $y = $_COOKIE[$_COOKIE_NAME_];

      }


   else


// ===============================================
// If no cookie exists, then set default interface
// value and copy it to an initial cookie.

      {
       $y = gmdate('Y');

       $CookieDataString = "$y";

       setcookie ($_COOKIE_NAME_, $CookieDataString, time() + $ToExpire);
      }

}



// **********************************
// **********************************
// AT THIS POINT, THE INPUT INTERFACE
// VALUES SHOULD BE READY FOR USE








// ---------------------------------------
// CHECK FOR AND BLOCK INVALID DATE INPUT.

   if ($y < -4713 || $y > 9999)
      {
       $out = "<b style='color:red; font-size:125%; font-weight:normal;'>ERROR<br>Invalid Year<br>Valid Range is From:&nbsp; &minus;4713 &nbsp;to&nbsp; 9999</b><br>";
      }


else


// =================================
// CONTINUE BELOW IF ARGUMENT IS OK.









// MAIN COMPUTATIONS START HERE
{

// DETERMINE CALENDAR MODE ACCORDING TO YEAR.
// IF YEAR < 1583, THEN JULIAN ELSE GREGORIAN.
//
// THE YEAR 1582 IS PROBLEMATIC, SINCE IT WAS
// THE TRANSITION YEAR, SO JULIAN MODE IS SET
// FOR THAT YEAR AND GREGORIAN THEREAFTER.

   $CalendarForYearTable = "";

   $CalMode = ($y < 1583) ? 0 : 1;

   $CalendarForYearTable = Calendar_For_Year_Table ($y, $CalMode) . "\n<BR><BR><BR>\n";

   if ($y == 1582)
      {$CalendarForYearTable .= JG_Transition_Calendar_Table_Full ();}

    if ($y == 1752)
       {$CalendarForYearTable .= JG_1752_Transition_Calendar_Table_Full ();}

  }







// ===========================================
// DYNAMIC HTML DOCUMENT OUTPUT FOLLOWS BELOW.

print <<< _HTML

<!DOCTYPE HTML>

<HTML lang='en'>
<HEAD>

<title>Calendar Calculator For Any Given Year</title>
<meta name='viewport' content='width=device-width, initial-scale=1'>
<meta http-equiv='content-type' content='text/html; charset=UTF-8'>
<meta name='description' content='This PHP program calculates a calendar for any given year. Dates before Oct. 15, 1582 apply the old Julian calendar automatically.'>
<meta name='keywords' content='calendar calculator,julian/Gregorian transition,calendar,Julian calendar,Gregorian calendar,PHPScienceLabs.com'>
<meta name='author' content='Jay Tanner - www.PHPScienceLabs.com'>
<meta http-equiv='pragma'  content='no-cache'>
<meta http-equiv='expires' content='-1'>
<meta name='robots'    content='index,follow'>
<meta name='googlebot' content='index,follow'>
<link rel="canonical" href="https://www.phpsciencelabs.com/calendar-calculator-for-any-year/">

<STYLE>

INPUT[type='text']::-ms-clear{width:0; height:0;}
INPUT[type='text']{font-family:monospace; color:black; background:white; font-size:150%; font-weight:bold; text-align:center; box-shadow:2px 2px 3px #666666; border:1px solid black; border-radius:4px;}
INPUT[type='text']:focus{font-family:monospace; background:white; box-shadow:2px 2px 3px #666666; font-size:150%; border:2px solid blue; text-align:center; font-weight:bold; border-radius:4px;}

INPUT[type='submit']{background:silver; color:black; font-family:Verdana; font-size:100%; font-weight:normal; border-radius:4px; border:1px solid black; padding:2px;}
INPUT[type='submit']:hover{background:cyan; font-family:Verdana; font-size:100%; font-weight:normal; border-radius:4px; border:1px solid black; padding:2px;}

</STYLE>

</HEAD>

<BODY BGCOLOR="black" CLASS="BgVLtGray">

<FORM NAME="InputForm1" METHOD="post" ACTION="$_ACTION_FILE_NAME_">

<TABLE WIDTH="520" BORDER="0" ALIGN="center" BGCOLOR="black" CELLPADDING="2" CELLSPACING="1">

<TR><TD style='background:#000066; color:white; font-size:150%; text-align:center; border:2px solid white; border-radius:8px 8px 0px 0px; line-height:150%;'>General Calendar For Any Year<br><span style='font-size:70%;'>PHP Program by Jay Tanner</span>
</TD></TR>

<TR><TD ALIGN="center" BGCOLOR="LightCyan"><B>Year</B>: 4713 BC to 9999 AD<BR>Neg Year = BC</TD></TR>

<TR><TD ALIGN="center" BGCOLOR="DarkGray">
<INPUT NAME="y" TYPE="text" CLASS="TxInpCtr" VALUE="$y" SIZE="6" MAXLENGTH="5">
<INPUT TYPE="submit" NAME="Submit" VALUE="Compute">
</TD></TR>

</TABLE>

</FORM>

<BR>


<DIV ALIGN="center">
$out$CalendarForYearTable

</DIV>

<br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>

</BODY>
</HTML>

_HTML;



/*

   THIS IS THE NEOCORE V2010

   IT SERVES AS THE MAIN LOGIC FOUNDATION
   UPON WHICH THIS WEB SITE IS BUILT.

   REVISED: 2010 DEC 16

*/

//  INCLUDE_ONCE ("Calendar_Functions_Module.php");


// ----------------------------
// Define light speed constant.

   define ("c", "299792458"); // Units: m/s

// ---------------------------------------------------
// Define the mathematical constant pi to 64 decimals.

   define ("pi", "3.141592653589793238462643383279502884197169399375105820974944592307816");

// ------------------------------------------------------------
// Define the constant, e, to 64 decimals.  this is the base of
// natural logarithms.  It is the value of e to the 1st power.

   define ("e", "2.718281828459045235360287471352662497757247093699959574966967627724077");

// -----------------------------------------
// Define factors to convert between degrees
// and radians to up to 64 decimals.

// Multiply degrees by this factor to obtain radians.
   define ("RAD_PER_DEG", "0.01745329251994329576923690768488612713442871888541725456097191440171009");

// Multiply radians by this factor to obtain degrees.
   define ("DEG_PER_RAD", "57.2957795130823208767981548141051703324054724665643215491602438612028509");

/*

 -----------------------------------------------
 The metric length units symbols recognized are:

 ------   ----
 SYMBOL   UNIT

   A      Angstroms
   nm     Nanometers
   u|um   Micrometers (or Microns)
   mm     Millimeters
   cm     Centimeters
   in     Inches
   ft     Feet
   yd     Yards
   m      Meters
   km     Kilometers
   mi     Miles (Statute)
   nmi    Nautical miles
   AU     Astronomical Units
   LY     Light Years (Based on Julian year)
   pc     Parsecs (Based on Julian year)

   LS     Light Seconds

*/


// ------------------------------------------
// JULIAN AND GREGORIAN CALENDAR YEAR LENGTHS

// Length of Julian calendar year in seconds.
// Exactly 365.25 days.
   define ("S_PER_JYR", "31557600");

// Length of Gregorian calendar year in seconds.
// Exactly 365.2425 days.
   define ("S_PER_GYR", "31556952");



// The following metric length interconversion factor constants are
// based on the following standard values.  Currently, 15 units are
// supported here.


// -----------------------------------------------------------------
// Define some EXACT standard metric length/distance interconversion
// factors in terms of metres per unit (M_PER_UNIT).  This is the
// factor to multiply the units by to compute the equivalent metres.

   define ("M_PER_A"   , "0.0000000001");  // m per angstrom
   define ("M_PER_NM"  , "0.000000001");   // m per nanometer
   define ("M_PER_UM"  , "0.000001");      // m per micrometer (micron)
   define ("M_PER_MM"  , "0.001");         // m per millimeter
   define ("M_PER_CM"  , "0.01");          // m per centimeter
   define ("M_PER_IN"  , "0.0254");        // m per inch
   define ("M_PER_FT"  , "0.3048");        // m per foot
   define ("M_PER_YD"  , "0.9144");        // m per yard
   define ("M_PER_M"   , "1");             // m per meter
   define ("M_PER_KM"  , "1000");          // m per kilometer
   define ("M_PER_MI"  , "1609.344");      // m per mile (statute)
   define ("M_PER_NMI" , "1852");          // m per nautical mile
   define ("KM_PER_NMI", "1.852");         // km per nautical mile
   define ("KM_PER_MI" , "1.609344");      // Kilometres per Mile (statute)



// ------------------------
// Define Astronomical Unit

   define ("M_PER_AU" , "149597870691");   // NASA/JPL-DE405
   define ("KM_PER_AU", "149597870.691");  // NASA/JPL-DE405
   define ("KM_PER_IAU", "149597871");     // IAU value




// -----------------------------------------------------
// Derived factors based on the above adopted standards.
// The AU used is the IAU value and the year value used
// is the standard Julian year of 365.25 days.

   define ("M_PER_LY"  , "9460730472580800");
   define ("M_PER_PC"  , "30856775876793114.6632722718115");
   define ("AU_PER_LY" , "63241.0769574441336802");
   define ("AU_PER_PC" , "206264.8062470963551565");
   define ("LY_PER_PC" , "3.2615637837080957");



// ------------------------------------------
// Define some EXACT metric weight standards.

   define ("KG_PER_OZ" , "0.028349523125");
   define ("KG_PER_LB" , "0.45959237");
   define ("G_PER_OZ"  , "28.349523125");



// ------------------------------------------------
// Define standard and universal gravity constants.

   define ("g", "9.80665");  // m per s²
   define ("G", "0.000000000066742");  // Universal G (SI units)



// --------------------------
// Define Planck constant (h).

   define ("h", "0.000000000000000000000000000000000662606896");  // J/s (watts)



// -----------------------------------------
// Define Stefan-Boltzmann constant (sigma).
//
// radiated energy = sigma * K**4 watts per sq. meter
// Where K = temperature in kelvins

   define ("sigma", "0.000000056704");  // Watts per sq. meter


// -----------------------------------------
// Define Boltzmann constant (k).
//
// k = Joules / deg Kelvin

   define ("k", "0.000000000000000000000013806504");  // Joules per deg K









// ************************************************************************
// ************************************************************************


   function Strip_WSpace ($ArgStr)
{
   return preg_replace('/\s+/', ' ', trim($ArgStr));
}


// ************************************************************************
// ************************************************************************

/*

********************************************************
This function converts any of several units of length or
distance into the equivalent in meters.  It makes use of
the metric length equivalents defined within this module.

It is the opposite of the Meters_To_Length() function.

----
NOTE

These computations are able to accomodate arbitrary
precision out to 105 decimals which is sufficient
for any practical usage.

---------
ARGUMENTS

$LengthVal = Numerical value of the length to be converted
$FromUnits = The units symbol corresponding to the value

The returned output is simply the equivalent length in meters.

-------------------------------------------------------
There are 15 units symbols recognized by this function.

They are:

 SYMBOL         UNITS

   A            Angstroms
   nm           Nanometers
 um or u        Micrometers (or Microns)
   mm           Millimeters
   cm           Centimeters
   in           Inches
   ft           Feet
   yd           Yards
   m            Meters
   km           Kilometers
   mi           Miles (Statute)
   nmi          Nautical miles
   LS           Light Seconds
   AU           Astronomical Units
   LY           Light Years (Based on Julian year)
   psc          Parsecs

IMPORTANT NOTE:
The units symbols used here ARE case sensitive.

ERRORS:
An error occurs if the argument cannot be resolved
into a valid numerical value and units symbol.  On
error, FALSE is returned.

*/

   Function Length_To_Meters ($LengthVal, $FromUnits)
{

// ------------------------------
// Set arbitrary precision limit.

   $nDec = 105;

// -----------------------------
// Get the numerical value part.
// Error if not a numerical value.

   $x = trim($LengthVal);

   if ($x == "") {$x = "0.0";}

   if (!is_numeric($x)) {return FALSE;}

   if (StrPos($x, ".") === FALSE) {$x = "$x.0";}

// ----------------
// Get units symbol.

   $UnitsSymbol = trim($FromUnits);

// ---------------------------------------------------
// Initialize factor to empty string.   If it is still
// empty on exit from the switch block, below then it
// means that the units symbol was not recognized as
// valid.

   $f = "";

// --------------------------------------
// Determine the conversion factor to use
// from the units symbol argument.
//
// NOTE: These symbols ARE case sensitive.

   switch ($UnitsSymbol)
  {
   case "A"   : $f = M_PER_A;    break;
   case "um"  : $f = M_PER_UM;   break;
   case "u"   : $f = M_PER_UM;   break;
   case "nm"  : $f = M_PER_NM;   break;
   case "mm"  : $f = M_PER_MM;   break;
   case "cm"  : $f = M_PER_CM;   break;
   case "in"  : $f = M_PER_IN;   break;
   case "ft"  : $f = M_PER_FT;   break;
   case "yd"  : $f = M_PER_YD;   break;
   case "m"   : $f = M_PER_M;    break;
   case "km"  : $f = M_PER_KM;   break;
   case "mi"  : $f = M_PER_MI;   break;
   case "nmi" : $f = M_PER_NMI;  break;
   case "LS"  : $f = c;          break;
   case "AU"  : $f = M_PER_AU;   break;
   case "LY"  : $f = M_PER_LY;   break;
   case "pc"  : $f = M_PER_PC;   break;
  }

// ------------------------------------------
// Error if conversion factor is still empty,
// which means that the units symbol is not
// found in the table of valid symbols.
   If ($f === FALSE) {return $f;}

// ----------------------------------------------
// Otherwise, return the equivalent meters value
// by multiplying the value of the argument by
// the conversion factor $f.
   $w = bcMul("$x", "$f", $nDec);

// -----
// Done.
   return RTrim(RTrim($w, "0"), ".");

}  // End of Length_To_Meters()


// ************************************************************************
// ************************************************************************


/*

**********************************************************
This function converts a length or distance value given in
meters into its equivalent in any of the 15 length units
recognized by this module.

It is the opposite of the Length_To_Meters() function and
recognizes the same length units symbols.

NOTE:
The computations are able to accomodate arbitrary
precision out to 105 decimals which is sufficient
for any practical usage.

ARGUMENTS
$metersArg =  Value in meters that will be converted
              to the specified output units.

$toUnits   =  Units symbol for the output value.  This
              symbol will NOT be attached to the output.
              It will simply be a numeric value that is
              understood to be in the specified units.

There are 15 units symbols recognized by this function.
They are:

 SYMBOL         UNITS

   A            Angstroms
   nm           Nanometers
 um or µ        Micrometers (or Microns)
   mm           Millimeters
   cm           Centimeters
   in           Inches
   ft           Feet
   yd           Yards
   m            Meters
   km           Kilometers
   mi           Miles (Statute)
   nmi          Nautical miles
   AU           Astronomical Units
   LY           Light Years (Based on Julian year)
   pc           Parsecs
   LS           Light Seconds

IMPORTANT NOTE
The units symbols used here ARE case sensitive.

ERRORS
An error occurs if the argument cannot be resolved
into a valid numerical value and units symbol.  On
error, FALSE is returned.

*/


   Function Meters_To_Length ($MetersVal, $ToUnits)

{

// ------------------------------
// Set arbitrary precision limit.

   $nDec = 105;

// ------------------------------
// Read value of meters argument.

   $m = Trim("$MetersVal");

// -------------------------------------
// Error if meters value is non-numeric.

   If (!Is_Numeric($m)) {Return FALSE;}

   if (StrPos($m, ".") === FALSE) {$m = "$m.0";}

// --------------------------------------
// Read the output units symbol argument.

   $UnitsSymbol = Trim($ToUnits);

// ---------------------------------------------------
// Initialize factor to empty string.   If it is still
// empty on exit from the switch block below, then it
// means that the units symbol was not found in the
// table of valid units.

   $f = "";

// --------------------------------------
// Determine the conversion factor to use
// from the units symbol argument.
// THESE SYMBOLS ARE CASE SENSITIVE.

   switch ($UnitsSymbol)
  {
   case "A"   : $f = M_PER_A;    break;
   case "um"  : $f = M_PER_UM;   break;
   case "u"   : $f = M_PER_UM;   break;
   case "nm"  : $f = M_PER_NM;   break;
   case "mm"  : $f = M_PER_MM;   break;
   case "cm"  : $f = M_PER_CM;   break;
   case "in"  : $f = M_PER_IN;   break;
   case "ft"  : $f = M_PER_FT;   break;
   case "yd"  : $f = M_PER_YD;   break;
   case "m"   : $f = M_PER_M;    break;
   case "km"  : $f = M_PER_KM;   break;
   case "mi"  : $f = M_PER_MI;   break;
   case "nmi" : $f = M_PER_NMI;  break;
   case "LS"  : $f = c;          break;
   case "AU"  : $f = M_PER_AU;   break;
   case "LY"  : $f = M_PER_LY;   break;
   case "pc"  : $f = M_PER_PC;   break;
  }

// ------------------------------------------
// Error if conversion factor is still empty.

   If ($f === "") {return FALSE;}

// ----------------------------------------------
// Otherwise, return the equivalent of the given
// meters value by dividing the value of the
// argument by the conversion factor $f.

   $w = bcDiv ($m, $f, $nDec);

   return RTrim(RTrim($w, "0"), ".");

}  // End of Meters_To_Length()


// ************************************************************************
// ************************************************************************



   function DMS_For_Deg ($PosSignFlag, $DegArg, $dddDigits, $ssDecimals, $SymbolsFlag=TRUE)
{

// Handle numerical sign of input.
   if ($DegArg < 0) {$sign = "-";} else {$sign = "";}
   if ($PosSignFlag === TRUE && $sign != "-")
      {$sign = "+";}

// Work with the absolute value
// of original argument.  The
// numerical sign will be
// reapplied to the output.
   $DegArg = abs($DegArg);

// Compute degrees.
   $ddd = floor($DegArg);

// Compute arc minutes.
   $w  = 60*($DegArg - $ddd);
   $mm = (int)$w;

// Compute arc seconds.
   $ss = 60*($w - $mm);

// Format degrees for output.  Left pad with up
// to 2 zeros to make a 1 to 3-digit string.

// Adjust redundant DDD padding zeros
// according to ($dddDigits) value.
   if ($dddDigits == 1)
      {$ddd = 0+$ddd;}

   if ($dddDigits == 2)
      {
       if (StrLen($ddd) < 2) {$ddd = "0$ddd";}
      }

   if ($dddDigits == 3)
      {
       if (StrLen($ddd) < 2)  {$ddd = "00$ddd";}
       if (StrLen($ddd) == 2) {$ddd = "0$ddd";}
      }

// Format arc minutes value ($mm).
// for output.
   if ($mm < 10) {$mm = "0$mm";}

// Construct output dms labels, if indicated.
   $DDDsymbol = $MMsymbol = $SSsymbol = "";
   if ($SymbolsFlag === TRUE)
      {
       $DDDsymbol = "°";
       $MMsymbol  = "'";
       $SSsymbol  = '"';
      }

// Construct output format string
// for arc seconds ($ss).
   $SSformat = "%02." . "$ssDecimals" . "f";

// Format arc seconds value ($ss).
// for output.
   if ($ssDecimals == 0)
      {$ss = sPrintF("%02d", $ss);
      }
   else
      {
       $ss = sPrintF($SSformat, $ss);
       if ($ss < 10) {$ss = "0$ss";}
      }


// Patch for that blasted residual 60 problem.
   if ($ss == 60) {$mm = sprintf("%02d", $mm+1);   $ss = "00.000000";}
   if ($mm == 60) {$hh = sprintf("%02d", $hh+1);   $mm = "00";}


// Return the formatted "DDD MM SS.sss" angle string.
   return "$sign$ddd$DDDsymbol $mm$MMsymbol $ss$SSsymbol";

} // End of  DMS_For_Deg()


// ************************************************************************
// ************************************************************************


   function HMS_For_Deg ($PosSignFlag, $DegArg, $hhDigits, $ssDecimals, $SymbolsFlag=TRUE)
{

// Handle numerical sign of input.
   if ($DegArg < 0) {$sign = "-";} else {$sign = "";}
   if ($PosSignFlag === TRUE && $sign != "-")
      {$sign = "+";}

// Convert decimal degrees into
// decimal hours and work with
// the absolute value.  The
// sign will be reapplied to
// the output.
   $deg = abs($DegArg / 15);

// --------------
// Compute hours.

   $hh = floor($deg);

// ----------------
// Compute minutes.

   $w  = 60*($deg - $hh);
   $mm = floor($w);

// ----------------
// Compute seconds.

   $ss = 60*($w - $mm);

// --------------------------------
// Patch to handle the 60s problem.

   if ($ss == 60) {$mm += 1;  $ss = 0;}
   if ($mm == 60) {$hh += 1;  $mm = 0;}

// ---------------------------
// Format HH value for output.

   $hh = sPrintF("%02d", $hh);

// ---------------------------
// Format MM value for output.

   $mm = sPrintF("%02d", $mm);

// --------------------------------------------
// Attach output symbols (h m s), if indicated.

   $HHsymbol = $MMsymbol = $SSsymbol = "";
   if ($SymbolsFlag)
      {
       $HHsymbol = "h";
       $MMsymbol = "m";
       $SSsymbol = "s";
      }

// Format SS.sss value for output.
   $SSformat = "%02." . "$ssDecimals" . "f";
   $ss = sPrintF($SSformat, $ss);
         if ($ss < 10) {$ss = "0$ss";}

// Return the formatted "HH MM SS.sss" time string.
   return "$sign$hh" . "$HHsymbol $mm" .  "$MMsymbol $ss" . "$SSsymbol";

} // End of  HMS_For_Deg()



// ************************************************************************
// ************************************************************************


   function HMS_For_Days ($days, $SSDecimals=0)

{

// ------------------------
// Remember numerical sign.
   $sign = ($days < 0)? "-" : "";

// -------------------------------------------------
// Work with absolute days value.  Any negative sign
// will be reattached to the returned result
   $d = abs($days);

// --------------------
// Compute hours value.
   $w   = $d * 24;
   $hh  = floor($w);

// ----------------------
// Compute minutes value.
   $w   = 60*($w - $hh);
   $mm  = floor($w);

// ----------------------
// Compute seconds value.
   $ss  = 60*($w - $mm);

// ------------------------------------
// Round seconds value to given number
// of decimals.
   $ss = sprintf ("%01.$SSDecimals" . "f", $ss);
   if ($ss < 10) {$ss = "0$ss";}

// --------------------------------------
// Account for that annoying 60s problem.
   if ($ss == 60) {$mm += 1;  $ss = 0;}
   if ($mm == 60) {$hh += 1;  $mm = 0;}

// ------------------------------------
// Format the time elements for output.
   if ($hh < 10) {$hh = "0$hh";}
   if ($mm < 10) {$mm = "0$mm";}

   $ss = sprintf ("%01.$SSDecimals" . "f", $ss);

   if ($ss < 10) {$ss = "0$ss";}

   $hh .= "h";  $mm .= "m";  $ss .= "s";

// ------------------------
// Done.
   return "$sign$hh $mm $ss";

} // End of  HMS_For_Days()



// ************************************************************************
// ************************************************************************



   function AU_To_AUKMMILT ($AUs, $AUDecimals=7, $LTFlag=FALSE)

{

   $AU = trim($AUs);

   $km = $AU * KM_PER_AU;
   $mi = $km / KM_PER_MI;


// Select prefix: M=Millions or B=Billions of kilometers.

   $factor = 1;
   $suffix = "";

   if ($km >= 1E6)  {$suffix = "M";  $factor = 1000000;}

   if ($km >= 1E9)  {$suffix = "B";  $factor = 1000000000;}

   $km /= $factor;

   $km = Format_Num (FALSE, $km, 3, 6) . " $suffix" . "km";

   $km = str_replace("| 0", "|  ", $km);

// Select prefix: M=Millions or B=Billions of miles.

   $factor = 1;
   $suffix = "";

   if ($mi >= 1E6)  {$suffix = "M";  $factor = 1000000;}

   if ($mi >= 1E9)  {$suffix = "B";  $factor = 1000000000;}

   $mi /= $factor;

   $mi = Format_Num (FALSE, $mi, 3, 6) . " $suffix" . "mi";

   if ($AU >= 4) {$w = "7";} else {$w = "$AUDecimals";}

       $AU = sPrintF("%1.$w" . "f", $AU) . " AU";

   $LT = $AU * 0.0057755183310895;

   $LTHMS = HMS_For_Days ($LT, 3);

   $LTHMS = str_replace("00h ", "", $LTHMS);


   if ($LTFlag === TRUE)
      {
       $w = "$AU =|$km =|$mi =|$LTHMS";
      }
   else
      {
       $w = "$AU =|$km =|$mi";
      }

   $w = str_replace("AU|00",  "AU|  ",  $w);
   $w = str_replace("AU|0",   "AU| ",   $w);
   $w = str_replace("Mkm|00", "Mkm|  ", $w);
   $w = str_replace("Mkm|0",  "Mkm| ",  $w);
   $w = str_replace("Bkm|00", "Bkm|  ", $w);
   $w = str_replace("Bkm|0",  "Bkm| ",  $w);
   $w = str_replace("|", " ", $w);

   $w = str_replace("    ", "   ", $w);

// --------------
// Final filters.

   $w = str_replace("= 0",  "=  ", $w);
   $w = str_replace("=  0", "=   ", $w);


// Done.
   return $w;

} // End of  AU_To_AUKMMILT()




// ************************************************************************
// ************************************************************************



   function Format_Num ($PosSignFlag, $xArg, $LPadDigits, $NumDecimals)
{

// ---------------------------
// Read input argument values.
   $x = trim($xArg);
   $z = $LPadZDigits;
   $d = $NumDecimals;

// ------------------------
// Remember numerical sign.
   $sign = ($x < 0)? "-" : "+";

// ------------------------------------
// Work internally with absolute value.
   if (SubStr($x, 0,1) == "-")
      {
       $x = SubStr($x, 1, StrLen($x));
      }

// ----------------------------------
// Attach positive sign if indicated.
   if ($PosSignFlag === FALSE && $sign == '+')  {$sign = "";}

// ---------------------------------
   $x = sPrintF("%10.$d" ."f", $x);
   $i = StrPos($x, ".");
   $IntPart = trim(SubStr($x, 0, $i));

// -----------------------------
// Handle case of integer value.
   if ($d == 0)
      {
       $FracPart = "";
       $IntPart = sPrintf("%d", $x);
      }

   else

//     ---------------------------------
//     Handle case of non-integer value.
      {
       $FracPart = "." . SubStr($x, $i+1, StrLen($x));
      }


   while (StrLen($IntPart) < $z) {$IntPart = "0$IntPart";}

// -----
// Done.
   return "$sign$IntPart$FracPart";

} // End of  Format_Num()















// ************************************************************************
// ************************************************************************








/*

   Lagrangian Interpolation for any number (n) of XY data pairs.

   ==========
   DATA RULES

   Both X and Y must represent continuous functions and may be
   linear or non-linear.

   No two values of X may be identical.

   --------------------------
   Test text data input table

   X Data    Y Data
   29.43     0.4913598528
   30.97     0.5145891926
   27.69     0.4646875083
   28.11     0.4711658342
   31.58     0.5236885653
   33.05     0.5453707057

   X = Angle in degrees
   Y = Sine of angle X

   ---------------------------------------------------------
   Test text  data table converts into the Lagrange_Interp()
   input XY data vector strings:

   $xDataVector = "29.43 30.97 27.69 28.11 31.58 33.05";

   $yDataVector = "0.4913598528 0.5145891926 0.4646875083 0.4711658342 0.5236885653 0.5453707057";

*/

   function Lagrange_Interp ($xDataVector, $yDataVector, $xArg)
{

// Read XY data vector strings and then strip all redundant
// white space and NewLine codes from the data strings.
   $Xdv = preg_replace('/\s+/', ' ', trim($xDataVector));
   $Ydv = preg_replace('/\s+/', ' ', trim($yDataVector));

// Split XY data vector strings
// into matching indexed arrays.
// For every X value there must
// be a matching Y value, and no
// two X values can be identical.
   $xData = preg_split("[ ]", $Xdv);
   $yData = preg_split("[ ]", $Ydv);

// Count number of XY data elements.
   $xDataCount = count($xData);
   $yDataCount = count($yData);

// Return error message if data vector element count mismatch.
// For every X value there must be a corresponding Y value
// or an XY data count mismatch error occurs.
   if ($xDataCount != $yDataCount)   {return "ERROR: XY Data Count Mismatch";}

// Number of matching data pairs.
   $n = ($xDataCount + $yDataCount) / 2;

// Read X argument for which to
// interpolate the Y value based
// on the given XY data.
   $x = trim($xArg);

// Given X, interpolate the corresponding Y value.

// Initialise y series accumulator.
   $y=0;

// Compute product series.
   for ($i=0;   $i < $n;   $i++)
       {

        $c = "1";

        for ($j=0;   $j < $n;   $j++)
            {

             if ($j != $i)
                {
                 $P = bcMul($c, bcSub($x, $xData[$j], 32), 32);
                 $Q = bcSub($xData[$i], $xData[$j], 32);
                 $c = bcDiv($P, $Q, 32);
                }

            } // Next j

//      Accumulate sum of product terms.
        $y = bcAdd($y, bcMul($c, $yData[$i], 32), 32);

       } // Next i

// Remember numerical sign of
// interpolated y as ±1
   $sign = ($y < 0)? -1 : +1;

// Round off interpolated y value to 16-decimal output limit.
   $y = bcMul($sign, bcAdd(bcMul($sign, $y, 32), "0.00000000000000005", 16), 16);

// Cut off any redundant zeros and/or decimal point from y value.
   if (StrPos($y, ".") !== FALSE) {$y = RTrim(RTrim($y, "0"), ".");}

// Done.
   return $y;

} // End of  Lagrange_Interp()



// ************************************************************************
// ************************************************************************

   function Deg_For_DMS ($SignSymb, $DMSStr)

{
   $w = trim($DMSStr);  if ($w == "") {return 0;}

   $ang = preg_replace('/\s+/', ' ', $w);
   $ang = str_replace("+", "", $ang);
   $ang = str_replace("-", "", $ang);

   if ($SignSymb != '-') {$AngSign = '+';}

   $Angsign  = ($SignSymb == '-') ? -1  :  1;

   $w1 = preg_split("[ ]", $ang);  $AngCount = count($w1);

   if ($AngCount >= 1) {$w2  = $w1[0] * 3600.0;}
   if ($AngCount >= 2) {$w2 += $w1[1] * 60.0;}
   if ($AngCount >= 3) {$w2 += $w1[2];}

   $AngDeg = $Angsign * ($w2 / 3600.0);

   return $AngDeg;

} // End of  Deg_For_DMS()


// ************************************************************************
// ************************************************************************

   function bcGCD ($ArgA, $ArgB)

{

// Convert integer arguments into absolute values.
   $A = str_replace("-", "", trim($ArgA));
   $B = str_replace("-", "", trim($ArgB));

// Equate 1st approximation for GCD to $A
   $GCD = $A;

// Perform Eclid algorithm loop until $B==0
   while ($B != 0)

         {$C = $B;     $B = bcMod($GCD, $B);     $GCD = $C;}

   return $GCD;

} // End of  bcGCD()


// ************************************************************************
// ************************************************************************

// Metrix




// ************************************************************************
// ************************************************************************


// Compute nutation in right ascension at the celestial
// equator, also known as the equation of the equinoxes,
// in degrees.
//
// This is also called the equation of the equinoxes and
// is the difference (True Equinox - Mean Equinox).
//
// NOTE:
// Degrees × 240 = Seconds of RA

   function Delta_Equinox ($JD)
{

// ---------------------------------------------
// Compute cosine of true obliquity of ecliptic.
   $CosEps = cos(Deg2Rad(Epsilon_Mean($JD) + Delta_Epsilon($JD)));

// ---------------------------------------
// Done.  Return equation of the equinoxes
// in degrees.
   return Delta_Psi($JD) * $CosEps;

} // End of  Delta_Equinox()


// ************************************************************************
// ************************************************************************

   function Delta_Psi ($JDArg)
{

// -----------------------
// Read JD argument value.
// Error if argument is not numeric.

   if (!Is_Numeric(trim($JDArg))) {return FALSE;}

// -------------------------------------------------------
// Compute powers of time in Julian centuries from J2000.0

   $T1 = ($JDArg - 2451545) / 36525;
   $T2 = $T1*$T1;
   $T3 = $T2*$T1;

// -----------------------------------------
// Compute mean lunar elongation in radians.

   $w1 = 297.85036 + 445267.11148*$T1 - 0.0019142*$T2 + ($T3 / 189474);
   $w1 = Deg2Rad($w1);

// --------------------------------------
// Compute mean solar anomaly in radians.

   $w2 = 357.52772 + 35999.05034*$T1 - 0.0001603*$T2 - ($T3 / 300000);
   $w2 = Deg2Rad($w2);

// --------------------------------------
// Compute mean lunar anomaly in radians.

   $w3 = 134.96298 + 477198.867398*$T1 + 0.0086972*$T2 + ($T3 / 56250);
   $w3 = Deg2Rad($w3);

// ----------------------------------------------
// Compute lunar argument of latitude in radians.

   $w4 = 93.27191 + 483202.017538*$T1 - 0.0036825*$T2 + ($T3 / 327270);
   $w4 = Deg2Rad($w4);

// ----------------------------------------
// Compute lunar ascending node in radians.

   $w5 = 125.04452 - 1934.136261*$T1 + 0.0020708*$T2 + ($T3 / 450000);
   $w5 = Deg2Rad($w5);

// ---------------------------------------------
// Compute the nutation in ecliptical longitude.

   $w  = sin($w5)*(-174.2*$T1 - 171996);
   $w += sin(2*($w4 + $w5 - $w1))*(-1.6*$T1 - 13187);
   $w += sin(2*($w4 + $w5))*(-2274 - 0.2*$T1);
   $w += sin(2 * $w5)*(0.2*$T1 + 2062);
   $w += sin($w2)*(1426 - 3.4*$T1);
   $w += sin($w3)*(0.1*$T1 + 712);
   $w += sin(2*($w4 + $w5 - $w1) + $w2)*(1.2*$T1 - 517);
   $w += sin(2 * $w4 + $w5)*(-0.4*$T1 - 386);
   $w += sin(2*($w4 + $w5 - $w1) - $w2)*(217 - 0.5*$T1);
   $w += sin(2*($w4 - $w1) + $w5)*(129 + 0.1*$T1);
   $w += sin($w3 + $w5)*(0.1*$T1 + 63);
   $w += sin($w5 - $w3)*(-0.1*$T1 - 58);
   $w += sin(2*$w2)*(17 - 0.1*$T1);
   $w += sin(2*($w2 + $w4 + $w5 - $w1))*(0.1*$T1 - 16);
   $w -= 301*sin(2*($w4 + $w5) + $w3);
   $w -= 158*sin($w3 - 2*$w1);
   $w += 123*sin(2*($w4 + $w5) - $w3);
   $w +=  63*sin(2*$w1);
   $w -=  59*sin(2*($w1 + $w4 + $w5) - $w3);
   $w -=  51*sin(2 * $w4 + $w3 + $w5);
   $w +=  48*sin(2*($w3 - $w1));
   $w +=  46*sin(2*($w4 - $w3) + $w5);
   $w -=  38*sin(2*($w1 + $w4 + $w5));
   $w -=  31*sin(2*($w3 + $w4 + $w5));
   $w +=  29*sin(2*$w3);
   $w +=  29*sin(2*($w4 + $w5 - $w1) + $w3);
   $w +=  26*sin(2*$w4);
   $w -=  22*sin(2*($w4 - $w1));
   $w +=  21*sin(2*$w4 + $w5 - $w3);
   $w +=  16*sin(2*$w1 - $w3 + $w5);
   $w -=  15*sin($w2 + $w5);
   $w -=  13*sin($w3 + $w5 - 2*$w1);
   $w -=  12*sin($w5 - $w2);
   $w +=  11*sin(2*($w3 - $w4));
   $w -=  10*sin(2*($w4 + $w1) + $w5 - $w3);
   $w -=   8*sin(2*($w4 + $w1 + $w5) + $w3);
   $w +=   7*sin(2*($w4 + $w5) + $w2);
   $w -=   7*sin($w3 - 2*$w1 + $w2);
   $w -=   7*sin(2*($w4 + $w5) - $w2);
   $w -=   7*sin(2*$w1 + 2*$w4 + $w5);
   $w +=   6*sin(2*$w1 + $w3);
   $w +=   6*sin(2*($w3 + $w4 + $w5 - $w1));
   $w +=   6*sin(2*($w4 - $w1) + $w3 + $w5);
   $w -=   6*sin(2*($w1 - $w3) + $w5);
   $w -=   6*sin(2*$w1 + $w5);
   $w +=   5*sin($w3 - $w2);
   $w -=   5*sin(2*($w4 - $w1) + $w5 - $w2);
   $w -=   5*sin($w5 - 2*$w1);
   $w -=   5*sin(2*($w3 + $w4) + $w5);
   $w +=   4*sin(2*($w3 - $w1) + $w5);
   $w +=   4*sin(2*($w4 - $w1) + $w2 + $w5);
   $w +=   4*sin($w3 - 2*$w4);
   $w -=   4*sin($w3 - $w1);
   $w -=   4*sin($w2 - 2*$w1);
   $w -=   4*sin($w1);
   $w +=   3*sin(2 * $w4 + $w3);
   $w -=   3*sin(2*($w4 + $w5 - $w3));
   $w -=   3*sin($w3 - $w1 - $w2);
   $w -=   3*sin($w2 + $w3);
   $w -=   3*sin(2*($w4 + $w5) + $w3 - $w2);
   $w -=   3*sin(2*($w1 + $w4 + $w5) - $w2 - $w3);
   $w -=   3*sin(2*($w4 + $w5) + 3*$w3);
   $w -=   3*sin(2*($w1 + $w4 + $w5) - $w2);

// ----------------------------------
// Done.  Return ecliptical longitude
// expressed in degrees.

   return $w / 36000000;

  } // End of  Delta_Psi()











   function Deg_For_HMS ($SignNumArg, $HMSarg)
{

// -----------------------------------
// Read and remember numerical ± sign.
   $sign = ($SignNumArg < 0) ?  "-" : "";

// -------------------------------------------------
// Normalize the spacing of the hour angle elements.
// There must be at least one space between each of
// the HH MM SS arguments as separators.
   $hms = preg_replace('/\s+/', ' ', trim($HMSarg));

// ----------------------------------------------
// Set empty angle string to default = 0 degrees.
   if ($hms == "") {$hms = 0;}
   $w = split('[ ]', $hms);
   $AngleCount = count($w);

// --------------------------------------------
// Error if any angular element is non-numeric.
   if ($AngleCount >= 1)
      {if (!Is_Numeric($w[0])) {return FALSE;}}

   if ($AngleCount >= 2)
      {if (!Is_Numeric($w[1])) {return FALSE;}}

   if ($AngleCount >= 3)
      {if (!Is_Numeric($w[2])) {return FALSE;}}

// ----------------
// Read HMS values.
   if ($AngleCount >= 1) {$hh = $w[0];} else {$hh=0;}
   if ($AngleCount >= 2) {$mm = $w[1];} else {$mm=0;}
   if ($AngleCount >= 3) {$ss = $w[2];} else {$ss=0;}

// --------------------------------------------
// Compute total seconds per each time element.
   $hhss = bcMul($hh, "3600", 24);
   $mmss = bcMul($mm, "60",   24);
   $Tsec = bcAdd_Seq("$hhss $mmss $ss", 24);

// ---------------------------------------
// Compute decimal degrees to 16 decimals,
// recalling numerical sign.
   $deg = $sign . bcRound(bcDiv($Tsec, "240", 24), 16);
   if ($deg == "-0") {$deg = "0";}

// -----
// Done.
   return  $deg;

} // End of  Deg_For_HMS()


// ************************************************************************
// ************************************************************************

// This BC math function adds a sequence of numbers
// to the specified decimals of precision.
//
// Data string format = "1.1  2.22  3.333"
// Series of space-delimited numerical arguments
// to be summed.

   function bcAdd_Seq ($SeqStrArg, $NumDecimalsArg=0)

{

// ----------------------------------------------
// Remove redundant white space from data vector.

   $SeqStr = preg_replace('/\s+/', ' ', trim($SeqStrArg));

// -----------------------
// Get number of decimals.

   $d = trim($NumDecimalsArg);

// -----------------------------------------------
// Separate items to be summed into working array.

   $item = split ("[ ]", trim($SeqStr));

// -------------------------
// Count items to be summed.

   $ItemCount = count($item);

// --------------------------------
// Handle case of empty items list.

   if ($ItemCount == 0) {return "0";}

// -----------------------------------
// Handle case of single item in list.

   if ($ItemCount == 1) {return $item[0];}

// -------------------
// Sum the items list.

   $sum = "0";

   for ($i=0;  $i < $ItemCount;   $i++)
       {
        $sum = bcAdd($sum, $item[$i], $d+8);
       }

   return bcAdd("0", $sum, $d);

} // End of  bcAdd_Seq()


// ************************************************************************
// ************************************************************************

// This BC math function multiplies a sequence of
// numbers to the specified decimals of precision.
//
// Data string format = "1.1  2.22  3.333"
// Series of space-delimited numerical arguments
// to be multiplied.

   function bcMul_Seq ($SeqStrArg, $NumDecimalsArg)

{
   $SeqStr = preg_replace('/\s+/', ' ', trim($SeqStrArg));

   $d = trim($NumDecimalsArg);

   $item = split ("[ ]", $SeqStr);

   $ItemCount = count($item);

   $prod = "1";

   if ($ItemCount == 0) {return "0";}

   if ($ItemCount == 1) {return bcAdd("0", $item[0], $d);}

   for ($i=0;  $i < $ItemCount;   $i++)
       {
        $prod = bcMul($prod, $item[$i], $d+5);
       }

   $prod = bcAdd("0", $prod, $d);

   return $prod;

} // End of  bcMul_Seq()

// ************************************************************************
// ************************************************************************



// ************************************************************************
// ************************************************************************

   function bcRound ($xArgStr, $NumDecimals=0)

{
  $sign = ($xArgStr < 0) ? "-" : "";

  $x = str_replace("-", "", $xArgStr);

  $n = $NumDecimals;

  return $sign . bcAdd($x, "0." . str_repeat("0", $n) . "5", $n);

} // End of  bcRound()


// ************************************************************************
// ************************************************************************
// General integer factorial function.
//
// Argument must be non-negative integer.
//
// ERRORS:
// On error, zero is returned.

   function bcFactorial ($PosIntArg)

{

// --------------------
// Read argument value.

   $j = trim($PosIntArg);

// --------------------------------------
// Set empty argument to zero by default.

   if ($j == "") {$j = "0";}

// ---------------------------------
// Error if argument is non-numeric.

   if (!Is_Numeric($j)) {return 0;}

// ----------------------------------------
// Trim off redundant zeros and/or decimal.

   if (StrPos($j, ".") !== FALSE)
      {
       $j = RTrim(RTrim($j, "0"), ".");
      }

// ----------------------------------------------------
// Error if modified argument still contains a decimal.

   if (StrPos($j, ".") !== FALSE) {return "0";}

// ---------------------
// Error if argument < 0

   if ($j < 0) {return "0";}

// ---------------------------------
// Handle cases of argument = 0 or 1

   if ($j <= 1)  {return "1";}

// ----------------------------------
// Loop to compute factorial product.

   $prod = "1";

   for ($i=1;   $i <= $j;   $i++)
       {
        $prod = bcMul($prod, $i);
       }

// -----
// Done.

   return $prod;

} // End of  bcFactorial()


// ************************************************************************
// ************************************************************************

    function bcReduce_Frac ($FracStrArg)

{
   $frac = split ("[/]", $FracStrArg);

   $A = $frac[0];
   $B = $frac[1];

   if ($A < 0 && $B < 0)
      {
       $A = str_replace("-", "", $A);
       $B = str_replace("-", "", $B);
      }

   $GCD = bcGCD ($A, $B);

// ---------------------------------------
// Reduce the (A,B) values to lowest terms
// by dividing them each by the GCD value,
// replacing the original (A,B) values.
// If GCD=1,then the fraction cannot be
// reduced to any lower terms and the
// fraction string remains unchanged.

   $A = bcDiv($A, $GCD);
   $B = bcDiv($B, $GCD);

// ----
// Done.

   return "$A/$B";

} // End of  bcReduce_Frac()


// ************************************************************************
// ************************************************************************





// ************************************************************************
// ************************************************************************

   function Random_Digits ($NumDigits, $base=10)

{


// -------------------------------
// Read input arguments.
   $n = abs(floatval($NumDigits));
   $b = floatval($base);

// Define available digits according to base (b).
   $AvailDigits = substr("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ", 0, $b);

// -----------------------------------
// Define random digits output string.

   $RandomDigits = "";

// -------------------------------------------
// Construct an n-digit random sequence in the
// given base, one digit at a time using a
// random 50/50 digit alternation method.
// There must be at least one digit.

   for ($i=0;   $i < $n;   $i++)
       {
        if (MT_Rand() % 2 == 0)

           {$RandomDigits .= substr($AvailDigits, MT_Rand(0, $b-1), 1);}
        else
           {$RandomDigits  = substr($AvailDigits, MT_Rand(0, $b-1), 1) . $RandomDigits;}
       }

   return "$RandomDigits";

} // End of  Random_Digits()


// ************************************************************************
// ************************************************************************

    function Encrypt_String ($MssgStr, $key=0)

   {

   $mssg = $MssgStr;

   $MssgLen = strlen($MssgStr);

   $nnn = "";

   for ($i=0;   $i < $MssgLen;   $i++)
   {

   $char = substr($MssgStr, $i, 1);
   $code = sprintf("%03d", ord($char)+36);

   $nnn .= $code;

   }

// Generate 0.5xx where xx = 2 random digits (0 to 9)
// and add to nnnn.

   $nnnn = $nnn . ".5" . mt_rand(0,9) . mt_rand(0,9);

// Attach 3 random digits (1 to 9 only) to
// beginning of nnnn (leftmost end).
   $nnnn =  mt_rand(1,9) . mt_rand(1,9).  mt_rand(1,9) . $nnnn;

// Compute square root of nnnn to q deccimals.

   $q = 5 + floor(log10($nnnn));

   $y = bcSqRt($nnnn, $q);

// Reverse digit strings on both sides of decimal.
   $w = preg_split("[.]", $y);
   $a = "$w[0]";
   $b = "$w[1]";
   $y = strrev($a) . "." . strrev($b);

// Attach random digit (1 to 9) to both ends of number.
   $y = mt_rand(1,9) . $y . mt_rand(1,9);


 /*
    $z = bcmul($y, $y);
    $out = "$mssg\n$nnn\n$nnnn\n$y\n$z";
*/

// Apply alphanumeric obfuscation


/*
   if (mt_rand() %2 == 0) {$y = str_replace("0", "z", $y);}
   if (mt_rand() %3 == 0) {$y = str_replace("1", "o", $y);}
   if (mt_rand() %4 == 0) {$y = str_replace("4", "f", $y);}
   if (mt_rand() %3 == 0) {$y = str_replace("6", "s", $y);}
   if (mt_rand() %2 == 0) {$y = str_replace("9", "n", $y);}
*/

   $y = an_obfuscate ($y, 0, "z");
   $y = an_obfuscate ($y, 1, "o");
   $y = an_obfuscate ($y, 4, "f");
   $y = an_obfuscate ($y, 6, "s");
   $y = an_obfuscate ($y, 9, "n");


   $y = str_replace(".", "-", $y);

   $y = StrToUpper($y);

   $y = str_replace("O", "o", $y);

   return $y;

   }


// ************************************************************************
// ************************************************************************

  function Decrypt_String ($EncStr, $key=0)
{

// Remove alphanumeric obfuscation
   $x = str_replace("z", "0", StrToLower($EncStr));
   $x = str_replace("o", "1", $x);
   $x = str_replace("f", "4", $x);
   $x = str_replace("s", "6", $x);
   $x = str_replace("n", "9", $x);
   $x = str_replace("-", ".", $x);



// Cut off random digits on each end of number
   $x = substr($x, 1, strlen($x)-2);

// Reverse digit strings on both sides of decimal.
   $w = preg_split("[.]", $x);
   $a = "$w[0]";
   $b = "$w[1]";

   $EncMssg = strrev($a) . "." . strrev($b);

   $w = bcMul($EncMssg, $EncMssg);
   $x = substr($w, 3, strlen($w));

// Convert each group of 3 digits into character codes
// and reconstruct original message string.
   $counter = strlen($x) / 3;

   $MssgStr = "";

   for ($i=0;   $i < $counter;   $i++)
   {
    $code = substr($x, 3*$i, 3) - 36;
    $char = chr($code);
    $MssgStr .= $char;
    }

  return $MssgStr;

}





// ************************************************************************
// ************************************************************************

   function an_obfuscate ($ArbNumStr, $digit, $RChar)

{

   $out = "";

   $x = $ArbNumStr;


   for ($i=0;   $i < strlen($x);   $i++)
   {
   $y = substr($x, $i, 1);
   if ($y == $digit && $y != "." && mt_rand() %2 == 0) {$out .= $RChar;} else {$out .= $y;}
   }

   return $out;

}


// ************************************************************************
// ************************************************************************


// ************************************************************************
// ************************************************************************










// ************************************************************************
// ************************************************************************

   function bcQuad_Solve($Aarg, $Barg, $Carg)

{

// ---------------------
// Read A,B,C arguments.

   $A = trim($Aarg);
   $B = trim($Barg);
   $C = trim($Carg);

// --------------------------------
// Set internal decimals precision.

   $DP = 20;

// ------------------------------------------
// Compute discriminant D.  If negative, then
// the solutions are complex (imaginary).

   $w1 = bcMul($B, $B, $DP); // B²

   $w2 = bcMul("4", bcMul($A, $C, $DP), $DP); // 4AC

    $D = bcSub($w1, $w2, $DP);

// -----------------------------------------------
// Determine if quadratic root is real or complex.

   $i = "";

   if (bcComp($D, "0", $DP) < 0)

      {
       $i = "<B>i</B>";  $D = bcSub("0", $D, $DP);
      }

//  --------------------------
//  Compute values of u and v.

    $u = bcDiv(bcSub("0", $B, $DP), bcMul("2", $A, $DP), $DP); // -B/2A

   $w3 = bcSqRt($D, $DP); // SqRt(B² - 4AC) = SqRt(D)

    $v = bcDiv($w3, bcMul("2", $A, $DP), $DP); // SqRt(B² - 4AC) / 2A

// -----------------------------
// Do this if roots are complex.

   if ($i != "")
      {
       $u = RTrim(RTrim($u, "0"), ".");
       $v = RTrim(RTrim($v, "0"), ".");
       return "<PRE>x = $u &plusmn; $v$i</PRE>";
      }

// --------------------------
// Do this if roots are real.

   $x1 = RTrim(RTrim(bcSub($u, $v, 16), "0"), ".");
   $x2 = RTrim(RTrim(bcAdd($u, $v, 16), "0"), ".");
   return "<PRE>x1 = $x1\nx2 = $x2</PRE>";


} // End of  Quad_Solve()

// ************************************************************************
// ************************************************************************



// ************************************************************************
// ************************************************************************



// ************************************************************************
// ************************************************************************



// ************************************************************************
// ************************************************************************



// ************************************************************************
// ************************************************************************



// ************************************************************************
// ************************************************************************



// ************************************************************************
// ************************************************************************



// ************************************************************************
// ************************************************************************



// ************************************************************************
// ************************************************************************



// ************************************************************************
// ************************************************************************



// ************************************************************************
// ************************************************************************



// ************************************************************************
// ************************************************************************



// ************************************************************************
// ************************************************************************



// ************************************************************************
// ************************************************************************




   function Days_For_HMS ($sign, $hh, $mm, $ss)

{

// -----------------------------------------------
// Read numerical sign argument.
// Where:  -1=Neg  or  1=Pos
// Then use sign symbol.

   $SignSymbol = ($sign < 0) ? '-' : '+';

// ------------------------------------------
// Compute day fraction corresponding to time

   $w1 = bcMul("3600", $hh, 18);
   $w2 = bcMul("60",   $mm, 18);

   $w3 = bcAdd($w1, $w2, 18);
   $w4 = bcAdd($w3, $ss, 18);

   $w5 = bcDiv($w4, "86400", 18);

   $w5 = bcAdd($w5, "0.00000000000000005", 16);

   $DayFrac = RTrim(RTrim($w5, "0"), ".");

   return "$SignSymbol$DayFrac";

} // End of  Days_For_HMS ()


// ************************************************************************
// ************************************************************************


/*

   *************************************************
   Compute the nutation in Epsilon, Delta Epsilon or
   nutation in obliquity of the ecliptic, in degrees.

   This is the correction to apply to the MEAN value
   of the obliquity to obtain the TRUE obliquity.

   The general precision level is  ±0.001 arc sec.

   This function is based on the 1980 IAU theory.

   $JD = JD number corresponding to any date and time

   $t  = Julian time factor as reckoned from J2000
   $t2 = $t to the power of 2
   $t3 = $t to the power of 3

   ==============================================
   Nutation correction elements (1980 IAU Theory)

   $w1 = Mean elongation of the moon from the sun
   $w2 = Mean anomaly of the sun
   $w3 = Mean anomaly of the moon
   $w4 = Argument of latitude of the moon
   $w5 = Longitude of lunar ascending node

   $w6 = Nutational series accumulator

*/

   Function Delta_Epsilon ($JD)
{

// Compute time factor in Julian centuries as
// reckoned from J2000 and its powers.
   $T1 = ($JD - 2451545) / 36525;
   $T2 = $T1 * $T1;
   $T3 = $T2 * $T1;

// -----------------------------------------
// Compute mean lunar elongation in radians.

   $w1 = 297.85036 + 445267.11148*$T1 - 0.0019142*$T2 + ($T3 / 189474);
   $w1 = Deg2Rad($w1);

// --------------------------------------
// Compute mean solar anomaly in radians.

   $w2 = 357.52772 + 35999.05034*$T1 - 0.0001603*$T2 - ($T3 / 300000);
   $w2 = Deg2Rad($w2);

// --------------------------------------
// Compute mean lunar anomaly in radians.

   $w3 = 134.96298 + 477198.867398*$T1 + 0.0086972*$T2 + ($T3 / 56250);
   $w3 = Deg2Rad($w3);

// ----------------------------------------------
// Compute lunar argument of latitude in radians.

   $w4 = 93.27191 + 483202.017538*$T1 - 0.0036825*$T2 + ($T3 / 327270);
   $w4 = Deg2Rad($w4);

// -----------------------------------------------------
// Compute longitude of lunar ascending node in radians.

   $w5 = 125.04452 - 1934.136261*$T1 + 0.0020708*$T2 + ($T3 / 450000);
   $w5 = Deg2Rad($w5);

// ---------------------------------------------------
// Compute the nutation in obliquity (ArcSec * 10000).

   $w6  = cos($w5)*(92025 + 8.9*$T1);
   $w6 += cos(2*($w4 - $w1 + $w5))*(5736 - 3.1*$T1);
   $w6 += cos(2*($w4 + $w5))*(977 - 0.5*$T1);
   $w6 += cos(2*$w5)*(0.5*$T1 - 895);
   $w6 += cos($w2)*(54 - 0.1*$T1);
   $w6 += cos($w2 + 2*($w4 - $w1 + $w5))*(224 - 0.6*$T1);
   $w6 += cos($w3 + 2*($w4 + $w5))*(129 - 0.1*$T1);
   $w6 += cos(2*($w4 - $w1 + $w5) - $w2)*(0.3*$T1 - 95);
   $w6 += 200*cos(2*$w4 + $w5);
   $w6 -=  70*cos(2*($w4 - $w1) + $w5);
   $w6 -=  53*cos(2*($w4 + $w5) - $w3);
   $w6 -=  33*cos($w3 + $w5);
   $w6 +=  26*cos(2*($w1 + $w4 + $w5) - $w3);
   $w6 +=  32*cos($w5 - $w3);
   $w6 +=  27*cos($w3 + 2*$w4 + $w5);
   $w6 -=  24*cos(2*($w4 - $w3) + $w5);
   $w6 +=  16*cos(2*($w1 + $w4 + $w5));
   $w6 +=  13*cos(2*($w3 + $w4 + $w5));
   $w6 -=  12*cos($w3 + 2*($w4 - $w1 + $w5));
   $w6 -=  10*cos(2*$w4 + $w5 - $w3);
   $w6 -=   8*cos(2*$w1 - $w3 + $w5);
   $w6 +=   7*cos(2*($w2 - $w1 + $w4 + $w5));
   $w6 -=   7*cos($w3);
   $w6 +=   9*cos($w2 + $w5);
   $w6 +=   7*cos($w3 + $w5 - 2*$w1);
   $w6 +=   6*cos($w5 - $w2);
   $w6 +=   5*cos(2*($w1 + $w4) - $w3 + $w5);
   $w6 +=   3*cos($w3 + 2*($w4 + $w1 + $w5));
   $w6 -=   3*cos($w2 + 2*($w4 + $w5));
   $w6 +=   3*cos(2*($w4 + $w5) - $w2);
   $w6 +=   3*cos(2*($w1 + $w4) + $w5);
   $w6 -=   3*cos(2*($w3 + $w4 + $w5 - $w1));
   $w6 -=   3*cos($w3 + 2*($w4 - $w1) + $w5);
   $w6 +=   3*cos(2*($w1 - $w3) + $w5);
   $w6 +=   3*cos(2*$w1 + $w5);
   $w6 +=   3*cos(2*($w4 - $w1) + $w5 - $w2);
   $w6 +=   3*cos($w5 - 2*$w1);
   $w6 +=   3*cos(2*($w3 + $w4) + $w5);

// -----------------------------------
// Done.  Return nutation in obliquity
// expressed in degrees.

   return $w6 / 36000000;

} // End of  Delta_Epsilon()












/*

   ************************************************************************
   Compute the mean  obliquity of the ecliptic in degrees for the
   current JD number argument at any instant.

   This ecliptic obliquity function is based on a formula derived
   by J. Laskar, Astronomy and Astrophysics, 1968, Vol. 157, p68.

   The estimated accuracy of this formula is ±0.01 arc second between
   the years 1000 AD and 3000 AD and a few arc seconds after 10,000
   years.  It is only valid in the range ±10,000 years either way
   of J2000.0

   Over the long term, it is more accurate than the formula
   adopted by the International Astronomical Union (IAU)
   for general ephemeris computations.

   ---------
   ARGUMENTS

   $JD = General JD number for any date and time.


   ------
   ERRORS

   An error results and FALSE is returned if the
   JD argument is not a valid numeric string.

*/


   function Epsilon_Mean ($JD)

{


// ------------------------------------
// ERROR if JD argument is not numeric.

   if (!is_numeric($JD)) {return FALSE;}

// ----------------------------------------------
//  Compute the time in Julian centuries reckoned
//  from J2000.0 corresponding to the JD argument
//  and then divide by 100 for decimillennia.

   $t = ($JD - 2451545.0) / 36525 / 100;

// -----------------------------
// Compute mean obliquity of the
// ecliptic in arc seconds.

   $p = $t*$t;

   $EpsMeanSS = 84381.448 - 4680.93*$t;
   $EpsMeanSS -=    1.55*$p;  $p *= $t;
   $EpsMeanSS += 1999.25*$p;  $p *= $t;
   $EpsMeanSS -=   51.38*$p;  $p *= $t;
   $EpsMeanSS -=  249.67*$p;  $p *= $t;
   $EpsMeanSS -=   39.05*$p;  $p *= $t;
   $EpsMeanSS +=    7.12*$p;  $p *= $t;
   $EpsMeanSS +=   27.87*$p;  $p *= $t;
   $EpsMeanSS +=    5.79*$p;  $p *= $t;
   $EpsMeanSS +=    2.45*$p;

// ---------------------------------
// Compute mean obliquity in degrees
// from the arc seconds value.

   $EpsMeanDeg = $EpsMeanSS / 3600.0;

// -----
// Done.

   return $EpsMeanDeg;

} // End of  Epsilon_Mean()




// ************************************************************************
// ************************************************************************
// THIS IS THE CALENDAR FUNCTIONS BLOCK






// THIS FUNCTION RETURNS THE SIMPLE JD NUMBER FOR ANY GIVEN CALENDAR DATE
// ON THE JULIAN AND GREGORIAN CALENDARS.   THIS VALUE WILL ALWAYS EQUATE
// TO A POSITIVE INTEGER VALUE.   TECHNICALLY, IT REFERS TO THE JD NUMBER
// FOR 12:00 NOON ON THE DATE.   TO OBTAIN THE ASTRONOMICAL JD NUMBER FOR
// 00h ON THE DATE, SIMPLY SUBTRACT 0.5 FROM THIS VALUE.

   function JD_For_ymd ($ymd, $CalMode=1)

{

// ----------------------------------------------
// EXTRACT INDIVIDUAL DATE ARGUMENTS (y,m,d) FROM
// WITHIN INTEGER ENCODED DATE ARGUMENT (ymd).

   $w = floor(abs($ymd) / 10000);
   $y = (($ymd < 0) ? -1 : 1) * $w;
   $m = floor((abs($ymd) - 10000*$w) / 100);
   $d = (abs($ymd) - 10000*$w - 100*$m);

   $a = floor((14-$m) / 12);
   $b = (($y < 0) ? $y+1 : $y) - $a;
   $c = floor($b/100);

// --------------------------------------
// COMPUTE SIMPLE JD FOR DATE (AT 12:00).
// THIS VALUE WILL ALWAYS EQUATE TO A
// POSITIVE INTEGER VALUE.

   $JD = floor(30.6001*(12*$a + $m + 1))
       + floor(365.25*($b + 4716)) - 1524 + $d
       + $CalMode*(floor($c/4) - $c + 2);

   return $JD;

} // End of  JD_For_ymd()

// ************************************************************************
// ************************************************************************

   function JD_For_ymdhms ($ymd, $CalMode, $hh=0, $mm=0, $ss=0)

{

// ----------------------------------------------
// EXTRACT INDIVIDUAL DATE ARGUMENTS (y,m,d) FROM
// WITHIN INTEGER ENCODED DATE ARGUMENT (ymd).

   $w = floor(abs($ymd) / 10000);
   $y = (($ymd < 0) ? -1 : 1) * $w;
   $m = floor((abs($ymd) - 10000*$w) / 100);
   $d = (abs($ymd) - 10000*$w - 100*$m);

   $a = floor((14-$m) / 12);
   $b = (($y < 0) ? $y+1 : $y) - $a;
   $c = floor($b/100);

// -----------------------------------
// COMPUTE UT TIME FRACTION OF THE DAY
// TO 20 DECIMALS.  FINAL RESULT WILL
// BE ROUNDED OFF TO 16 DECIMALS.

   $decimals = 20;
   $w1 = bcMul("3600", "$hh", $decimals);
   $w2 = bcMul("60",   "$mm", $decimals);
   $w3 = bcAdd(bcAdd($w1, $w2, $decimals), "$ss", $decimals);
   $w4 = bcDiv($w3, "86400", $decimals);
   $UTFrac = bcSub($w4, "0.5", $decimals);


// --------------------------------------
// COMPUTE SIMPLE JD FOR DATE (AT 12:00).
// THIS VALUE WILL ALWAYS EQUATE TO A
// POSITIVE INTEGER VALUE.

   $JD = floor(30.6001*(12*$a + $m + 1))
       + floor(365.25*($b + 4716)) - 1524 + $d
       + $CalMode*(floor($c/4) - $c + 2);

// ---------------------------------
// ADD TIME FRACTION AND ROUND FINAL
// JD VALUE TO 16 DECIMAL PLACES.

   $JD = bcAdd($JD, $UTFrac, $decimals);
   $JD = bcAdd($JD, "0.00000000000000005", 16);
   $JD = RTrim(RTrim($JD, "0"), ".");

   return $JD;

} // End of  JD_For_ymdhms()

// ************************************************************************
// ************************************************************************


// THIS FUNCTION SERVES AS AN INVERSE JD FUNCTION.  GIVEN ANY GENERAL JD
// NUMBER AND CALENDAR MODE, IT RETURNS THE CORRESPONDING SIGNED INTEGER
// ENCODED DATE (ymd). THE GENERAL JD VALUE IS NOT RESTRICTED TO INTEGER
// VALUES ONLY.  ANY FRACTIONAL PART CORRESPONDING TO THE TIME OF DAY IS
// IGNORED, SINCE ONLY THE DATE ON THE CALENDAR APPLIES HERE.


  function ymd_For_JD ($JD, $CalMode=1)

  {

// --------------------------------
// COMPUTE JD12 VALUE FOR DATE FROM
// THE GENERAL JD INPUT ARGUMENT.

   $JD12 = floor($JD + 0.5);

// --------------------------
// ACCOUNT FOR CALENDAR MODE.

   $e = $CalMode * floor(($JD12 - 1867216.25) / 36524.25);
   $f = $JD12 + $CalMode * ($e - floor($e/4) + 1);

// -------------------------
// AUXILIARY WORK VARIABLES.

   $g = $f + 1524;
   $h = floor(($g - 122.1) / 365.25);
   $i = floor(365.25 * $h);
   $j = floor(($g - $i) / 30.6001);

// -----------------------------------
// COMPUTE THE CALENDAR DATE ELEMENTS.

   $d = $g - $i - floor(30.6001 * $j);
   $m = $j - 12*floor($j/14) - 1;
   $w = $h - 4716 + floor((14-$m) / 12);

// -----------------------------------------
// ADJUST FOR CALENDAR YEAR CONVENTION USED,
// WHERE: NEG YEAR = BC YEAR

   $y = ($w < 1) ? $w-1 : $w;

// ------------------------------------------------------
// CONSTRUCT INTEGER ENCODED DATE CONTAINING THE CALENDAR
// DATE ELEMENTS IN A SINGLE ± INTEGER VALUE.

   $ymd = (($y < 0) ? -1 : 1) * (10000*abs($y) + 100*$m + $d);

   return $ymd;

} // End of  ymd_For_JD()


// ************************************************************************
// ************************************************************************


// THIS BOOLEAN FUNCTION INDICATES WHETHER OR NOT A GIVEN DATE IS VALID.


   function Is_Valid_Date ($ymd, $CalMode=1)

{

// -----------------------------
// COMPUTE JD FOR 12:00 ON DATE.

   $JD = JD_For_ymd($ymd, $CalMode);

// ---------------------------------------------------------
// NOW, REVERSE THE PROCESS AND COMPUTE A CHECK DATE VALUE
// FROM THE PREVIOUSLY COMPUTED (JD) VALUE.

   $CheckDate = ymd_For_JD($JD, $CalMode);

// ------------------------------------------------------------------
// IF THE CHECK DATE VALUE PERFECTLY MATCHES THE INPUT DATE ARGUMENT,
// THEN THE DATE IS OK (TRUE), ELSE THE DATE IS INVALID (FALSE).

   if ($CheckDate == $ymd) {return TRUE;} else {return FALSE;}

} // End of  Is_Valid_Date()


// ************************************************************************
// ************************************************************************


   function Nth_Sunday ($N, $y, $m, $CalMode=1)
{

   $sign = ($y < 0)? -1 : 1;
   $d = 1;

// Compute signed integer encoded calendar date.
   $ymd = $sign*($sign*10000*$y + 100*$m + $d);

   $JD12A = JD_For_ymd ($ymd, $CalMode);

// Compute JD12 for nth Sunday.
   $JD12B = $JD12A + (7 - ($JD12A + 1) % 7) % 7 + 7*($N-1);

// Compute integer encoded date of nth Sunday.
   $NthSunday = ymd_For_JD ($JD12B, $CalMode);

// Done.
   return $NthSunday;

} // End of  Nth_Sunday()


// ************************************************************************
// ************************************************************************


   function Final_Sunday ($y, $m, $CalMode=1)

{
   $sign = ($y < 0)? -1 : 1;
   $Y    = $sign * $y;
   $M    = $m + 1;
   $d    = 1;

   if ($M == 13) {$M=1;  $Y = $Y+1;}

   $ymdA = $sign * (($Y * 10000) + ($M * 100) + $d);

   $JD12A = JD_For_ymd($ymdA, $CalMode) - 7;

   $JD12B = $JD12A + (7 - ($JD12A + 1) % 7) % 7;

   $ymdB = ymd_For_JD($JD12B, $CalMode);

   return $ymdB;

} // End of  Final_Sunday()


// ************************************************************************
// ************************************************************************


   function Days_In_Month ($y, $m, $CalMode=1)

{
// Account for BC or AD year as indicated.
   if ($y > 0)  {$w = $y;} else {$w = $y+1;}

// Determine if year is a leap year according to the Julian
// calendar and set the leap year flag accordingly.
   if ($w % 4 == 0)  {$leap = 1;} else {$leap = 0;}

// If the calendar mode is Gregorian, then apply the new
// leap year rule and set the leap year flag accordingly.
   if ($CalMode == 1 && $w % 100 == 0)
      {
       if ($w % 400 == 0)  {$leap = 1;} else {$leap = 0;}
      }

// Compute the number of days in the given month.
   $u = floor(($m-1) / 7);
   $w = $m % 2;
   $days = 30 + $w - 2*($m == 2) + ($m == 2 && $leap == 1) - 2*$u*$w + $u;

// Done.
   return $days;

} // End of  Days_In_Month()


// ************************************************************************
// ************************************************************************


// THIS FUNCTION RETURNS THE WEEKDAY NAME STRING (Sunday TO Saturday)
// CORRESPONDING TO ANY GIVEN CALENDAR DATE.


   function DoW_Str_For_ymd ($ymd, $CalMode=1)

{

// --------------------------
// DEFINE WEEKDAY NAMES LIST.

   $weekdays = "Sunday   Monday   Tuesday  WednesdayThursday Friday   Saturday";

// --------------------
// COMPUTE JD FOR DATE.

   $JD = JD_For_ymd($ymd, $CalMode);

// -----------------------------------------------------
// GET DAY OF WEEK NAME SUBSTRING FROM ($WEEKDAYS) LIST.

   $DoW = trim(substr($weekdays, 9*(($JD + 1) % 7), 9));

   return $DoW;

} // End of  DoW_Str_For_ymd()


// ************************************************************************
// ************************************************************************


// THIS FUNCTION RETURNS THE FULL MONTH NAME STRING
// CORRESPONDING TO A GIVEN MONTH NUMBER (1 to 12).


   function Month_Str ($m)
{

// -------------------------
// DEFINE MONTH NAMES TABLE.

   $months = "January  February March    April    May      June     July     August   SeptemberOctober  November December ";

// ------------------------------------------------
// IF MONTH NUMBER (m) IS WITHIN THE RANGE 1 TO 12,
// THEN RETURN THE MONTH NAME STRING, OTHERWISE
// RETURN AN EMPTY STRING TO INDICATE AN ERROR.

   if ($m > 0 && $m < 13)

      {return trim(substr($months, 9*($m-1), 9));}
   else
      {return "";}


} // End of  Month_Str()



// ************************************************************************
// ************************************************************************


// THIS FUNCTION RETURNS THE ymd OF THE nth DoW OF A GIVEN y, m
//
// IT IS USED TO FIND SUCH THINGS AS THE 4th THURSDAY OR 3rd MONDAY,
// ETC., OF ANY MONTH OF ANY GIVEN YEAR.


   function nth_DoW_In_ym ($n, $DoW, $y, $m, $CalMode=1)
{

// ------------------------------------------------
// CONSTRUCT INTEGER ENCODED DATE VALUE FOR 1st DAY
// OF MONTH (m) OF YEAR (y).

   $ym01 = (($y < 0) ? -1 : 1)*(10000*abs($y) + 100*$m + 1);

// ---------------------------------------
// COMPUTE JD NUMBER FOR 1st DAY OF MONTH.

   $JD1 = jd_for_ymd ($ym01, $CalMode);

// ---------------------------------
// COMPUTE DoW FOR 1st DAY OF MONTH.

   $DoW1 = ($JD1 + 1) % 7;

// ------------------------------
// COMPUTE OFFSET FROM 1st DAY OF
// MONTH TO 1st DoW IN MONTH.

   $w = $DoW - $DoW1;

   $offset = $w + (($w < 0) ? 7 : 0);

// --------------------------------------
// COMPUTE JD NUMBER OF Nth DoW OF MONTH.

   $JD = $JD1 + $offset + 7*($n-1);

// ---------------------------------------
// CALL THE INVERSE JD FUNCTION TO COMPUTE
// THE DATE CORRESPONDING TO THE JD.

   $ymd = ymd_for_jd ($JD, $CalMode);

   return $ymd;

} // End of  nth_DoW_In_ym()












// ************************************************************************
// ************************************************************************


// THIS FUNCTION GENERATES A RANDOM INTEGER ENCODED
// DATE THAT CAN BE USED FOR EXAMPLE PROBLEMS.  ANY
// DATES PRIOR TO OCT 15th, 1582, WILL BE JULIAN
// CALENDAR DATES, OTHERWISE GREGORIAN DATES.

   function random_ymd ()
{

// --------------------------------------------
// GENERATE A RANDOM CALENDAR DATE IN THE RANGE
// FROM JAN 1st, 4713 BC  T O DEC 31st, 9999 AD

   $RandomJD  = MT_Rand(0, 5373484);

// -------------------------------------------
// SET CALENDAR MODE ACCORDING TO RANDOM DATE.

   $CalMode = ($RandomJD > 2299160) ? 1 : 0;

// ----------------------------------------------
// RETURN THE DATE CORRESPONDING TO THE RANDOM JD

   return ymd_for_jd ($RandomJD, $CalMode);

} // End of  random_ymd()



// ************************************************************************
// ************************************************************************

// SIMPLE TEXT VERSION CALENDAR FOR USE WITH THE PRE TAG.
// NEGATIVE y = BC YEAR


   function Calendar_Text ($y, $m, $CalMode=1)

{

// ----------------------------------
// READ INPUT ARGUMENTS AND CONSTRUCT
// INTEGER ENCODED CALENDAR DATE.

   $mm = SPrintF("%02d", $m);
    $d = 1;
   $dd = "01";

   $ymd = "$y$mm$dd";

   $year = abs($y);
    $era = ($y < 0) ? "BC" : "AD";
            if ($y > 0 && $y > 1000) {$era = "  ";}
   $yEra = "$year $era";

// -----------------------------------------------
// GET PARAMETERS NEEDED TO CREATE CALENDAR TABLE.

   $JD1     = jd_for_ymd ($ymd, $CalMode);
   $DoW1    = ($JD1 + 1) % 7;
   $MName   = Month_Str($m);
   $NumDays = Days_In_Month ($y, $m, $CalMode);

   $PadSpaces = Str_Repeat(" ", 20 - (StrLen($MName)+StrLen($yEra)));

   $line = $CalStr = "";

   $WDays = "Su Mo Tu We Th Fr Sa";

   for ($i=1;  $i <= $DoW1;   $i++) {$CalStr .= "&nbsp;&nbsp;&nbsp;";}

   for ($d=1;   $d <= $NumDays;   $d++)
       {
        if ($d < 10) {$p = "&nbsp;";} else {$p = "";}
            $CalStr .= $p . "$d ";
        if (($d + $DoW1 ) % 7 == 0) {$CalStr .= "\n";}
       }

// -----
// DONE.

   return trim("$line\n$yEra$PadSpaces$MName\n\n$WDays\n$CalStr\n$line");

} // End of  Calendar_Text()


// ************************************************************************
// ************************************************************************


/*

THIS FUNCTION RETURNS A CALENDAR IN THE FORM OF AN HTML
TABLE FOR THE MONTH CONTAINING THE GIVEN DATE .

THIS FUNCTION IS ALSO VALID FOR PROLEPTIC DATES.

$y     = YEAR NUMBER ARGUMENT  (1 to 32767)
$m     = MONTH NUMBER ARGUMENT (1 to 12)

$JD1   = JD NUMBER OF 1st DAY OF MONTH
$HDay  = DATE TO HIGHLIGHT WITHIN CALENDAR (0 = NONE)
$MName = NAME OF GIVEN MONTH
$DoW1  = DAY OF WEEK CODE (0 to 6) FOR 1st OF MONTH
$MDays = NUMBER OF DAYS IN GIVEN  MONTH

THE OPTIONAL PARAMETER $HDay IS THE DAY OF THE MONTH TO
BE HIGHLIGHTED IN THE CALENDAR DISPLAY. IF ($HDay == 0),
THEN NO DATE WILL BE HIGHLIGHTED.

*/


Function Calendar_Table ($ymd, $CalMode, $TitleColor, $SpecialFlag=FALSE)

{

// ---------------------------------------------
// EXTRACT INDIVIDUAL DATE ELEMENTS (y,m,d) FROM
// WITHIN INTEGER ENCODED DATE ARGUMENT (ymd).

   $w = floor(abs($ymd) / 10000);

   $y = (($ymd < 0) ? -1 : 1) * $w;
   $m = floor((abs($ymd) - 10000*$w) / 100);
   $d = (abs($ymd) - 10000*$w - 100*$m);

// ----------------------------------------------
// GET PARAMETERS NEEDED TO CREATE CALENDAR TABLE
//
// IF ($d == 0), THEN NO DATE WILL BE HIGHLIGHTED

   $HDay  = $d;
   $ymd1  = "$y" . sprintf("%02d", $m) . "01";
   $JD1   = jd_for_ymd ($ymd1, $CalMode);
   $MName = Month_Str ($m);
   $DoW1  = ($JD1 + 1) % 7;
   $MDays = Days_In_Month ($y, $m, $CalMode);

   $era   = ($y < 0) ? "BC" : "AD";
               if ($y > 0 && $y > 1000) {$era = "  ";}
   $yEra  = abs($y) . " $era";
   $CMode = ($CalMode == 0) ? "J" : "G";


   if ($y == 1582 && $m == 10 && $SpecialFlag == TRUE)
      {
       return JG_Transition_Calendar_Table();
      }





// ---------------------------------
// BEGIN CALENDAR TABLE CONSTRUCTION

   $CalTable =
"<TABLE BGCOLOR='black' CELLPADDING='2' CELLSPACING='1'>\n
<TR BGCOLOR=\"$TitleColor\"><TD COLSPAN='7' ALIGN='center'><B>$CMode&nbsp;$yEra&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;$MName</B></TD></TR>\n
<TR BGCOLOR='Light$TitleColor'><TD WIDTH='36' ALIGN='center'>Sun</TD><TD WIDTH='36' ALIGN='center'>Mon</TD><TD WIDTH='36' ALIGN='center'>Tue</TD><TD WIDTH='36' ALIGN='center'>Wed</TD><TD WIDTH='36' ALIGN='center'>Thu</TD><TD  WIDTH='36' ALIGN='center'>Fri</TD><TD WIDTH='36' ALIGN='center'>Sat</TD></TR>\n<TR>\n";

// ---------------------------------------------
// FILL ANY BLANK CELLS AT BEGINNING OF CALENDAR
// MATRIX IF MONTH DOES NOT START ON A SUNDAY.

   for ($i=1;  $i <= $DoW1;   $i++)
       {$CalTable .= "<TD BGCOLOR='white'>&nbsp;</TD>\n";}

// ----------------------------------
// FILL IN CALENDAR DAY NUMBER CELLS.

   for ($day=1;   $day <= $MDays;   $day++)

{

// PATCH TO CHANGE TITLE COLOR TO GREENYELLOW FOR OCTOBER OF 1582
   if ($y == 1582 && $m == 10) {$TitleColor = "GreenYellow";}

   $BgC = ($day != $HDay)? "white" : "$TitleColor";

   if ($y <> date('Y'))
      {$q = 'font-weight:normal;'; $BgC = 'white';}
  else
      {$q = 'font-size:13pt;';}

   if ($BgC == "$TitleColor")
      {$Bold1 = "<B style='$q'>"; $Bold2 = "</B>";}
   else
      {$Bold1 = $Bold2 = "";}

//exit("$y ".date('Y'));
       $CalTable .= "<TD BGCOLOR=\"$BgC\" ALIGN='center'>$Bold1$day$Bold2";

   if (($day + $DoW1 ) % 7 == 0)
      {$CalTable .= "</TD>\n</TR>\n<TR>\n";}
   else
      {$CalTable .= "</TD>\n";}
}


// ----------------------------------------------
// FILL ANY BLANK CELLS AT END OF CALENDAR MATRIX
// IF MONTH DOES NOT END ON A SATURDAY.

   $DoW = ($JD1 + $MDays) % 7;

   $DoWEnd = ($DoW + ($MDays - $d) % 7) % 7;

   for ($i=0;   $i < 6-$DoW;   $i++)  {$CalTable .= "<TD BGCOLOR='white'>&nbsp;</TD>\n";}

// --------------------
// CLOSE OUT THE TABLE.

   $CalTable .= "</TR>\n</TABLE>\n";

// ------------------------------------------
// PATCH TO DELETE REDUNDANT EMPTY TABLE ROW.

   $CalTable = Str_Replace("<TR>\n</TR>", "", $CalTable);

// -----
// DONE.

   return $CalTable;

} // End of  Calendar_Table()


// ************************************************************************
// ************************************************************************


// CALENDAR TABLE FOR ANY YEAR
// JULIAN = YELLOW
// GREGORIAN = CYAN


   function Calendar_For_Year_Table ($y, $CalMode=1)

   {

   $out = "";

// -----------------
// GET CALENDAR MODE

   $CalModeStr = (($CalMode == 0) ? "Jul" : "Gregor") . "ian";

   $era = ($y < 0) ? " BC" :  " AD";
   if ($y > 1000) {$era = "";}
   $yEra = abs($y) . $era;


   $HMonth = date("m");

// SET CALENDAR COLOR
   $CalColor = ($CalMode == 0)? "Yellow" : "Cyan";


// -----------------------------
// DEFINE TITLE ROW FOR CALENDAR

   $out = "<TR><TD COLSPAN='3' ALIGN='center' VALIGN='top' BGCOLOR='white'><B>Calendar For $CalModeStr Year $yEra<BR><BR></B></TD></TR>\n";

   $w = "";

// -------------------------------------------------------
// CONSTRUCT 3 COLUMNS by 4 ROWS CALENDAR MATRIX FOR YEAR.
// m = 3*row + column + 1

   for ($row=0;   $row < 4;   $row++)
       {
        for ($column=0;   $column < 3;   $column++)
            {
             if ($HMonth == 3*$row + $column + 1) {$HDay = date("d");} else {$HDay = "00";}
                 $ymd  = "$y" . sprintf("%02d", 3*$row + $column + 1) . $HDay;
                 $out .= "<TD VALIGN='top'>" . Calendar_Table ($ymd, $CalMode, "$CalColor") . "</TD>\n";
            }
                 $out = "<TR>" . $out . "</TR>\n";
       }

// -------------------------------------------
// FINISH UP AND CLOSE OUT THE TABLE STRUCTURE

   return "<TABLE BGCOLOR='black'>$out</TABLE>\n";

   }


// ************************************************************************
// ************************************************************************


/*

THIS FUNCTION CONVERTS DECIMAL DAYS INTO A
TIME DATA VECTOR IN THE GENERAL FORMAT:

'wk days hours minutes seconds'

-------
EXAMPLE

INPUT  = "16071.1748842592592593"

OUTPUT = "2295wk 6d 04h 11m 50s"

RESOLUTION IS TO NEAREST SECOND.

*/


   function Days_To_WkDHMS ($DaysArg)
{

// ------------------------------------
// GET WORKING VALUE OF NUMERICAL INPUT
// STRING, ASSUMED TO BE IN DECIMAL DAYS.

   $Days = trim($DaysArg);

// -----------------------------
// CONVERT AN EMPTY INPUT STRING
// TO THE DIGIT ZERO.

   if ($Days == "") {$Days = 0;}

// ------------------------------
// REMEMBER NUMERICAL SIGN VALUE.

   $sign = ($Days < 0) ? -1 : +1;

// --------------------------------------------------
// CONVERT WORKING VALUE ($DecDays) INTO ITS ABSOLUTE
// VALUE AT 24-DECIMALS OF PRECISION.

   $Days = bcMul($sign, $Days, 24);

// ---------------------------------------------------
// COMPUTE WEEKS, RESIDUAL DAYS AND FRACTION OF A DAY.

   $wk = bcDiv($Days, "7");
   $rd = bcSub($Days, bcMul($wk, "7"), 24);
    $d = bcAdd($rd, "0");
   $fd = bcSub($rd, $d, 16);

// -----------------------------------
// COMPUTE HMS  TIME STRING EQUIVALENT
// TO ANY RESIDUAL DAY FRACTION.

   $hms = HMS_For_Days ($fd, 0);

// ------------------------------------
// CONSTRUCT OUTPUT DATA VECTOR STRING,
// RECALLING ORIGINAL NUMERICAL SIGN.

   $s = ($wk != 1) ? "s" : "";
   $q = "$wk" . " week$s  ";
   $s = ($d != 1) ? "s" : "";
   $q .= "$d day$s  $hms";
   $q = ($sign < 0) ? "-" . $q : $q;

   return $q;

} // End of Days_To_WkDHMS()



// ************************************************************************
// ************************************************************************


   function mdye_Str_For_ymd ($ymd)
{

   $w = floor(abs($ymd) / 10000);

   $y = (($ymd < 0) ? -1 : 1) * $w;
   $m = floor((abs($ymd) - 10000*$w) / 100);
   $d = (abs($ymd) - 10000*$w - 100*$m);

   $era = ($y < 0) ? " BC" : " AD" ;

   if ($era == " AD" && $y > 1000) {$era = "";}

   $mStr = Month_Str($m);

// ------------------------------
// GET FINAL DIGIT OF DAY NUMBER.

   $FinalDigit = substr("$d", -1);

// -----------------------
// SET DEFAULT SUFFIX "th"

   $suffix = "th";

// --------------------------
// STANDARD ENGLISH SUFFIXES.

   if ($FinalDigit == "1") {$suffix = "st";}
   if ($FinalDigit == "2") {$suffix = "nd";}
   if ($FinalDigit == "3") {$suffix = "rd";}

// --------------------------
// SPECIAL SUFFIX EXCEPTIONS.

   if ($d > 10 && $d < 14) {$suffix = "th";}

// ----------------------------------------
// CONSTRUCT AND RETURN OUTPUT DATE STRING.

   return "$mStr $d$suffix, " . (abs($y)) . "$era";

}


   function Std_Date_Str_For_ymd ($ymd)
{

   $w = floor(abs($ymd) / 10000);

   $y = (($ymd < 0) ? -1 : 1) * $w;
   $m = floor((abs($ymd) - 10000*$w) / 100);
   $d = (abs($ymd) - 10000*$w - 100*$m);

   $era = ($y < 0) ? " BC" : " AD" ;

   if ($era == " AD" && $y > 1000) {$era = "";}

   $mStr = Month_Str($m);

// ------------------------------
// GET FINAL DIGIT OF DAY NUMBER.

   $FinalDigit = substr("$d", -1);

// -----------------------
// SET DEFAULT SUFFIX "th"

   $suffix = "th";

// --------------------------
// STANDARD ENGLISH SUFFIXES.

   if ($FinalDigit == "1") {$suffix = "st";}
   if ($FinalDigit == "2") {$suffix = "nd";}
   if ($FinalDigit == "3") {$suffix = "rd";}

// --------------------------
// SPECIAL SUFFIX EXCEPTIONS.

   if ($d > 10 && $d < 14) {$suffix = "th";}

// ----------------------------------------
// CONSTRUCT AND RETURN OUTPUT DATE STRING.

   return "$mStr $d$suffix, " . (abs($y)) . "$era";

}


// ************************************************************************
// ************************************************************************


   function JG_Transition_Calendar_Table ()
{

$out = "
<TABLE CLASS='cal' BGCOLOR='black' CELLPADDING='2' CELLSPACING='1'>

<TR BGCOLOR='Yellow'><TD COLSPAN='7' ALIGN='center'><B>J/G&nbsp;1582&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;October</B></TD></TR>

<TR BGCOLOR='LightYellow'><TD WIDTH='36' ALIGN='center'>Sun</TD><TD WIDTH='36' ALIGN='center'>Mon</TD><TD WIDTH='36' ALIGN='center'>Tue</TD><TD WIDTH='36' ALIGN='center'>Wed</TD><TD WIDTH='36' ALIGN='center'>Thu</TD><TD  WIDTH='36' ALIGN='center'>Fri</TD><TD WIDTH='36' ALIGN='center'>Sat</TD></TR>

<TR>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white' ALIGN='center'>1</TD>
<TD BGCOLOR='white' ALIGN='center'>2</TD>
<TD BGCOLOR='white' ALIGN='center'>3</TD>
<TD BGCOLOR='white' ALIGN='center'>4</TD>
<TD BGCOLOR='white' ALIGN='center'>15</TD>
<TD BGCOLOR='white' ALIGN='center'>16</TD>
</TR>

<TR>
<TD BGCOLOR='white' ALIGN='center'>17</TD>
<TD BGCOLOR='white' ALIGN='center'>18</TD>
<TD BGCOLOR='white' ALIGN='center'>19</TD>
<TD BGCOLOR='white' ALIGN='center'>20</TD>
<TD BGCOLOR='white' ALIGN='center'>21</TD>
<TD BGCOLOR='white' ALIGN='center'>22</TD>
<TD BGCOLOR='white' ALIGN='center'>23</TD>
</TR>

<TR>
<TD BGCOLOR='white' ALIGN='center'>24</TD>
<TD BGCOLOR='white' ALIGN='center'>25</TD>
<TD BGCOLOR='white' ALIGN='center'>26</TD>
<TD BGCOLOR='white' ALIGN='center'>27</TD>
<TD BGCOLOR='white' ALIGN='center'>28</TD>
<TD BGCOLOR='white' ALIGN='center'>29</TD>
<TD BGCOLOR='white' ALIGN='center'>30</TD>
</TR>

<TR>
<TD BGCOLOR='white' ALIGN='center'>31</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
</TR>

</TABLE>";

return $out;


}

// ************************************************************************
// ************************************************************************



      // ************************************************************************
// ************************************************************************


   function JG_Transition_Calendar_Table_Full ()
{

$out =
"
<TABLE BGCOLOR='black' ALIGN='center'>
<TR><TD COLSPAN='3' ALIGN='center' VALIGN='top' BGCOLOR='white'><B>Calendar For Julian / Gregorian Transition Year 1582<BR><BR></B></TD></TR>
<TD VALIGN='top'><TABLE BGCOLOR='black' CELLPADDING='2' CELLSPACING='1'>

<TR BGCOLOR='Yellow'><TD COLSPAN='7' ALIGN='center'><B>J&nbsp;1582   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;January</B></TD></TR>

<TR BGCOLOR='LightYellow'><TD WIDTH='36' ALIGN='center'>Sun</TD><TD WIDTH='36' ALIGN='center'>Mon</TD><TD WIDTH='36' ALIGN='center'>Tue</TD><TD WIDTH='36' ALIGN='center'>Wed</TD><TD WIDTH='36' ALIGN='center'>Thu</TD><TD  WIDTH='36' ALIGN='center'>Fri</TD><TD WIDTH='36' ALIGN='center'>Sat</TD></TR>
<TR>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white' ALIGN='center'>1</TD>
<TD BGCOLOR='white' ALIGN='center'>2</TD>
<TD BGCOLOR='white' ALIGN='center'>3</TD>
<TD BGCOLOR='white' ALIGN='center'>4</TD>
<TD BGCOLOR='white' ALIGN='center'>5</TD>
<TD BGCOLOR='white' ALIGN='center'>6</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>7</TD>
<TD BGCOLOR='white' ALIGN='center'>8</TD>
<TD BGCOLOR='white' ALIGN='center'>9</TD>
<TD BGCOLOR='white' ALIGN='center'>10</TD>
<TD BGCOLOR='white' ALIGN='center'>11</TD>
<TD BGCOLOR='white' ALIGN='center'>12</TD>
<TD BGCOLOR='white' ALIGN='center'>13</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>14</TD>
<TD BGCOLOR='white' ALIGN='center'>15</TD>
<TD BGCOLOR='white' ALIGN='center'>16</TD>
<TD BGCOLOR='white' ALIGN='center'>17</TD>
<TD BGCOLOR='white' ALIGN='center'>18</TD>
<TD BGCOLOR='white' ALIGN='center'>19</TD>
<TD BGCOLOR='white' ALIGN='center'>20</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>21</TD>
<TD BGCOLOR='white' ALIGN='center'>22</TD>
<TD BGCOLOR='white' ALIGN='center'>23</TD>
<TD BGCOLOR='white' ALIGN='center'>24</TD>
<TD BGCOLOR='white' ALIGN='center'>25</TD>
<TD BGCOLOR='white' ALIGN='center'>26</TD>
<TD BGCOLOR='white' ALIGN='center'>27</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>28</TD>
<TD BGCOLOR='white' ALIGN='center'>29</TD>
<TD BGCOLOR='white' ALIGN='center'>30</TD>
<TD BGCOLOR='white' ALIGN='center'>31</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
</TR>
</TABLE>
</TD>
<TD VALIGN='top'><TABLE BGCOLOR='black' CELLPADDING='2' CELLSPACING='1'>

<TR BGCOLOR='Yellow'><TD COLSPAN='7' ALIGN='center'><B>J&nbsp;1582   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;February</B></TD></TR>

<TR BGCOLOR='LightYellow'><TD WIDTH='36' ALIGN='center'>Sun</TD><TD WIDTH='36' ALIGN='center'>Mon</TD><TD WIDTH='36' ALIGN='center'>Tue</TD><TD WIDTH='36' ALIGN='center'>Wed</TD><TD WIDTH='36' ALIGN='center'>Thu</TD><TD  WIDTH='36' ALIGN='center'>Fri</TD><TD WIDTH='36' ALIGN='center'>Sat</TD></TR>
<TR>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white' ALIGN='center'>1</TD>
<TD BGCOLOR='white' ALIGN='center'>2</TD>
<TD BGCOLOR='white' ALIGN='center'>3</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>4</TD>
<TD BGCOLOR='white' ALIGN='center'>5</TD>
<TD BGCOLOR='white' ALIGN='center'>6</TD>
<TD BGCOLOR='white' ALIGN='center'>7</TD>
<TD BGCOLOR='white' ALIGN='center'>8</TD>
<TD BGCOLOR='white' ALIGN='center'>9</TD>
<TD BGCOLOR='white' ALIGN='center'>10</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>11</TD>
<TD BGCOLOR='white' ALIGN='center'>12</TD>
<TD BGCOLOR='white' ALIGN='center'>13</TD>
<TD BGCOLOR='white' ALIGN='center'>14</TD>
<TD BGCOLOR='white' ALIGN='center'>15</TD>
<TD BGCOLOR='white' ALIGN='center'>16</TD>
<TD BGCOLOR='white' ALIGN='center'>17</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>18</TD>
<TD BGCOLOR='white' ALIGN='center'>19</TD>
<TD BGCOLOR='white' ALIGN='center'>20</TD>
<TD BGCOLOR='white' ALIGN='center'>21</TD>
<TD BGCOLOR='white' ALIGN='center'>22</TD>
<TD BGCOLOR='white' ALIGN='center'>23</TD>
<TD BGCOLOR='white' ALIGN='center'>24</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>25</TD>
<TD BGCOLOR='white' ALIGN='center'>26</TD>
<TD BGCOLOR='white' ALIGN='center'>27</TD>
<TD BGCOLOR='white' ALIGN='center'>28</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
</TR>
</TABLE>
</TD>
<TD VALIGN='top'><TABLE BGCOLOR='black' CELLPADDING='2' CELLSPACING='1'>

<TR BGCOLOR='Yellow'><TD COLSPAN='7' ALIGN='center'><B>J&nbsp;1582   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;March</B></TD></TR>

<TR BGCOLOR='LightYellow'><TD WIDTH='36' ALIGN='center'>Sun</TD><TD WIDTH='36' ALIGN='center'>Mon</TD><TD WIDTH='36' ALIGN='center'>Tue</TD><TD WIDTH='36' ALIGN='center'>Wed</TD><TD WIDTH='36' ALIGN='center'>Thu</TD><TD  WIDTH='36' ALIGN='center'>Fri</TD><TD WIDTH='36' ALIGN='center'>Sat</TD></TR>
<TR>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white' ALIGN='center'>1</TD>
<TD BGCOLOR='white' ALIGN='center'>2</TD>
<TD BGCOLOR='white' ALIGN='center'>3</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>4</TD>
<TD BGCOLOR='white' ALIGN='center'>5</TD>
<TD BGCOLOR='white' ALIGN='center'>6</TD>
<TD BGCOLOR='white' ALIGN='center'>7</TD>
<TD BGCOLOR='white' ALIGN='center'>8</TD>
<TD BGCOLOR='white' ALIGN='center'>9</TD>
<TD BGCOLOR='white' ALIGN='center'>10</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>11</TD>
<TD BGCOLOR='white' ALIGN='center'>12</TD>
<TD BGCOLOR='white' ALIGN='center'>13</TD>
<TD BGCOLOR='white' ALIGN='center'>14</TD>
<TD BGCOLOR='white' ALIGN='center'>15</TD>
<TD BGCOLOR='white' ALIGN='center'>16</TD>
<TD BGCOLOR='white' ALIGN='center'>17</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>18</TD>
<TD BGCOLOR='white' ALIGN='center'>19</TD>
<TD BGCOLOR='white' ALIGN='center'>20</TD>
<TD BGCOLOR='white' ALIGN='center'>21</TD>
<TD BGCOLOR='white' ALIGN='center'>22</TD>
<TD BGCOLOR='white' ALIGN='center'>23</TD>
<TD BGCOLOR='white' ALIGN='center'>24</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>25</TD>
<TD BGCOLOR='white' ALIGN='center'>26</TD>
<TD BGCOLOR='white' ALIGN='center'>27</TD>
<TD BGCOLOR='white' ALIGN='center'>28</TD>
<TD BGCOLOR='white' ALIGN='center'>29</TD>
<TD BGCOLOR='white' ALIGN='center'>30</TD>
<TD BGCOLOR='white' ALIGN='center'>31</TD>
</TR>

</TABLE>
</TD>
</TR>
<TD VALIGN='top'><TABLE BGCOLOR='black' CELLPADDING='2' CELLSPACING='1'>

<TR BGCOLOR='Yellow'><TD COLSPAN='7' ALIGN='center'><B>J&nbsp;1582   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;April</B></TD></TR>

<TR BGCOLOR='LightYellow'><TD WIDTH='36' ALIGN='center'>Sun</TD><TD WIDTH='36' ALIGN='center'>Mon</TD><TD WIDTH='36' ALIGN='center'>Tue</TD><TD WIDTH='36' ALIGN='center'>Wed</TD><TD WIDTH='36' ALIGN='center'>Thu</TD><TD  WIDTH='36' ALIGN='center'>Fri</TD><TD WIDTH='36' ALIGN='center'>Sat</TD></TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>1</TD>
<TD BGCOLOR='white' ALIGN='center'>2</TD>
<TD BGCOLOR='white' ALIGN='center'>3</TD>
<TD BGCOLOR='white' ALIGN='center'>4</TD>
<TD BGCOLOR='white' ALIGN='center'>5</TD>
<TD BGCOLOR='white' ALIGN='center'>6</TD>
<TD BGCOLOR='white' ALIGN='center'>7</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>8</TD>
<TD BGCOLOR='white' ALIGN='center'>9</TD>
<TD BGCOLOR='white' ALIGN='center'>10</TD>
<TD BGCOLOR='white' ALIGN='center'>11</TD>
<TD BGCOLOR='white' ALIGN='center'>12</TD>
<TD BGCOLOR='white' ALIGN='center'>13</TD>
<TD BGCOLOR='white' ALIGN='center'>14</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>15</TD>
<TD BGCOLOR='white' ALIGN='center'>16</TD>
<TD BGCOLOR='white' ALIGN='center'>17</TD>
<TD BGCOLOR='white' ALIGN='center'>18</TD>
<TD BGCOLOR='white' ALIGN='center'>19</TD>
<TD BGCOLOR='white' ALIGN='center'>20</TD>
<TD BGCOLOR='white' ALIGN='center'>21</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>22</TD>
<TD BGCOLOR='white' ALIGN='center'>23</TD>
<TD BGCOLOR='white' ALIGN='center'>24</TD>
<TD BGCOLOR='white' ALIGN='center'>25</TD>
<TD BGCOLOR='white' ALIGN='center'>26</TD>
<TD BGCOLOR='white' ALIGN='center'>27</TD>
<TD BGCOLOR='white' ALIGN='center'>28</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>29</TD>
<TD BGCOLOR='white' ALIGN='center'>30</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
</TR>
</TABLE>
</TD>
<TD VALIGN='top'><TABLE BGCOLOR='black' CELLPADDING='2' CELLSPACING='1'>

<TR BGCOLOR='Yellow'><TD COLSPAN='7' ALIGN='center'><B>J&nbsp;1582   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;May</B></TD></TR>

<TR BGCOLOR='LightYellow'><TD WIDTH='36' ALIGN='center'>Sun</TD><TD WIDTH='36' ALIGN='center'>Mon</TD><TD WIDTH='36' ALIGN='center'>Tue</TD><TD WIDTH='36' ALIGN='center'>Wed</TD><TD WIDTH='36' ALIGN='center'>Thu</TD><TD  WIDTH='36' ALIGN='center'>Fri</TD><TD WIDTH='36' ALIGN='center'>Sat</TD></TR>
<TR>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white' ALIGN='center'>1</TD>
<TD BGCOLOR='white' ALIGN='center'>2</TD>
<TD BGCOLOR='white' ALIGN='center'>3</TD>
<TD BGCOLOR='white' ALIGN='center'>4</TD>
<TD BGCOLOR='white' ALIGN='center'>5</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>6</TD>
<TD BGCOLOR='white' ALIGN='center'>7</TD>
<TD BGCOLOR='white' ALIGN='center'>8</TD>
<TD BGCOLOR='white' ALIGN='center'>9</TD>
<TD BGCOLOR='white' ALIGN='center'>10</TD>
<TD BGCOLOR='white' ALIGN='center'>11</TD>
<TD BGCOLOR='white' ALIGN='center'>12</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>13</TD>
<TD BGCOLOR='white' ALIGN='center'>14</TD>
<TD BGCOLOR='white' ALIGN='center'>15</TD>
<TD BGCOLOR='white' ALIGN='center'>16</TD>
<TD BGCOLOR='white' ALIGN='center'>17</TD>
<TD BGCOLOR='white' ALIGN='center'>18</TD>
<TD BGCOLOR='white' ALIGN='center'>19</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>20</TD>
<TD BGCOLOR='white' ALIGN='center'>21</TD>
<TD BGCOLOR='white' ALIGN='center'>22</TD>
<TD BGCOLOR='white' ALIGN='center'>23</TD>
<TD BGCOLOR='white' ALIGN='center'>24</TD>
<TD BGCOLOR='white' ALIGN='center'>25</TD>
<TD BGCOLOR='white' ALIGN='center'>26</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>27</TD>
<TD BGCOLOR='white' ALIGN='center'>28</TD>
<TD BGCOLOR='white' ALIGN='center'>29</TD>
<TD BGCOLOR='white' ALIGN='center'>30</TD>
<TD BGCOLOR='white' ALIGN='center'>31</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
</TR>
</TABLE>
</TD>
<TD VALIGN='top'><TABLE BGCOLOR='black' CELLPADDING='2' CELLSPACING='1'>

<TR BGCOLOR='Yellow'><TD COLSPAN='7' ALIGN='center'><B>J&nbsp;1582   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;June</B></TD></TR>

<TR BGCOLOR='LightYellow'><TD WIDTH='36' ALIGN='center'>Sun</TD><TD WIDTH='36' ALIGN='center'>Mon</TD><TD WIDTH='36' ALIGN='center'>Tue</TD><TD WIDTH='36' ALIGN='center'>Wed</TD><TD WIDTH='36' ALIGN='center'>Thu</TD><TD  WIDTH='36' ALIGN='center'>Fri</TD><TD WIDTH='36' ALIGN='center'>Sat</TD></TR>
<TR>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white' ALIGN='center'>1</TD>
<TD BGCOLOR='white' ALIGN='center'>2</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>3</TD>
<TD BGCOLOR='white' ALIGN='center'>4</TD>
<TD BGCOLOR='white' ALIGN='center'>5</TD>
<TD BGCOLOR='white' ALIGN='center'>6</TD>
<TD BGCOLOR='white' ALIGN='center'>7</TD>
<TD BGCOLOR='white' ALIGN='center'>8</TD>
<TD BGCOLOR='white' ALIGN='center'>9</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>10</TD>
<TD BGCOLOR='white' ALIGN='center'>11</TD>
<TD BGCOLOR='white' ALIGN='center'>12</TD>
<TD BGCOLOR='white' ALIGN='center'>13</TD>
<TD BGCOLOR='white' ALIGN='center'>14</TD>
<TD BGCOLOR='white' ALIGN='center'>15</TD>
<TD BGCOLOR='white' ALIGN='center'>16</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>17</TD>
<TD BGCOLOR='white' ALIGN='center'>18</TD>
<TD BGCOLOR='white' ALIGN='center'>19</TD>
<TD BGCOLOR='white' ALIGN='center'>20</TD>
<TD BGCOLOR='white' ALIGN='center'>21</TD>
<TD BGCOLOR='white' ALIGN='center'>22</TD>
<TD BGCOLOR='white' ALIGN='center'>23</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>24</TD>
<TD BGCOLOR='white' ALIGN='center'>25</TD>
<TD BGCOLOR='white' ALIGN='center'>26</TD>
<TD BGCOLOR='white' ALIGN='center'>27</TD>
<TD BGCOLOR='white' ALIGN='center'>28</TD>
<TD BGCOLOR='white' ALIGN='center'>29</TD>
<TD BGCOLOR='white' ALIGN='center'>30</TD>
</TR>

</TABLE>
</TD>
</TR>
<TD VALIGN='top'><TABLE BGCOLOR='black' CELLPADDING='2' CELLSPACING='1'>

<TR BGCOLOR='Yellow'><TD COLSPAN='7' ALIGN='center'><B>J&nbsp;1582   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;July</B></TD></TR>

<TR BGCOLOR='LightYellow'><TD WIDTH='36' ALIGN='center'>Sun</TD><TD WIDTH='36' ALIGN='center'>Mon</TD><TD WIDTH='36' ALIGN='center'>Tue</TD><TD WIDTH='36' ALIGN='center'>Wed</TD><TD WIDTH='36' ALIGN='center'>Thu</TD><TD  WIDTH='36' ALIGN='center'>Fri</TD><TD WIDTH='36' ALIGN='center'>Sat</TD></TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>1</TD>
<TD BGCOLOR='white' ALIGN='center'>2</TD>
<TD BGCOLOR='white' ALIGN='center'>3</TD>
<TD BGCOLOR='white' ALIGN='center'>4</TD>
<TD BGCOLOR='white' ALIGN='center'>5</TD>
<TD BGCOLOR='white' ALIGN='center'>6</TD>
<TD BGCOLOR='white' ALIGN='center'>7</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>8</TD>
<TD BGCOLOR='white' ALIGN='center'>9</TD>
<TD BGCOLOR='white' ALIGN='center'>10</TD>
<TD BGCOLOR='white' ALIGN='center'>11</TD>
<TD BGCOLOR='white' ALIGN='center'>12</TD>
<TD BGCOLOR='white' ALIGN='center'>13</TD>
<TD BGCOLOR='white' ALIGN='center'>14</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>15</TD>
<TD BGCOLOR='white' ALIGN='center'>16</TD>
<TD BGCOLOR='white' ALIGN='center'>17</TD>
<TD BGCOLOR='white' ALIGN='center'>18</TD>
<TD BGCOLOR='white' ALIGN='center'>19</TD>
<TD BGCOLOR='white' ALIGN='center'>20</TD>
<TD BGCOLOR='white' ALIGN='center'>21</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>22</TD>
<TD BGCOLOR='white' ALIGN='center'>23</TD>
<TD BGCOLOR='white' ALIGN='center'>24</TD>
<TD BGCOLOR='white' ALIGN='center'>25</TD>
<TD BGCOLOR='white' ALIGN='center'>26</TD>
<TD BGCOLOR='white' ALIGN='center'>27</TD>
<TD BGCOLOR='white' ALIGN='center'>28</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>29</TD>
<TD BGCOLOR='white' ALIGN='center'>30</TD>
<TD BGCOLOR='white' ALIGN='center'>31</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
</TR>
</TABLE>
</TD>
<TD VALIGN='top'><TABLE BGCOLOR='black' CELLPADDING='2' CELLSPACING='1'>

<TR BGCOLOR='Yellow'><TD COLSPAN='7' ALIGN='center'><B>J&nbsp;1582   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;August</B></TD></TR>

<TR BGCOLOR='LightYellow'><TD WIDTH='36' ALIGN='center'>Sun</TD><TD WIDTH='36' ALIGN='center'>Mon</TD><TD WIDTH='36' ALIGN='center'>Tue</TD><TD WIDTH='36' ALIGN='center'>Wed</TD><TD WIDTH='36' ALIGN='center'>Thu</TD><TD  WIDTH='36' ALIGN='center'>Fri</TD><TD WIDTH='36' ALIGN='center'>Sat</TD></TR>
<TR>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white' ALIGN='center'>1</TD>
<TD BGCOLOR='white' ALIGN='center'>2</TD>
<TD BGCOLOR='white' ALIGN='center'>3</TD>
<TD BGCOLOR='white' ALIGN='center'>4</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>5</TD>
<TD BGCOLOR='white' ALIGN='center'>6</TD>
<TD BGCOLOR='white' ALIGN='center'>7</TD>
<TD BGCOLOR='white' ALIGN='center'>8</TD>
<TD BGCOLOR='white' ALIGN='center'>9</TD>
<TD BGCOLOR='white' ALIGN='center'>10</TD>
<TD BGCOLOR='white' ALIGN='center'>11</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>12</TD>
<TD BGCOLOR='white' ALIGN='center'>13</TD>
<TD BGCOLOR='white' ALIGN='center'>14</TD>
<TD BGCOLOR='white' ALIGN='center'>15</TD>
<TD BGCOLOR='white' ALIGN='center'>16</TD>
<TD BGCOLOR='white' ALIGN='center'>17</TD>
<TD BGCOLOR='white' ALIGN='center'>18</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>19</TD>
<TD BGCOLOR='white' ALIGN='center'>20</TD>
<TD BGCOLOR='white' ALIGN='center'>21</TD>
<TD BGCOLOR='white' ALIGN='center'>22</TD>
<TD BGCOLOR='white' ALIGN='center'>23</TD>
<TD BGCOLOR='white' ALIGN='center'>24</TD>
<TD BGCOLOR='white' ALIGN='center'>25</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>26</TD>
<TD BGCOLOR='white' ALIGN='center'>27</TD>
<TD BGCOLOR='white' ALIGN='center'>28</TD>
<TD BGCOLOR='white' ALIGN='center'>29</TD>
<TD BGCOLOR='white' ALIGN='center'>30</TD>
<TD BGCOLOR='white' ALIGN='center'>31</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
</TR>
</TABLE>
</TD>
<TD VALIGN='top'><TABLE BGCOLOR='black' CELLPADDING='2' CELLSPACING='1'>

<TR BGCOLOR='Yellow'><TD COLSPAN='7' ALIGN='center'><B>J&nbsp;1582   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;September</B></TD></TR>

<TR BGCOLOR='LightYellow'><TD WIDTH='36' ALIGN='center'>Sun</TD><TD WIDTH='36' ALIGN='center'>Mon</TD><TD WIDTH='36' ALIGN='center'>Tue</TD><TD WIDTH='36' ALIGN='center'>Wed</TD><TD WIDTH='36' ALIGN='center'>Thu</TD><TD  WIDTH='36' ALIGN='center'>Fri</TD><TD WIDTH='36' ALIGN='center'>Sat</TD></TR>
<TR>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white' ALIGN='center'>1</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>2</TD>
<TD BGCOLOR='white' ALIGN='center'>3</TD>
<TD BGCOLOR='white' ALIGN='center'>4</TD>
<TD BGCOLOR='white' ALIGN='center'>5</TD>
<TD BGCOLOR='white' ALIGN='center'>6</TD>
<TD BGCOLOR='white' ALIGN='center'>7</TD>
<TD BGCOLOR='white' ALIGN='center'>8</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>9</TD>
<TD BGCOLOR='white' ALIGN='center'>10</TD>
<TD BGCOLOR='white' ALIGN='center'>11</TD>
<TD BGCOLOR='white' ALIGN='center'>12</TD>
<TD BGCOLOR='white' ALIGN='center'>13</TD>
<TD BGCOLOR='white' ALIGN='center'>14</TD>
<TD BGCOLOR='white' ALIGN='center'>15</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>16</TD>
<TD BGCOLOR='white' ALIGN='center'>17</TD>
<TD BGCOLOR='white' ALIGN='center'>18</TD>
<TD BGCOLOR='white' ALIGN='center'>19</TD>
<TD BGCOLOR='white' ALIGN='center'>20</TD>
<TD BGCOLOR='white' ALIGN='center'>21</TD>
<TD BGCOLOR='white' ALIGN='center'>22</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>23</TD>
<TD BGCOLOR='white' ALIGN='center'>24</TD>
<TD BGCOLOR='white' ALIGN='center'>25</TD>
<TD BGCOLOR='white' ALIGN='center'>26</TD>
<TD BGCOLOR='white' ALIGN='center'>27</TD>
<TD BGCOLOR='white' ALIGN='center'>28</TD>
<TD BGCOLOR='white' ALIGN='center'>29</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>30</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
</TR>
</TABLE>
</TD>
</TR>
<TD VALIGN='top'><TABLE CLASS='cal' BGCOLOR='black' CELLPADDING='2' CELLSPACING='1'>

<TR BGCOLOR='Yellow'><TD COLSPAN='7' ALIGN='center'><B>J/G&nbsp;1582&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;October</B></TD></TR>

<TR BGCOLOR='LightYellow'><TD WIDTH='36' ALIGN='center'>Sun</TD><TD WIDTH='36' ALIGN='center'>Mon</TD><TD WIDTH='36' ALIGN='center'>Tue</TD><TD WIDTH='36' ALIGN='center'>Wed</TD><TD WIDTH='36' ALIGN='center'>Thu</TD><TD WIDTH='36' ALIGN='center' BGCOLOR='LightCyan'>Fri</TD><TD WIDTH='36' ALIGN='center' BGCOLOR='LightCyan'>Sat</TD></TR>

<TR>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white' ALIGN='center'>1</TD>
<TD BGCOLOR='white' ALIGN='center'>2</TD>
<TD BGCOLOR='white' ALIGN='center'>3</TD>
<TD BGCOLOR='yellow' ALIGN='center'><B>4</B></TD>
<TD BGCOLOR='cyan' ALIGN='center'><B>15</B></TD>
<TD BGCOLOR='white' ALIGN='center'>16</TD>
</TR>

<TR BGCOLOR='LightCyan'><TD WIDTH='36' ALIGN='center'>Sun</TD><TD WIDTH='36' ALIGN='center'>Mon</TD><TD WIDTH='36' ALIGN='center'>Tue</TD><TD WIDTH='36' ALIGN='center'>Wed</TD><TD WIDTH='36' ALIGN='center'>Thu</TD><TD  WIDTH='36' ALIGN='center'>Fri</TD><TD WIDTH='36' ALIGN='center'>Sat</TD></TR>

<TR>
<TD BGCOLOR='white' ALIGN='center'>17</TD>
<TD BGCOLOR='white' ALIGN='center'>18</TD>
<TD BGCOLOR='white' ALIGN='center'>19</TD>
<TD BGCOLOR='white' ALIGN='center'>20</TD>
<TD BGCOLOR='white' ALIGN='center'>21</TD>
<TD BGCOLOR='white' ALIGN='center'>22</TD>
<TD BGCOLOR='white' ALIGN='center'>23</TD>
</TR>

<TR>
<TD BGCOLOR='white' ALIGN='center'>24</TD>
<TD BGCOLOR='white' ALIGN='center'>25</TD>
<TD BGCOLOR='white' ALIGN='center'>26</TD>
<TD BGCOLOR='white' ALIGN='center'>27</TD>
<TD BGCOLOR='white' ALIGN='center'>28</TD>
<TD BGCOLOR='white' ALIGN='center'>29</TD>
<TD BGCOLOR='white' ALIGN='center'>30</TD>
</TR>

<TR>
<TD BGCOLOR='white' ALIGN='center'>31</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
</TR>

</TABLE>
</TD>
<TD VALIGN='top'><TABLE BGCOLOR='black' CELLPADDING='2' CELLSPACING='1'>

<TR BGCOLOR='cyan'><TD COLSPAN='7' ALIGN='center'><B>G&nbsp;1582   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;November</B></TD></TR>

<TR BGCOLOR='LightCyan'><TD WIDTH='36' ALIGN='center'>Sun</TD><TD WIDTH='36' ALIGN='center'>Mon</TD><TD WIDTH='36' ALIGN='center'>Tue</TD><TD WIDTH='36' ALIGN='center'>Wed</TD><TD WIDTH='36' ALIGN='center'>Thu</TD><TD  WIDTH='36' ALIGN='center'>Fri</TD><TD WIDTH='36' ALIGN='center'>Sat</TD></TR>
<TR>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white' ALIGN='center'>1</TD>
<TD BGCOLOR='white' ALIGN='center'>2</TD>
<TD BGCOLOR='white' ALIGN='center'>3</TD>
<TD BGCOLOR='white' ALIGN='center'>4</TD>
<TD BGCOLOR='white' ALIGN='center'>5</TD>
<TD BGCOLOR='white' ALIGN='center'>6</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>7</TD>
<TD BGCOLOR='white' ALIGN='center'>8</TD>
<TD BGCOLOR='white' ALIGN='center'>9</TD>
<TD BGCOLOR='white' ALIGN='center'>10</TD>
<TD BGCOLOR='white' ALIGN='center'>11</TD>
<TD BGCOLOR='white' ALIGN='center'>12</TD>
<TD BGCOLOR='white' ALIGN='center'>13</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>14</TD>
<TD BGCOLOR='white' ALIGN='center'>15</TD>
<TD BGCOLOR='white' ALIGN='center'>16</TD>
<TD BGCOLOR='white' ALIGN='center'>17</TD>
<TD BGCOLOR='white' ALIGN='center'>18</TD>
<TD BGCOLOR='white' ALIGN='center'>19</TD>
<TD BGCOLOR='white' ALIGN='center'>20</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>21</TD>
<TD BGCOLOR='white' ALIGN='center'>22</TD>
<TD BGCOLOR='white' ALIGN='center'>23</TD>
<TD BGCOLOR='white' ALIGN='center'>24</TD>
<TD BGCOLOR='white' ALIGN='center'>25</TD>
<TD BGCOLOR='white' ALIGN='center'>26</TD>
<TD BGCOLOR='white' ALIGN='center'>27</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>28</TD>
<TD BGCOLOR='white' ALIGN='center'>29</TD>
<TD BGCOLOR='white' ALIGN='center'>30</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
</TR>
</TABLE>
</TD>
<TD VALIGN='top'><TABLE BGCOLOR='black' CELLPADDING='2' CELLSPACING='1'>

<TR BGCOLOR='cyan'><TD COLSPAN='7' ALIGN='center'><B>G&nbsp;1582   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;December</B></TD></TR>

<TR BGCOLOR='LightCyan'><TD WIDTH='36' ALIGN='center'>Sun</TD><TD WIDTH='36' ALIGN='center'>Mon</TD><TD WIDTH='36' ALIGN='center'>Tue</TD><TD WIDTH='36' ALIGN='center'>Wed</TD><TD WIDTH='36' ALIGN='center'>Thu</TD><TD  WIDTH='36' ALIGN='center'>Fri</TD><TD WIDTH='36' ALIGN='center'>Sat</TD></TR>
<TR>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white' ALIGN='center'>1</TD>
<TD BGCOLOR='white' ALIGN='center'>2</TD>
<TD BGCOLOR='white' ALIGN='center'>3</TD>
<TD BGCOLOR='white' ALIGN='center'>4</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>5</TD>
<TD BGCOLOR='white' ALIGN='center'>6</TD>
<TD BGCOLOR='white' ALIGN='center'>7</TD>
<TD BGCOLOR='white' ALIGN='center'>8</TD>
<TD BGCOLOR='white' ALIGN='center'>9</TD>
<TD BGCOLOR='white' ALIGN='center'>10</TD>
<TD BGCOLOR='white' ALIGN='center'>11</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>12</TD>
<TD BGCOLOR='white' ALIGN='center'>13</TD>
<TD BGCOLOR='white' ALIGN='center'>14</TD>
<TD BGCOLOR='white' ALIGN='center'>15</TD>
<TD BGCOLOR='white' ALIGN='center'>16</TD>
<TD BGCOLOR='white' ALIGN='center'>17</TD>
<TD BGCOLOR='white' ALIGN='center'>18</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>19</TD>
<TD BGCOLOR='white' ALIGN='center'>20</TD>
<TD BGCOLOR='white' ALIGN='center'>21</TD>
<TD BGCOLOR='white' ALIGN='center'>22</TD>
<TD BGCOLOR='white' ALIGN='center'>23</TD>
<TD BGCOLOR='white' ALIGN='center'>24</TD>
<TD BGCOLOR='white' ALIGN='center'>25</TD>
</TR>
<TR>
<TD BGCOLOR='white' ALIGN='center'>26</TD>
<TD BGCOLOR='white' ALIGN='center'>27</TD>
<TD BGCOLOR='white' ALIGN='center'>28</TD>
<TD BGCOLOR='white' ALIGN='center'>29</TD>
<TD BGCOLOR='white' ALIGN='center'>30</TD>
<TD BGCOLOR='white' ALIGN='center'>31</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
</TR>
</TABLE>
</TD>
</TR>
</TABLE>
";

return $out;


} // End of  JG_Transition_Calendar_Table_Full()








      // ************************************************************************
// ************************************************************************


   function JG_1752_Transition_Calendar_Table_Full ()
{

$out =
"
<TABLE BGCOLOR='white' ALIGN='center'>
<TR><TD COLSPAN='3' ALIGN='center' VALIGN='top' BGCOLOR='white'>
<B>Calendar For U.S.A. Julian / Gregorian Transition Year 1752</B>
<BR><BR>
Officially, the U.S. colonies switched from the old Julian calendar<BR>
to the modern Gregorian calendar in September of 1752.&nbsp; Part of the<BR>
year was on the Julian and part on the Gregorian calendar as shown in the <BR>
transition calendar below for that year.
<BR><BR>
The Julian calendar is indicated by yellow and the Gregorian calendar by Cyan.
<BR><BR>
</TD></TR>

<TD VALIGN='top' BGCOLOR='white'>

<TABLE BGCOLOR='black'>

<TD VALIGN='top'><TABLE BGCOLOR='black' CELLPADDING='2' CELLSPACING='1'>

<TR BGCOLOR='Yellow'><TD COLSPAN='7'><B>J&nbsp;1752   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;January</B></TD></TR>

<TR BGCOLOR='LightYellow'><TD WIDTH='36'>Sun</TD><TD WIDTH='36'>Mon</TD><TD WIDTH='36'>Tue</TD><TD WIDTH='36'>Wed</TD><TD WIDTH='36'>Thu</TD><TD  WIDTH='36'>Fri</TD><TD WIDTH='36'>Sat</TD></TR>
<TR>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>1</TD>
<TD BGCOLOR='white'>2</TD>
<TD BGCOLOR='white'>3</TD>
<TD BGCOLOR='white'>4</TD>
</TR>
<TR>
<TD BGCOLOR='white'>5</TD>
<TD BGCOLOR='white'>6</TD>
<TD BGCOLOR='white'>7</TD>
<TD BGCOLOR='white'>8</TD>
<TD BGCOLOR='white'>9</TD>
<TD BGCOLOR='white'>10</TD>
<TD BGCOLOR='white'>11</TD>
</TR>
<TR>
<TD BGCOLOR='white'>12</TD>
<TD BGCOLOR='white'>13</TD>
<TD BGCOLOR='white'>14</TD>
<TD BGCOLOR='white'>15</TD>
<TD BGCOLOR='white'>16</TD>
<TD BGCOLOR='white'>17</TD>
<TD BGCOLOR='white'>18</TD>
</TR>
<TR>
<TD BGCOLOR='white'>19</TD>
<TD BGCOLOR='white'>20</TD>
<TD BGCOLOR='white'>21</TD>
<TD BGCOLOR='white'>22</TD>
<TD BGCOLOR='white'>23</TD>
<TD BGCOLOR='white'>24</TD>
<TD BGCOLOR='white'>25</TD>
</TR>
<TR>
<TD BGCOLOR='white'>26</TD>
<TD BGCOLOR='white'>27</TD>
<TD BGCOLOR='white'>28</TD>
<TD BGCOLOR='white'>29</TD>
<TD BGCOLOR='white'>30</TD>
<TD BGCOLOR='white'>31</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
</TR>
</TABLE>
</TD>
<TD VALIGN='top'><TABLE BGCOLOR='black' CELLPADDING='2' CELLSPACING='1'>

<TR BGCOLOR='Yellow'><TD COLSPAN='7'><B>J&nbsp;1752   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;February</B></TD></TR>

<TR BGCOLOR='LightYellow'><TD WIDTH='36'>Sun</TD><TD WIDTH='36'>Mon</TD><TD WIDTH='36'>Tue</TD><TD WIDTH='36'>Wed</TD><TD WIDTH='36'>Thu</TD><TD  WIDTH='36'>Fri</TD><TD WIDTH='36'>Sat</TD></TR>
<TR>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>1</TD>
</TR>
<TR>
<TD BGCOLOR='white'>2</TD>
<TD BGCOLOR='white'>3</TD>
<TD BGCOLOR='white'>4</TD>
<TD BGCOLOR='white'>5</TD>
<TD BGCOLOR='white'>6</TD>
<TD BGCOLOR='white'>7</TD>
<TD BGCOLOR='white'>8</TD>
</TR>
<TR>
<TD BGCOLOR='white'>9</TD>
<TD BGCOLOR='white'>10</TD>
<TD BGCOLOR='white'>11</TD>
<TD BGCOLOR='white'>12</TD>
<TD BGCOLOR='white'>13</TD>
<TD BGCOLOR='white'>14</TD>
<TD BGCOLOR='white'>15</TD>
</TR>
<TR>
<TD BGCOLOR='white'>16</TD>
<TD BGCOLOR='white'>17</TD>
<TD BGCOLOR='white'>18</TD>
<TD BGCOLOR='white'>19</TD>
<TD BGCOLOR='white'>20</TD>
<TD BGCOLOR='white'>21</TD>
<TD BGCOLOR='white'>22</TD>
</TR>
<TR>
<TD BGCOLOR='white'>23</TD>
<TD BGCOLOR='white'>24</TD>
<TD BGCOLOR='white'>25</TD>
<TD BGCOLOR='white'>26</TD>
<TD BGCOLOR='white'>27</TD>
<TD BGCOLOR='white'>28</TD>
<TD BGCOLOR='white'>29</TD>
</TR>

</TABLE>
</TD>
<TD VALIGN='top'><TABLE BGCOLOR='black' CELLPADDING='2' CELLSPACING='1'>

<TR BGCOLOR='Yellow'><TD COLSPAN='7'><B>J&nbsp;1752   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;March</B></TD></TR>

<TR BGCOLOR='LightYellow'><TD WIDTH='36'>Sun</TD><TD WIDTH='36'>Mon</TD><TD WIDTH='36'>Tue</TD><TD WIDTH='36'>Wed</TD><TD WIDTH='36'>Thu</TD><TD  WIDTH='36'>Fri</TD><TD WIDTH='36'>Sat</TD></TR>
<TR>
<TD BGCOLOR='white'>1</TD>
<TD BGCOLOR='white'>2</TD>
<TD BGCOLOR='white'>3</TD>
<TD BGCOLOR='white'>4</TD>
<TD BGCOLOR='white'>5</TD>
<TD BGCOLOR='white'>6</TD>
<TD BGCOLOR='white'>7</TD>
</TR>
<TR>
<TD BGCOLOR='white'>8</TD>
<TD BGCOLOR='white'>9</TD>
<TD BGCOLOR='white'>10</TD>
<TD BGCOLOR='white'>11</TD>
<TD BGCOLOR='white'>12</TD>
<TD BGCOLOR='white'>13</TD>
<TD BGCOLOR='white'>14</TD>
</TR>
<TR>
<TD BGCOLOR='white'>15</TD>
<TD BGCOLOR='white'>16</TD>
<TD BGCOLOR='white'>17</TD>
<TD BGCOLOR='white'>18</TD>
<TD BGCOLOR='white'>19</TD>
<TD BGCOLOR='white'>20</TD>
<TD BGCOLOR='white'>21</TD>
</TR>
<TR>
<TD BGCOLOR='white'>22</TD>
<TD BGCOLOR='white'>23</TD>
<TD BGCOLOR='white'>24</TD>
<TD BGCOLOR='white'>25</TD>
<TD BGCOLOR='white'>26</TD>
<TD BGCOLOR='white'>27</TD>
<TD BGCOLOR='white'>28</TD>
</TR>
<TR>
<TD BGCOLOR='white'>29</TD>
<TD BGCOLOR='white'>30</TD>
<TD BGCOLOR='white'>31</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
</TR>
</TABLE>
</TD>
</TR>
<TD VALIGN='top'><TABLE BGCOLOR='black' CELLPADDING='2' CELLSPACING='1'>

<TR BGCOLOR='Yellow'><TD COLSPAN='7'><B>J&nbsp;1752   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;April</B></TD></TR>

<TR BGCOLOR='LightYellow'><TD WIDTH='36'>Sun</TD><TD WIDTH='36'>Mon</TD><TD WIDTH='36'>Tue</TD><TD WIDTH='36'>Wed</TD><TD WIDTH='36'>Thu</TD><TD  WIDTH='36'>Fri</TD><TD WIDTH='36'>Sat</TD></TR>
<TR>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>1</TD>
<TD BGCOLOR='white'>2</TD>
<TD BGCOLOR='white'>3</TD>
<TD BGCOLOR='white'>4</TD>
</TR>
<TR>
<TD BGCOLOR='white'>5</TD>
<TD BGCOLOR='white'>6</TD>
<TD BGCOLOR='white'>7</TD>
<TD BGCOLOR='white'>8</TD>
<TD BGCOLOR='white'>9</TD>
<TD BGCOLOR='white'>10</TD>
<TD BGCOLOR='white'>11</TD>
</TR>
<TR>
<TD BGCOLOR='white'>12</TD>
<TD BGCOLOR='white'>13</TD>
<TD BGCOLOR='white'>14</TD>
<TD BGCOLOR='white'>15</TD>
<TD BGCOLOR='white'>16</TD>
<TD BGCOLOR='white'>17</TD>
<TD BGCOLOR='white'>18</TD>
</TR>
<TR>
<TD BGCOLOR='white'>19</TD>
<TD BGCOLOR='white'>20</TD>
<TD BGCOLOR='white'>21</TD>
<TD BGCOLOR='white'>22</TD>
<TD BGCOLOR='white'>23</TD>
<TD BGCOLOR='white'>24</TD>
<TD BGCOLOR='white'>25</TD>
</TR>
<TR>
<TD BGCOLOR='white'>26</TD>
<TD BGCOLOR='white'>27</TD>
<TD BGCOLOR='white'>28</TD>
<TD BGCOLOR='white'>29</TD>
<TD BGCOLOR='white'>30</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
</TR>
</TABLE>
</TD>
<TD VALIGN='top'><TABLE BGCOLOR='black' CELLPADDING='2' CELLSPACING='1'>

<TR BGCOLOR='Yellow'><TD COLSPAN='7'><B>J&nbsp;1752   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;May</B></TD></TR>

<TR BGCOLOR='LightYellow'><TD WIDTH='36'>Sun</TD><TD WIDTH='36'>Mon</TD><TD WIDTH='36'>Tue</TD><TD WIDTH='36'>Wed</TD><TD WIDTH='36'>Thu</TD><TD  WIDTH='36'>Fri</TD><TD WIDTH='36'>Sat</TD></TR>
<TR>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>1</TD>
<TD BGCOLOR='white'>2</TD>
</TR>
<TR>
<TD BGCOLOR='white'>3</TD>
<TD BGCOLOR='white'>4</TD>
<TD BGCOLOR='white'>5</TD>
<TD BGCOLOR='white'>6</TD>
<TD BGCOLOR='white'>7</TD>
<TD BGCOLOR='white'>8</TD>
<TD BGCOLOR='white'>9</TD>
</TR>
<TR>
<TD BGCOLOR='white'>10</TD>
<TD BGCOLOR='white'>11</TD>
<TD BGCOLOR='white'>12</TD>
<TD BGCOLOR='white'>13</TD>
<TD BGCOLOR='white'>14</TD>
<TD BGCOLOR='white'>15</TD>
<TD BGCOLOR='white'>16</TD>
</TR>
<TR>
<TD BGCOLOR='white'>17</TD>
<TD BGCOLOR='white'>18</TD>
<TD BGCOLOR='white'>19</TD>
<TD BGCOLOR='white'>20</TD>
<TD BGCOLOR='white'>21</TD>
<TD BGCOLOR='white'>22</TD>
<TD BGCOLOR='white'>23</TD>
</TR>
<TR>
<TD BGCOLOR='white'>24</TD>
<TD BGCOLOR='white'>25</TD>
<TD BGCOLOR='white'>26</TD>
<TD BGCOLOR='white'>27</TD>
<TD BGCOLOR='white'>28</TD>
<TD BGCOLOR='white'>29</TD>
<TD BGCOLOR='white'>30</TD>
</TR>
<TR>
<TD BGCOLOR='white'>31</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
</TR>
</TABLE>
</TD>
<TD VALIGN='top'><TABLE BGCOLOR='black' CELLPADDING='2' CELLSPACING='1'>

<TR BGCOLOR='Yellow'><TD COLSPAN='7'><B>J&nbsp;1752   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;June</B></TD></TR>

<TR BGCOLOR='LightYellow'><TD WIDTH='36'>Sun</TD><TD WIDTH='36'>Mon</TD><TD WIDTH='36'>Tue</TD><TD WIDTH='36'>Wed</TD><TD WIDTH='36'>Thu</TD><TD  WIDTH='36'>Fri</TD><TD WIDTH='36'>Sat</TD></TR>
<TR>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>1</TD>
<TD BGCOLOR='white'>2</TD>
<TD BGCOLOR='white'>3</TD>
<TD BGCOLOR='white'>4</TD>
<TD BGCOLOR='white'>5</TD>
<TD BGCOLOR='white'>6</TD>
</TR>
<TR>
<TD BGCOLOR='white'>7</TD>
<TD BGCOLOR='white'>8</TD>
<TD BGCOLOR='white'>9</TD>
<TD BGCOLOR='white'>10</TD>
<TD BGCOLOR='white'>11</TD>
<TD BGCOLOR='white'>12</TD>
<TD BGCOLOR='white'>13</TD>
</TR>
<TR>
<TD BGCOLOR='white'>14</TD>
<TD BGCOLOR='white'>15</TD>
<TD BGCOLOR='white'>16</TD>
<TD BGCOLOR='white'>17</TD>
<TD BGCOLOR='white'>18</TD>
<TD BGCOLOR='white'>19</TD>
<TD BGCOLOR='white'>20</TD>
</TR>
<TR>
<TD BGCOLOR='white'>21</TD>
<TD BGCOLOR='white'>22</TD>
<TD BGCOLOR='white'>23</TD>
<TD BGCOLOR='white'>24</TD>
<TD BGCOLOR='white'>25</TD>
<TD BGCOLOR='white'>26</TD>
<TD BGCOLOR='white'>27</TD>
</TR>
<TR>
<TD BGCOLOR='white'>28</TD>
<TD BGCOLOR='white'>29</TD>
<TD BGCOLOR='white'>30</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
</TR>
</TABLE>
</TD>
</TR>
<TD VALIGN='top'><TABLE BGCOLOR='black' CELLPADDING='2' CELLSPACING='1'>

<TR BGCOLOR='Yellow'><TD COLSPAN='7'><B>J&nbsp;1752   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;July</B></TD></TR>

<TR BGCOLOR='LightYellow'><TD WIDTH='36'>Sun</TD><TD WIDTH='36'>Mon</TD><TD WIDTH='36'>Tue</TD><TD WIDTH='36'>Wed</TD><TD WIDTH='36'>Thu</TD><TD  WIDTH='36'>Fri</TD><TD WIDTH='36'>Sat</TD></TR>
<TR>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>1</TD>
<TD BGCOLOR='white'>2</TD>
<TD BGCOLOR='white'>3</TD>
<TD BGCOLOR='white'>4</TD>
</TR>
<TR>
<TD BGCOLOR='white'>5</TD>
<TD BGCOLOR='white'>6</TD>
<TD BGCOLOR='white'>7</TD>
<TD BGCOLOR='white'>8</TD>
<TD BGCOLOR='white'>9</TD>
<TD BGCOLOR='white'>10</TD>
<TD BGCOLOR='white'>11</TD>
</TR>
<TR>
<TD BGCOLOR='white'>12</TD>
<TD BGCOLOR='white'>13</TD>
<TD BGCOLOR='white'>14</TD>
<TD BGCOLOR='white'>15</TD>
<TD BGCOLOR='white'>16</TD>
<TD BGCOLOR='white'>17</TD>
<TD BGCOLOR='white'>18</TD>
</TR>
<TR>
<TD BGCOLOR='white'>19</TD>
<TD BGCOLOR='white'>20</TD>
<TD BGCOLOR='white'>21</TD>
<TD BGCOLOR='white'>22</TD>
<TD BGCOLOR='white'>23</TD>
<TD BGCOLOR='white'>24</TD>
<TD BGCOLOR='white'>25</TD>
</TR>
<TR>
<TD BGCOLOR='white'>26</TD>
<TD BGCOLOR='white'>27</TD>
<TD BGCOLOR='white'>28</TD>
<TD BGCOLOR='white'>29</TD>
<TD BGCOLOR='white'>30</TD>
<TD BGCOLOR='white'>31</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
</TR>
</TABLE>
</TD>
<TD VALIGN='top'><TABLE BGCOLOR='black' CELLPADDING='2' CELLSPACING='1'>

<TR BGCOLOR='Yellow'><TD COLSPAN='7'><B>J&nbsp;1752   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;August</B></TD></TR>

<TR BGCOLOR='LightYellow'><TD WIDTH='36'>Sun</TD><TD WIDTH='36'>Mon</TD><TD WIDTH='36'>Tue</TD><TD WIDTH='36'>Wed</TD><TD WIDTH='36'>Thu</TD><TD  WIDTH='36'>Fri</TD><TD WIDTH='36'>Sat</TD></TR>
<TR>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>1</TD>
</TR>
<TR>
<TD BGCOLOR='white'>2</TD>
<TD BGCOLOR='white'>3</TD>
<TD BGCOLOR='white'>4</TD>
<TD BGCOLOR='white'>5</TD>
<TD BGCOLOR='white'>6</TD>
<TD BGCOLOR='white'>7</TD>
<TD BGCOLOR='white'>8</TD>
</TR>
<TR>
<TD BGCOLOR='white'>9</TD>
<TD BGCOLOR='white'>10</TD>
<TD BGCOLOR='white'>11</TD>
<TD BGCOLOR='white'>12</TD>
<TD BGCOLOR='white'>13</TD>
<TD BGCOLOR='white'>14</TD>
<TD BGCOLOR='white'>15</TD>
</TR>
<TR>
<TD BGCOLOR='white'>16</TD>
<TD BGCOLOR='white'>17</TD>
<TD BGCOLOR='white'>18</TD>
<TD BGCOLOR='white'>19</TD>
<TD BGCOLOR='white'>20</TD>
<TD BGCOLOR='white'>21</TD>
<TD BGCOLOR='white'>22</TD>
</TR>
<TR>
<TD BGCOLOR='white'>23</TD>
<TD BGCOLOR='white'>24</TD>
<TD BGCOLOR='white'>25</TD>
<TD BGCOLOR='white'>26</TD>
<TD BGCOLOR='white'>27</TD>
<TD BGCOLOR='white'>28</TD>
<TD BGCOLOR='white'>29</TD>
</TR>
<TR>
<TD BGCOLOR='white'>30</TD>
<TD BGCOLOR='white'>31</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
</TR>
</TABLE>
</TD>

<TD VALIGN='top'><TABLE BGCOLOR='black' CELLPADDING='2' CELLSPACING='1'>

<TR BGCOLOR='GreenYellow'><TD COLSPAN='7'><B>J/G&nbsp;1752   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;September</B></TD></TR>

<TR BGCOLOR='LightYellow'><TD WIDTH='36'>Sun</TD><TD WIDTH='36'>Mon</TD><TD WIDTH='36'>Tue</TD><TD WIDTH='36'>Wed</TD><TD WIDTH='36' BGCOLOR='LightCyan'>Thu</TD><TD  WIDTH='36' BGCOLOR='LightCyan'>Fri</TD><TD WIDTH='36' BGCOLOR='LightCyan'>Sat</TD></TR>
<TR>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>1</TD>
<TD BGCOLOR='yellow'><B>2</B></TD>
<TD BGCOLOR='cyan'  ><B>14</B></TD>
<TD BGCOLOR='white'>15</TD>
<TD BGCOLOR='white'>16</TD>
</TR>
<TR BGCOLOR='LightCyan'><TD WIDTH='36'>Sun</TD><TD WIDTH='36'>Mon</TD><TD WIDTH='36'>Tue</TD><TD WIDTH='36'>Wed</TD><TD WIDTH='36'>Thu</TD><TD  WIDTH='36'>Fri</TD><TD WIDTH='36'>Sat</TD></TR>

<TR>
<TD BGCOLOR='white'>17</TD>
<TD BGCOLOR='white'>18</TD>
<TD BGCOLOR='white'>19</TD>
<TD BGCOLOR='white'>20</TD>
<TD BGCOLOR='white'>21</TD>
<TD BGCOLOR='white'>22</TD>
<TD BGCOLOR='white'>23</TD>
</TR>
<TR>
<TD BGCOLOR='white'>24</TD>
<TD BGCOLOR='white'>25</TD>
<TD BGCOLOR='white'>26</TD>
<TD BGCOLOR='white'>27</TD>
<TD BGCOLOR='white'>28</TD>
<TD BGCOLOR='white'>29</TD>
<TD BGCOLOR='white'>30</TD>
</TR>
<TR>
<TD BGCOLOR='black'>&nbsp;</TD>
<TD BGCOLOR='black'>&nbsp;</TD>
<TD BGCOLOR='black'>&nbsp;</TD>
<TD BGCOLOR='black'>&nbsp;</TD>
<TD BGCOLOR='black'>&nbsp;</TD>
<TD BGCOLOR='black'>&nbsp;</TD>
<TD BGCOLOR='black'>&nbsp;</TD>
</TR>
</TABLE>
</TD>
</TR>
<TD VALIGN='top'><TABLE BGCOLOR='black' CELLPADDING='2' CELLSPACING='1'>

<TR BGCOLOR='Cyan'><TD COLSPAN='7'><B>G&nbsp;1752   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;October</B></TD></TR>

<TR BGCOLOR='LightCyan'><TD WIDTH='36'>Sun</TD><TD WIDTH='36'>Mon</TD><TD WIDTH='36'>Tue</TD><TD WIDTH='36'>Wed</TD><TD WIDTH='36'>Thu</TD><TD  WIDTH='36'>Fri</TD><TD WIDTH='36'>Sat</TD></TR>
<TR>
<TD BGCOLOR='white'>1</TD>
<TD BGCOLOR='white'>2</TD>
<TD BGCOLOR='white'>3</TD>
<TD BGCOLOR='white'>4</TD>
<TD BGCOLOR='white'>5</TD>
<TD BGCOLOR='white'>6</TD>
<TD BGCOLOR='white'>7</TD>
</TR>
<TR>
<TD BGCOLOR='white'>8</TD>
<TD BGCOLOR='white'>9</TD>
<TD BGCOLOR='white'>10</TD>
<TD BGCOLOR='white'>11</TD>
<TD BGCOLOR='white'>12</TD>
<TD BGCOLOR='white'>13</TD>
<TD BGCOLOR='white'>14</TD>
</TR>
<TR>
<TD BGCOLOR='white'>15</TD>
<TD BGCOLOR='white'>16</TD>
<TD BGCOLOR='white'>17</TD>
<TD BGCOLOR='white'>18</TD>
<TD BGCOLOR='white'>19</TD>
<TD BGCOLOR='white'>20</TD>
<TD BGCOLOR='white'>21</TD>
</TR>
<TR>
<TD BGCOLOR='white'>22</TD>
<TD BGCOLOR='white'>23</TD>
<TD BGCOLOR='white'>24</TD>
<TD BGCOLOR='white'>25</TD>
<TD BGCOLOR='white'>26</TD>
<TD BGCOLOR='white'>27</TD>
<TD BGCOLOR='white'>28</TD>
</TR>
<TR>
<TD BGCOLOR='white'>29</TD>
<TD BGCOLOR='white'>30</TD>
<TD BGCOLOR='white'>31</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
</TR>
</TABLE>
</TD>
<TD VALIGN='top'><TABLE BGCOLOR='black' CELLPADDING='2' CELLSPACING='1'>

<TR BGCOLOR='Cyan'><TD COLSPAN='7'><B>G&nbsp;1752   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;November</B></TD></TR>

<TR BGCOLOR='LightCyan'><TD WIDTH='36'>Sun</TD><TD WIDTH='36'>Mon</TD><TD WIDTH='36'>Tue</TD><TD WIDTH='36'>Wed</TD><TD WIDTH='36'>Thu</TD><TD  WIDTH='36'>Fri</TD><TD WIDTH='36'>Sat</TD></TR>
<TR>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>1</TD>
<TD BGCOLOR='white'>2</TD>
<TD BGCOLOR='white'>3</TD>
<TD BGCOLOR='white'>4</TD>
</TR>
<TR>
<TD BGCOLOR='white'>5</TD>
<TD BGCOLOR='white'>6</TD>
<TD BGCOLOR='white'>7</TD>
<TD BGCOLOR='white'>8</TD>
<TD BGCOLOR='white'>9</TD>
<TD BGCOLOR='white'>10</TD>
<TD BGCOLOR='white'>11</TD>
</TR>
<TR>
<TD BGCOLOR='white'>12</TD>
<TD BGCOLOR='white'>13</TD>
<TD BGCOLOR='white'>14</TD>
<TD BGCOLOR='white'>15</TD>
<TD BGCOLOR='white'>16</TD>
<TD BGCOLOR='white'>17</TD>
<TD BGCOLOR='white'>18</TD>
</TR>
<TR>
<TD BGCOLOR='white'>19</TD>
<TD BGCOLOR='white'>20</TD>
<TD BGCOLOR='white'>21</TD>
<TD BGCOLOR='white'>22</TD>
<TD BGCOLOR='white'>23</TD>
<TD BGCOLOR='white'>24</TD>
<TD BGCOLOR='white'>25</TD>
</TR>
<TR>
<TD BGCOLOR='white'>26</TD>
<TD BGCOLOR='white'>27</TD>
<TD BGCOLOR='white'>28</TD>
<TD BGCOLOR='white'>29</TD>
<TD BGCOLOR='white'>30</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
</TR>
</TABLE>
</TD>
<TD VALIGN='top'><TABLE BGCOLOR='black' CELLPADDING='2' CELLSPACING='1'>

<TR BGCOLOR='Cyan'><TD COLSPAN='7'><B>G&nbsp;1752   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;December</B></TD></TR>

<TR BGCOLOR='LightCyan'><TD WIDTH='36'>Sun</TD><TD WIDTH='36'>Mon</TD><TD WIDTH='36'>Tue</TD><TD WIDTH='36'>Wed</TD><TD WIDTH='36'>Thu</TD><TD  WIDTH='36'>Fri</TD><TD WIDTH='36'>Sat</TD></TR>
<TR>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>1</TD>
<TD BGCOLOR='white'>2</TD>
</TR>
<TR>
<TD BGCOLOR='white'>3</TD>
<TD BGCOLOR='white'>4</TD>
<TD BGCOLOR='white'>5</TD>
<TD BGCOLOR='white'>6</TD>
<TD BGCOLOR='white'>7</TD>
<TD BGCOLOR='white'>8</TD>
<TD BGCOLOR='white'>9</TD>
</TR>
<TR>
<TD BGCOLOR='white'>10</TD>
<TD BGCOLOR='white'>11</TD>
<TD BGCOLOR='white'>12</TD>
<TD BGCOLOR='white'>13</TD>
<TD BGCOLOR='white'>14</TD>
<TD BGCOLOR='white'>15</TD>
<TD BGCOLOR='white'>16</TD>
</TR>
<TR>
<TD BGCOLOR='white'>17</TD>
<TD BGCOLOR='white'>18</TD>
<TD BGCOLOR='white'>19</TD>
<TD BGCOLOR='white'>20</TD>
<TD BGCOLOR='white'>21</TD>
<TD BGCOLOR='white'>22</TD>
<TD BGCOLOR='white'>23</TD>
</TR>
<TR>
<TD BGCOLOR='white'>24</TD>
<TD BGCOLOR='white'>25</TD>
<TD BGCOLOR='white'>26</TD>
<TD BGCOLOR='white'>27</TD>
<TD BGCOLOR='white'>28</TD>
<TD BGCOLOR='white'>29</TD>
<TD BGCOLOR='white'>30</TD>
</TR>
<TR>
<TD BGCOLOR='white'>31</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
<TD BGCOLOR='white'>&nbsp;</TD>
</TR>
</TABLE>
</TD>
</TR>
</TABLE>";

return $out;


} // End of  JG_1752_Transition_Calendar_Table_Full()

// ************************************************************************
// ************************************************************************


   function Month_Num ($Mmm)

   {

      $MMM = strtoupper(substr(trim($Mmm), 0,3));
     $MMMs = "JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC";
        $m = 0;
     for($i=0;   $i < 12;   $i++)
     {
       $XXX = substr($MMMs, 3*$i, 3);
       if ($XXX == $MMM) {$m = $i+1;}
     }
       return $m;
    }



// ************************************************************************
// ************************************************************************


function ymd_for_GJD ($JD)
{
$j = $JD + 32044;
$g = floor($j/146097);
$dg = $j % 146097;
$c = floor((1 + floor($dg / 36524))*3/4);
$dc = $dg - $c*36524;
$b = floor($dc / 1461);
$db = $dc % 1461;
$a = floor((floor($db/365) + 1)*3/4);
$da = $db - $a*365;
$y = 400*$g + 100*$c + 4*$b + $a;
$m = floor((5*$da + 308) / 153) - 2;
$d = $da - floor(153*($m + 4)/5) + 122;

$w = $y - 4800 + floor(($m + 2)/12);
$Y = ($w < 0) ? $w - 1 : $w;
$M = sprintf ("%02d", ($m + 2) % 12 + 1);
$D = sprintf("%02d", $d + 1);

 return "$Y$M$D";

}

// ************************************************************************
// ************************************************************************

   function Friday_the_13ths ($y, $CalMode)

{

   $out = "Friday the 13ths for the year <B>$y</B><BR>";

   $kount = 0;

   for ($m=1;   $m <= 12;   $m++)
 {
   $ym01 = $y . sprintf("%02d", $m) . "01";

   $JD = JD_for_ymd ($ym01, $CalMode);

   $DoW1 = ($JD + 1) % 7;

   if ($DoW1 == 0)
      {
       $out .= "\n<B>" . Month_Str($m) . "</B>" . "<BR>";   $kount++;
      }

 } // End of  for ($m=1; ...)


// -------------------------------------
// Filter specific Friday the 13th years
// according to number of occurrences in
// the given year.  Where > 0  means ALL

   if ($kount > 0)

      {return "$out" . "\nCount = $kount<BR>\n";}

else
      {return "$y<BR>\n";}

} // End of  Friday_the_13ths()


// ************************************************************************
// ************************************************************************

 /*

 THIS FUNCTION COMPUTES THE DATE OF EASTER SUNDAY FOR ANY GREGORIAN YEAR

G is the Golden Number - 1

H is 23-Epact (modulo 30)

I is the number of days from 21 March to the Paschal full moon

J is the weekday for the Paschal full moon (0=Sunday, 1=Monday, etc.)

L is the number of days from 21 March to the Sunday on or before the Paschal full moon (a number between -6 and 28)

*/

 function Easter_Sunday ($y)

{

$G = $y % 19;

$I = (19*$G + 15) % 30;

$J = ($y + floor($y/ 4) + $I) % 7;

$C = floor($y/ 100);

$H = ($C - floor($C/4) - floor((8*$C+13)/25) + 19*$G + 15) % 30;

$I = $H - floor($H/28)*(1 - floor(29/($H + 1))*floor((21 - $G)/11));

$J = ($y + floor($y/ 4) + $I + 2 - $C + floor($C/4)) % 7;

$L = $I - $J;

$m = 3 + floor(($L + 40)/44);

$d = $L + 28 - 31*floor($m/4);

$m = sprintf("%02d", $m);
$d = sprintf("%02d", $d);

return "$y$m$d";

} // End of  Easter_Sunday ()



// ************************************************************************
// ************************************************************************

/*
   ==========================================
   This function returns the correction to be
   applied to the ecliptical longitude to
   reduce it from the dynamical system to
   the FK5 system of coordinates.

*/

   Function FK5_Lng_Corr ($JD, $EclLngDeg, $EclLatDeg)

{
// Compute ($t) in Julian centuries
// from J2000.0
   $t = ($JD - 2451545.0) / 36525;

// Read ecliptical latitude argument.
   $b = Deg2Rad($EclLatDeg);

   $Lprime = Deg2Rad($EclLngDeg - 1.397*$t - 0.00031*$t*$t);

// Compute longitude correction in degrees.
   $w = (0.03916*(cos($Lprime) + sin($Lprime))*tan($b) - 0.09033)
      / 3600;

// Return the longitude
// correction.
   return $w;

} // End of  FK5_Lng_Corr()


// ************************************************************************
// ************************************************************************


/*
   ==========================================
   This function returns the correction to be
   applied to the ecliptical latitude to
   reduce it from the dynamical system to
   the FK5 system of coordinates.
*/

   Function FK5_Lat_Corr ($JD, $EclLngDeg)
{
// -------------------------------------
// Compute Julian centuries from J2000.0
   $t = ($JD - 2451545) / 36525;

// ------------------------
// Compute auxiliary angle.
   $LPrime = Deg2Rad($EclLngDeg - 1.397*$t - 0.00031*$t*$t);

// -------------------------------------------------
// Done.  Return the latitude correction in degrees.
   return 0.03916*(cos($LPrime) - sin($LPrime)) / 3600;

} // End of  FK5_Lat_Corr()

// ************************************************************************
// ************************************************************************

   function Ecl_To_Equ_Coords ($EclLngDegArg, $EclLatDegArg, $EpsDegArg)

  {

// ------------------------------
// Convert input ecliptical angle
// arguments into radians.

   $Lng = Deg2Rad(trim($EclLngDegArg));
   $Lat = Deg2Rad(trim($EclLatDegArg));
   $Eps = Deg2Rad(trim($EpsDegArg));

// -------------------------------------
// Compute the equatorial RA in degrees.

   $y = sin($Lng)*cos($Eps) - tan($Lat)*sin($Eps);
   $x = cos($Lng);
   $RADeg = Rad2Deg(ATan2($y, $x));
   if ($RADeg < 0) {$RADeg += 360;}

// -----------------------------------
// Compute the equatorial declination.

   $w = ASin(sin($Lat)*cos($Eps) + cos($Lat)*sin($Lng)*sin($Eps));
   $DeclDeg = Rad2Deg($w);

// ---------------------------------------------
// Done.  Return the RA and declination, both in
// degrees, in a space delimited data vector.

   return "$RADeg $DeclDeg";

  } // End of  Ecl_To_Equ_Coords()



// ************************************************************************
// ************************************************************************

/*

  THIS FUNCTION RETURNS THE nth TOKEN OR
  WORD FROM A GIVEN INPUT SOURCE STRING.

  ON ERROR, AN EMPTY STRING IS RETURNED IF
  n IS GREATER THAN THE NUMBER OF WORDS IN
  THE GIVEN SOURCE STRING.

*/

  function nth_Token($n, $SourceTextString)

{

 $TokensString = preg_replace("/\s+/", ' ', trim($SourceTextString));

 if ($TokensString == "") {return "";}

 $TokensList = preg_split("[ ]", $TokensString);

 $TokensCount = count($TokensList);

 if ($n < 1 or $n > $TokensCount) {return "";}

 $nthToken = $TokensList[$n - 1];

 return $nthToken;

}


// ************************************************************************
// ************************************************************************


// Generate array query as complete HTML TABLE code (PHP5)


   function Array_Query ($ArrayNameArg)
{

   $out = '';

   $x = $ArrayNameArg;

   ForEach ($x as $key => $value)
           {
            $out .= "<TR><TD BGCOLOR=\"cyan\">$key</TD><TD BGCOLOR=\"white\">$value</TD></TR>\n";
           }

   return "<TABLE BGCOLOR=\"black\" CELLPADDING=\"2\" CELLSPACING=\"1\">$out</TABLE>";

}



// ************************************************************************
// ************************************************************************


function google_lng_lat ($LocationString)

{

$w = file_get_contents("http://maps.google.com/maps/geo?q=$LocationString&oe=utf8&key=GoogleKey");

$w = json_decode($w, TRUE);

list($longitude,$latitude) = $w['Placemark'][0]['Point']['coordinates'];

if ($longitude == "" or $latitude == "") {return "<PRE>Location not found.</PRE>";}

$longitude = sprintf("%+2.7f", $longitude);
$latitude  = sprintf("%+2.7f", $latitude);

$out = trim("$LocationString\nLongitude = $longitude\nLatitude  = $latitude");

return "<PRE>$out</PRE>";

}

// ************************************************************************
// ************************************************************************



// ************************************************************************
// ************************************************************************



// ************************************************************************
// ************************************************************************


















// THIS FUNCTION MUST BE THE FINAL FUNCTION CONTAINED WITHIN THIS
// MODULE AND NO OTHER FUNCTIONS MUST FOLLOW IT.

// This function scans and returns a listing of all of the custom
// definitions and functions contained within this Kore2010 module.

   function NeoCore_Info ()

{
   global $_MODULE_VERSION_;

   $NeoCoreLines      = file("../core/NeoCore.php");
   $NeoCoreLinesCount = count($NeoCoreLines);


// ============================================================
// Generate list of all custom constants within NeoCore module.

   $ConstantsList  = "";
   $ConstantsCount = 0;

   for ($i=0;   $i < $NeoCoreLinesCount;   $i++)
       {
        $NeoCoreLine = trim($NeoCoreLines[$i]);
        $NeoCoreLine = str_replace(" ", "", $NeoCoreLine);

        if (StrToLower(substr($NeoCoreLine, 0, 8)) == 'define("')
           {
            $w = trim(substr($NeoCoreLine, 8, strlen($NeoCoreLine)));
            $w = str_replace('",', " = ", $w);

            $ParenthesisPointerR = strpos($w, ")");

            $w = substr($w, 0, $ParenthesisPointerR);

            $ConstantsList .= " $w\n\n";

            $ConstantsCount++;
           }
       }


// =============================================================
// Generate list of all custom functions within NeoCore module.

   $FunctionsList  = "";
   $FunctionsCount = 0;

   for ($i=0;   $i < $NeoCoreLinesCount;   $i++)
       {
        $NeoCoreLine = trim($NeoCoreLines[$i]);

        if (StrToLower(substr($NeoCoreLine, 0, 8)) == "function")
           {
            $w = trim(substr($NeoCoreLine, 8, strlen($NeoCoreLine)));

            $FunctionsList .= " $w\n\n";

            $FunctionsCount++;
           }
       }

   $FunctionsList = trim($FunctionsList);


// =================================
// Return final listing code string.

   return

"<B><PRE>
 NeoProgrammics NeoCore MODULE $_MODULE_VERSION_ - INFO

 **********************************************
 **********************************************
 THE FOLLOWING $ConstantsCount CUSTOM CONSTANTS ARE DEFINED:

$ConstantsList
 **********************************************
 **********************************************
 THE FOLLOWING $FunctionsCount CUSTOM FUNCTIONS ARE DEFINED:

 $FunctionsList

</PRE></B>";

} // End of  NeoCore_Info ()











?>
