<?php

/*
  --------------------------------------------------------------------------
  Combinations Calculator

  This program computes the exact number all possible random combinations
  of (R) distinct items from a total of pool of (N) items altogether. In
  combinations, only which items are in the selected group matters, the
  sequential order in which the items are selected does not matter.

  Author:
  Jay Tanner - 2019
  Revised 2021 - Added names for big numbers up to 99 digits

  Current Web Site
  www.NeoProgrammics.com

  Development Language:
  PHP v7.1.8

  License:
  This program source code and any related data and graphics are released
  under the provisions of the Creative Commons Attribution-ShareAlike 4.0
  International.

  https://creativecommons.org/licenses/by-sa/4.0/legalcode
  --------------------------------------------------------------------------

*/


// -----------------------------------------------
// Set the path to the program to be executed when
// the submit button is clicked.  in this case, it
// is this program itself. It modifies itself each
// time it is called.

   $RunThisProgram = $_SERVER["SCRIPT_NAME"];

// ----------------------------------------
// Get current year (UT) from system clock.

   $cYear = gmdate("Y");

// ------------------------------------
// Read input arguments from interface.

   $N = trim(@$_POST["N"]); if ($N == ''){$N = '1';}
   $r = trim(@$_POST["r"]); if ($r == ''){$r = '1';}

// Filter for invalid arguments.

   if ($N < 0 or $N > 9999 or $r < 0 or $r > $N)
{
   $ErrorFlag = FALSE;
   $out0 = "<b style='color:red;'>ERROR: ";
   $out1 = "";
   $NumRows = 1;

 if ($N < 0 or $N > 9999)
    {
     $out0 .= "The (N) value must be in the range from 0 to 9999."; $ErrorFlag = TRUE;
     $out1 = "";
    }

 if ($r < 0 or $r > $N and $ErrorFlag === FALSE)
    {
     $out0 .= "The (R) value must be &le; $N in this case.";
     $out1 = "";
    }
}

else

{
// --------------------------------------------
// Compute C = C(N, r) for the given arguments.

   $CalcTimeStart = MicroTime(TRUE);
   $C = bcComb_N_R($N, $r);
   $DigitsCount = StrLen($C);
   $u = ($DigitsCount > 6 and $DigitsCount < 100)? '<br>' . BC_Big_Int_Name($C) : '';

// Create scientific notation string.
   $SciNotStr = '<br><br>'.substr($C,0,1).'.'.substr($C,1,3).'E+'.($DigitsCount-1);

   $CalcTimeSec = MicroTime(TRUE) - $CalcTimeStart;
   $CalcTimeSec = ($CalcTimeSec < 0.001)? sprintf("%5.6f", $CalcTimeSec) : sprintf("%5.3f", $CalcTimeSec);
   $s = ($DigitsCount > 1)? 's' : '';
   $dot = ($DigitsCount > 80)? '' : '.';
   $DigitsMssg = ''; // ($DigitsCount > 80)? "with up to 80 digits displayed per output line.\n" : "";

   $out0 = "The EXACT value of <b>C($N,&nbsp; $r)</b> is computed below and consists of <b>$DigitsCount</b> digit$s$dot<br>$DigitsMssg$u$SciNotStr<br><br>";

   $out1 = $C;

   $NumRows = 3 + floor($DigitsCount / 80);
}

print <<< _HTML

<!DOCTYPE HTML>

<HTML lang='en'>

<head>

<meta http-equiv="content-type" content="text/html; charset=UTF-8">

<title>Combinations C(N,R) Calculator</title>
<meta name='viewport' content='width=device-width, initial-scale=1'>
<meta http-equiv='content-type' content='text/html; charset=UTF-8'>
<meta name='description' content='This program computes the exact total number of possible combinations of R items taken from a total pool of N distinct items'>
<meta name='keywords' content='combinations,combinations and permutations,combinations calculator'>
<meta name='author' content='Jay Tanner - PHPScienceLabs.com'>
<meta http-equiv='pragma'  content='no-cache'>
<meta http-equiv='expires' content='-1'>
<meta name='robots'    content='index,follow'>
<meta name='googlebot' content='index,follow'>
<link rel="canonical" href="https://www.phpsciencelabs.com/combinations-calculator/">

<style type='text/CSS'>
BODY
{color:white; background-color:black;  font-family:Verdana; font-size:15px}

TABLE
{font-family:Verdana; font-size:12px; border: 1px solid black;}

LI
{text-align:justify;}

TD
{color:black; background-color:white;  border:1px solid black; line-height:125%; font-size:14px; padding:6px; text-align:center;}

DIV
{color:black; background-color:white;  font-family:Verdana; text-align:justify; padding:4px; font-size:14px;}

PRE
{color:black; background-color:LightYellow;  font-family:monospace; font-size:16px; font-weight:bold; text-align:left; border:1px solid black; border-radius:8px; box-shadow:3px 3px 2px #999999; padding:4px;}

CODE
{font-family:monospace; font-size:16px; font-weight:bold;}

TEXTAREA
{color:black; background-color:white; font-family:monospace; font-size:14px; font-weight:bold; box-shadow:4px 4px 3px #999999; border-radius: 8px; border:1px solid black; padding:4px;}

IMG
{border:1px solid #BBBBBB; border-radius:8px; box-shadow:2px 2px 3px #999999;}

INPUT[type="text"]::-ms-clear {width:0; height:0;}

INPUT[type="text"]
{color:black; background-color:white; font-size:18px; font-family:monospace; font-weight:bold; text-align:center; box-shadow:2px 2px 3px #999999; border:2px solid black; border-radius:4px;}

INPUT[type="text"]:focus
{background-color:white; font-family:monospace; font-size:18px; border:2px solid blue; text-align:center; font-weight:bold; box-shadow:2px 2px 3px #666666; border-radius:4px;}


INPUT[type="submit"]
{font-weight:bold; border:1px solid black; padding:3px; border-radius:4px; padding:3px;}

INPUT[type="submit"]:hover
{box-shadow:2px 2px 5px #222222; background:cyan; font-weight:bold; border:1px solid black; padding:3px; border-radius:4px; padding:3px;}


INPUT[type="checkbox"]:checked
{box-shadow:2px 2px 3px #222222;}

HR {background-color:black; height:2px; border:0px;}

A:link,  A:visited {background-color:transparent; color:blue; font-family:Verdana; font-size:12px; font-weight:bold; text-decoration:none; line-height:150%; padding:2px;}
A:hover, A:active  {background-color:transparent; color:red;  font-family:Verdana; font-size:12px; font-weight:bold; text-decoration:none; line-height:150%; padding:2px;}

::selection      {background-color:yellow; color:black;}  /* Only affects IE9+ and Safari     */
::-moz-selection {background-color:yellow; color:black;}  /* Only affects FireFox and Mozilla */
</style>

</head>

<body>

<table align='top' width='760'>
<tr><td style='color:white; font-size:200%; border:2px solid white; border-radius:8px 8px 0px 0px; background-color:#000066; font-weight:normal; text-align:center;'>Combinations C(N, R) Calculator<br><span style='font-size:60%;'>PHP Program by Jay Tanner</span>
</td></tr>

<tr><td style='border:1px solid black;'>
<div style='text-align:justify;'>
<b>Given a total pool of (N) distinct items, this program computes the total count of possible unique combinations of random groups of (R) taken at a time from that pool.&nbsp; Any two groups containing the same (R) items are considered identical, regardless of the order in which the items are selected from the pool.

<br><br>
<span style='color:red;'>NOTE:</span><br>
Since this program computes EXACT values and performs all of its computations in arbitrary-precision, in some cases, the computed values may extend out to tens of thousands of digits and could possibly take up to several seconds to return the computed result.

<hr>

<div style='text-align:center;'>
<img src='images/combinations_C(N_R).png' alt=''>
</div>

<hr>
<div style='text-align:center; background-color:LightCyan; border:1px solid black; padding:16px;'>
<form  name="form1" method="post"  action="$RunThisProgram">
<b>N</b> <span style='font-size:11px;'>(0 &nbsp;to&nbsp; 9999)</span> = <input name="N" type="text" value="$N" size='5' maxlength='4'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>R</b> <span style='font-size:11px;'>(0 &nbsp;to&nbsp; N)</span> = <input name="r" type="text" value="$r" size='5' maxlength='4'>&nbsp;&nbsp;&nbsp;
&nbsp;&nbsp;&nbsp;<input name="button1" type="submit" style='font-weight:bold;' value="Compute C (N, R)" OnClick="TextAreaOut.innerHTML = 'Working ...';">
</form>
</div>

<hr>

<br>
<div style='text-align:center;'>$out0</div>

<div style='text-align:center;'>
<textarea ID="TextAreaOut" style='font-size:18px; background-color:LightYellow; border:1px solid black;' cols='80' rows="$NumRows" readonly='readonly'>
$out1
</textarea>

</div>

</td></tr>

<tr><td style='text-align:justify;'>
Combinations are mixtures of items, but in no particular order.&nbsp; In each group of (R) items selected from a pool of (N) items, only <i>which items</i> make up the group is considered important, <i>not the sequential order</i> in which the items are selected for any group.
<br><br>
For example, ABCDEF is <i>identical</i> to DFACBE, BDFCEA, DABFCE and <i>all other combinations</i> (mixtures) of the same six letters.
<br><br>
The 5 cards making up a straight flush dealt in a poker game would be a good example of a combination where only <i>which 5 cards are held</i> is important, <i>not the order</i> in which they were dealt or received.
</td></tr>

<tr><td colspan='4'>
<table width='760' align="bottom">
<tr><td style='text-align:justify;'>
Below is a listing of the PHP function at the heart of the above <i>Combinations Calculator</i> program.&nbsp; It computes the arbitrary-precision count of the total number of possible unique combinations of (<b>N</b>) items
selected in groups of (<b>R</b>) at a time.&nbsp;

<br>

<pre style='font-size:18px; border-radius:8px; border:2px solid red;'>
&#47;*
  ==========================================================================
  This function returns the exact number all possible random combinations
  of (R) distinct items from a total of pool of (N) items altogether. In
  combinations, only which items are in the selected group matters, the
  sequential order in which the items are selected does not matter.

  Rules: (N, R) are non-negative integers where R &lt;= N

  Language : PHP
  ==========================================================================
*&#47;

  function bcComb_N_R (&#36;N, &#36;R)
&#123;
  &#36;C = 1;  &#36;j = &#36;N - &#36;R;

  for (&#36;i=0;   &#36;i &lt; &#36;j;   &#36;i++)
      &#123;
       &#36;C = bcDiv(bcMul(&#36;C, &#36;N-&#36;i), &#36;i+1);
      &#125;
  return &#36;C;
&#125;
</pre>
</td></tr>



</table>

<br>


<br>
<div style='font-size:10px; text-align:center;'>Jay Tanner - $cYear</div>

</td></tr>

</table>


</body>
</html>


_HTML;


/*
  ========================================================================
  This function returns the exact number all possible random combinations
  of (R) distinct items from a total of pool of (N) items altogether. In
  combinations, only which items are in the selected group matters, the
  sequential order in which the items are selected does not matter.

  Rules: (N, R) are non-negative integers where R &lt;= N

  ========================================================================
*/

  function bcComb_N_R ($N, $R)
{
  $C=1;  $j = $N-$R;

  for ($i=0;   $i < $j;   $i++) {$C = bcDiv(bcMul($C, $N-$i), $i+1);}

  return $C;
}



/*
  ----------------------------------------------------------------------------
  This function returns the formal names of very large
  integers up to a limit of 99 digits length.

  The American system of numerical nomenclature is used.

  Arguments:
  $BigIntStr = Large integer as a string (1 million and above).
  $LabelStr  = Optional lable string suffix to attach to output.
  ----------------------------------------------------------------------------
*/

   function BC_Big_Int_Name ($BigIntStr, $LabelStr='')
{
   $X = trim($BigIntStr);

// Read optional label string argument
// to be suffixed to returned result.
   $label = ' '.trim($LabelStr);

// Cut off any decimal digits from X without rounding.
   $X = bcAdd('0', $X);

// Return empty string if X < 1 million.
   $LenX = StrLen($X);  if (StrLen($X) < 7) {return '';}

   $NumDigits = StrLen($X);

   $i[0]  = '';
   $i[1]  = 'thousand';
   $i[2]  = 'million';
   $i[3]  = 'billion';
   $i[4]  = 'trillion';
   $i[5]  = 'quadrillion';
   $i[6]  = 'quintillion';
   $i[7]  = 'sextillion';
   $i[8]  = 'septillion';
   $i[9]  = 'octillion';
   $i[10] = 'nonillion';
   $i[11] = 'decillion';
   $i[12] = 'undecillion';
   $i[13] = 'duodecillion';
   $i[14] = 'tredecillion';
   $i[15] = 'quattuordecillion';
   $i[16] = 'quindecillion';
   $i[17] = 'sexdecillion';
   $i[18] = 'septendecillion';
   $i[19] = 'octodecillion';
   $i[20] = 'novemdecillion';
   $i[21] = 'vigintillion';
   $i[22] = 'unvigintillion';
   $i[23] = 'duovigintillion';
   $i[24] = 'trevigintillion';
   $i[25] = 'quattuorvigintillion';
   $i[26] = 'quinvigintillion';
   $i[27] = 'sexvigintillion';
   $i[28] = 'septenvigintillion';
   $i[29] = 'octovigintillion';
   $i[30] = 'novemvigintillion';
   $i[31] = 'trigintillion';
   $i[32] = 'untrigintillion';
   $i[33] = 'duotrigintillion';

   $j = floor($NumDigits / 3);

   $k = $NumDigits % 3;

   if ($k == 0)
      {$j -= 1;  $xxx = substr($X, 0, 3);}
   else
      {$xxx = substr($X, 0, $k);}

   $w = $xxx;  $w = LTrim($w, '0');  if (IntVal($w) == 0) {$w = '0';}

   if ($w == '0') {return '';}

// Collect 3 digits from X for decimal part.
   $u = substr($X, StrLen($w), 4) + 5;
   $ddd = SPrintF("%03d", substr($u, 0, StrLen($u)-1));

   return "\n$w.$ddd $i[$j]$label\n";

} // End of  BC_Big_Int_Name (BigIntStr)

// ---------------------------------------------------------------------------



// ---------------------------------------------------------------------------




?>


