<?php

/*
   Combined Stellar Magnitudes Calculator

   This program computes the total of multiple stellar magnitudes
   combined into a single value.

   Author  : Jay Tanner - 2023
   License : Public Domain
*/

   ob_start();

   $cYear = GMDate('Y');

// Define the program cookie name and set it to expire in 30 days.
// This cookie can be shared by other programs in the same common
// home folder together.

   $CookieName = 'Combined_Stellar_Magnitude_Calculator';
   $SetToExpireIn30Days = time() + 30*86400;

// --------------------------------
// Define script path and filename.

   $_AUTHOR_ = 'Jay Tanner';
   $_PROGRAM_VERSION_ = 'v1.5 '; $at = "&#97;&#116;"; $UTC = "&#85;&#84;&#67;";
   $_BaseScriptName_ = BaseName($_SERVER['SCRIPT_FILENAME']);
   $_REVISION_DATE_   = $_PROGRAM_VERSION_ .'Revised: '. GMDate("l, F d, Y $at h:i:s A   $UTC", FileMTime($_BaseScriptName_));

   $_RUN_ = Filter_Input(INPUT_POST, 'SCRIPT_NAME');

// Define internal document page title, HTML page heading text and revision date
   $_INTERNAL_TITLE_  = "Combined Stellar Magnitude Calculator";
   $_INTERFACE_TITLE_ = "<b style='font-size:150%; font-weight:normal;'>Combined Stellar Magnitude Calculator</b><br><span style='font-size:80%'>PHP Program by Jay Tanner - $cYear</span>";


// Define main TextArea text, background
// colors and HTML table row span.
   $TxColor = 'black';
   $BgColor = 'white';
   $ColSpan = 7;

// Generate 3 randomized default startup stellar magnitudes.
// Rand_Digits ($NumDigits=1, $Base=10, $SignFlag=FALSE, $RadixFlag=FALSE)
   $Rm1 = Random_Int(0, 4) . '.' . Rand_Digits (3, 10, FALSE, FALSE);
   $Rm2 = Random_Int(0, 4) . '.' . Rand_Digits (3, 10, FALSE, FALSE);
   $Rm3 = Random_Int(0, 4) . '.' . Rand_Digits (3, 10, FALSE, FALSE);
   $Rm4 = Random_Int(0, 4) . '.' . Rand_Digits (3, 10, FALSE, FALSE);
   $Rm5 = Random_Int(0, 4) . '.' . Rand_Digits (3, 10, FALSE, FALSE);

// Apply probability of neg/pos (default = 2)
   $Rm1 = ((Random_Int(0, PHP_INT_MAX) % 16 == 0)? '-':'+') . $Rm1;
   $Rm2 = ((Random_Int(0, PHP_INT_MAX) % 16 == 0)? '-':'+') . $Rm2;
   $Rm3 = ((Random_Int(0, PHP_INT_MAX) % 16 == 0)? '-':'+') . $Rm3;
   $Rm4 = ((Random_Int(0, PHP_INT_MAX) % 16 == 0)? '-':'+') . $Rm4;
   $Rm5 = ((Random_Int(0, PHP_INT_MAX) % 16 == 0)? '-':'+') . $Rm5;

// Apply probability of deleting (default = 4)
   if (Random_Int(0, PHP_INT_MAX) % 4 == 0) {$Rm1 = '';}
   if (Random_Int(0, PHP_INT_MAX) % 4 == 0) {$Rm2 = '';}
   if (Random_Int(0, PHP_INT_MAX) % 4 == 0) {$Rm3 = '';}

//   if (Random_Int(0, PHP_INT_MAX) % 4 == 0) {$Rm4 = '';}
//   if (Random_Int(0, PHP_INT_MAX) % 4 == 0) {$Rm5 = '';}

// Create random magnitude list.
   $RandomMagnitudesList = trim("$Rm1  $Rm2  $Rm3");

// Do this only if [COMPUTE] button was clicked.
   $w = Filter_Input(INPUT_POST, 'ComputeButton');
   if (!IsSet($w))

// ----------------------------------------------------
// If [COMPUTE] button was clicked and an active cookie
// exists, then restore the previous interface settings
// from it.
     {
      $w = Filter_Input(INPUT_COOKIE, $CookieName);
   if (IsSet($w))
      {
       $CookieDataString = Filter_Input(INPUT_COOKIE, $CookieName);
       list($StellarMagsList) = Preg_Split("[\|]", $CookieDataString);
      }

   else

// Set the initial default interface startup values.

 {
  $StellarMagsList = $RandomMagnitudesList;

// Store interface settings in cookie.
   $CookieDataString = $StellarMagsList;
   setcookie ($CookieName, $CookieDataString, $SetToExpireIn30Days);
  }
      } // End of  if (!isset(_POST['ComputeButton']))







// =======================================
// Read values of all interface arguments.
// Empty value is set to zero by default.

   $w = Filter_Input(INPUT_POST, 'ComputeButton');
   if (isset($w))
{
   $StellarMagsList = trim(Filter_Input(INPUT_POST, 'StellarMagsList'));

// If list is empty, then create random magnitudes list.
   if ($StellarMagsList == '')
   {
// Generate up to 5 randomized default test/demo magnitude values.
// Rand_Digits ($NumDigits=1, $Base=10, $SignFlag=FALSE, $RadixFlag=FALSE)
   $Rm1 = Random_Int(0, 5) . '.' . Rand_Digits (3, 5, FALSE, FALSE);
   $Rm2 = Random_Int(0, 5) . '.' . Rand_Digits (3, 5, FALSE, FALSE);
   $Rm3 = Random_Int(0, 5) . '.' . Rand_Digits (3, 5, FALSE, FALSE);
   $Rm4 = Random_Int(0, 5) . '.' . Rand_Digits (3, 5, FALSE, FALSE);
   $Rm5 = Random_Int(0, 5) . '.' . Rand_Digits (3, 5, FALSE, FALSE);

// Apply probability of neg/pos (default = 2)
   $Rm1 = ((Random_Int(0, PHP_INT_MAX) % 16 == 0)? '-':'+') . $Rm1;
   $Rm2 = ((Random_Int(0, PHP_INT_MAX) % 16 == 0)? '-':'+') . $Rm2;
   $Rm3 = ((Random_Int(0, PHP_INT_MAX) % 16 == 0)? '-':'+') . $Rm3;
   $Rm4 = ((Random_Int(0, PHP_INT_MAX) % 16 == 0)? '-':'+') . $Rm4;
   $Rm5 = ((Random_Int(0, PHP_INT_MAX) % 16 == 0)? '-':'+') . $Rm5;

// Apply probability of deleting (default = 4)
   if (Random_Int(0, PHP_INT_MAX) % 4 == 0) {$Rm1 = '';}
   if (Random_Int(0, PHP_INT_MAX) % 4 == 0) {$Rm2 = '';}
   if (Random_Int(0, PHP_INT_MAX) % 4 == 0) {$Rm3 = '';}
//   if (Random_Int(0, PHP_INT_MAX) % 4 == 0) {$Rm4 = '';}
//   if (Random_Int(0, PHP_INT_MAX) % 4 == 0) {$Rm5 = '';}

// Construct random magnitudes list.
   $StellarMagsList = PReg_Replace("/\s+/", " ", trim("$Rm1  $Rm2  $Rm3"));
   }


// --------------------------------------
// Store interface arguments in a cookie.
   $CookieDataString = "$StellarMagsList";
   SetCookie ($CookieName, $CookieDataString, $SetToExpireIn30Days);
}










// ===================================================
// Begin computations here if no error detected above.

   $w = Str_Replace(';', ' ', $StellarMagsList);
   $w = Str_Replace(',', ' ', $w);
   $w = PReg_Replace("/\s+/", " ", trim($w));
   $StellarMagsList = Str_Replace(' ', '  ', $w);

   $M = trim(Combined_Magnitudes ($StellarMagsList));

   $TextArea2Text =
"
Stellar Magnitudes List:
$StellarMagsList

Combined Stellar Magnitudes:
M = $M
";

$TextArea2Rows = 8 + Substr_Count($TextArea2Text, "\n");

//exit("$TextArea2Rows");

// 1.7  2.3  --> 1.2065






print <<< _HTML

<!DOCTYPE HTML>

<HTML lang='en'>

<head>

<title>Combined Stellar Magnitude Calculator</title>
<meta name='viewport' content='width=device-width, initial-scale=1'>
<meta http-equiv='content-type' content='text/html; charset=UTF-8'>
<meta name='description' content='Combined Stellar Magnitude Calculator'>
<meta name='keywords' content='combined magnitudes,stellar magnitude,stellar magnitude calculator'>
<meta name='author' content='Jay Tanner - PHPScienceLabs.com'>
<meta http-equiv='pragma'  content='no-cache'>
<meta http-equiv='expires' content='-1'>
<meta name='robots'    content='index,follow'>
<meta name='googlebot' content='index,follow'>
<link rel="canonical" href="https://www.phpsciencelabs.com/combined-stellar-magnitudes-calculator/">

<style>
 BODY
{color:silver; background-color:black;  font-family:Verdana; font-size:100%}

 TABLE
{font-size:12px; border: 1px solid black;}

 TD
{
 color:black; background-color:white; line-height:200%;
 font-size:12px; padding:6px; text-align:center;
}

IMG
{
border:1px solid #808080; box-shadow:4px 4px 3px #999999;
     border-radius:8px;
}

 DIV
{
 color:black; background-color:white; font-family:Verdana; font-size:110%;
 text-align:justify; padding:4px;
}

 PRE
{color:black; background-color:white; font-family:monospace; font-size:150%;
font-weight:bold; text-align:left; padding:4px;}

 CODE
{font-family:monospace; font-size:150%; font-weight:normal;}

 TEXTAREA
{
 color:black; background:white; font-family:monospace; font-size:150%;
 font-weight:bold; border-radius: 8px; border:1px solid black; padding:4px;
}

 INPUT[type="text"]::-ms-clear {width:0; height:0;}

 INPUT[type="text"]
{
 color:black; background:white; font-size:150%; font-family:monospace;
 font-weight:bold; text-align:center; box-shadow:2px 2px 3px #666666;
 border:2px solid black;
}

 INPUT[type="text"]:focus
{
 background:white; box-shadow:2px 2px 3px #666666; font-family:monospace;
 font-size:150%; border:2px solid red; text-align:center; font-weight:bold;
}

 INPUT[type="submit"]
{font-weight:bold;}

 INPUT[type="submit"]:hover
{box-shadow:2px 2px 5px #555555; font-weight:bold;}

 HR {background:black; height:2px; border:0px;}

 A:link
{
 font-size:100%; background:transparent; color:blue; font-family:Verdana;
 font-weight:bold; text-decoration:none; line-height:175%; padding:3px;
 border:1px solid transparent;
}

 A:visited {font-size:100%; background:transparent; color:blue;}

 A:hover
{
 font-size:100%; background:yellow; color:black; border:1px solid black;
 box-shadow:1px 1px 3px #222222;
}

 A:active  {font-size:100%; background:yellow; color:black;}

::selection      {background-color:yellow; color:black;}
::-moz-selection {background-color:yellow; color:black;}
</style>

</head>

<body>

<div ID='SmoothScroll' style='background:black;'>
<form name='form1' method='post' action="$_RUN_">

<table width='600' border='0' cellspacing='1' cellpadding='3'>

<tr><td colspan="$ColSpan" style='color:white; background:#000044; border:2px solid white; border-radius:8px 8px 0px 0px;'><b>$_INTERFACE_TITLE_</b></td></tr>

<tr><td style='line-height:150%;'><b>ENTER Stellar Magnitudes List</b>
<br><br>
An empty list input will generate up to 3 random test/demo magnitude values.<br>
Simply replace these random values with your own magnitude values separated<br>by spaces, commas or semicolons.
<br><br>

<textarea name='StellarMagsList' cols='50' rows="12">
$StellarMagsList
</textarea>

</td></tr>




<tr><td colspan="$ColSpan" style='background:black;'>
<input name='ComputeButton' type='submit' value=' C O M P U T E '>
</td></tr>




<tr><td colspan="$ColSpan" style='background:black;'>
<span style='color:white;'>Double-Click Within Text Area to Select ALL Text</span><br>
<textarea cols='52' rows="$TextArea2Rows" style='white-space:pre-wrap; border-radius:8px;' OnDblClick='this.select();' OnMouseUp='return true;' ReadOnly>
$TextArea2Text
</textarea></td></tr>




<tr><td colspan="$ColSpan" style='font-size:120%; border-radius:8px; line-height:125%;'>
In general, given two or more stars, then their singular combined<br>magnitude value (<b>M</b>) can be found from the equation given below.

<br><br>Let:<br>

<b>m<SUB>n</SUB></b>&nbsp; =&nbsp; Magnitude of <b>n</b><SUB>th</SUB> star within a group of <b>N</b> stars<br>
<b>M</b>&nbsp; =&nbsp; Magnitude of all <b>N</b> stars combined into one value

<br><br>
The general equation used within the program for <b>N</b><br>
combined stellar magnitudes may be expressed as:<br>
<div style='text-align:center;'><IMG SRC="images/N_combined_magnitudes.png" ALT="" BORDER="1"><br><br></div>
</td></tr>

<tr><td colspan="$ColSpan" style='color:gray; background:black;'>Program by $_AUTHOR_<br>$_REVISION_DATE_</td></tr>

</table>
</form>

<br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>
</div>
<script src='SmoothScroll.js'></script>
<script>SmoothScroll.init({cancelOnTouch: true});</script>

</body>


_HTML;





/*
-1.4 5*0 10*0.5 30*1.5 100*2.5 200*3.5 400*4.5 800*5.5 1600*6.5
*/


   function Combined_Magnitudes ($StellarMagnitudeListText)
{
   $w = trim($StellarMagnitudeListText);
   $w = Str_Replace(';', ' ', $w);
   $w = Str_Replace(',', ' ', $w);
   $MagTable = PReg_Replace("/\s+/", " ", trim($w));

// Handle case of single argument.
   if (Substr_Count($MagTable, ' ') == 0) {return $MagTable;}

   $MagArray = PReg_Split("[ ]", $MagTable);
   $MagCount = count($MagArray);

   $sum = 0;

   for($i=0;  $i < $MagCount;   $i++)
      {
       $sum += pow(10, -0.4 * $MagArray[$i]);
      }

   return SPrintF("%+16.12f", -2.5 * Log10($sum)); // +14.123456789012
}




/*
  ============================================================================
  This function returns a string of random digits in any given base with the
  option of a randomized numerical (+/-) sign and or decimal point.

  It makes use of the new  Random_Int() function of PHP 7+

  ARGUMENTS
  NumDigits = Number of digits or decimals to generate. (at least 1)
  Base      = Base of number system used for digits. (2 to 36)
  SignFlag  = Attach a random numerical sign.  (Default = FALSE)
  RadixFlag = Return result with radix point.  (Default = FALSE)

  An error message is returned on invalid argument(s).

  NO DEPENDENCIES
  ============================================================================
*/

   function Rand_Digits ($NumDigits=1, $Base=10, $SignFlag=FALSE, $RadixFlag=FALSE)
{
// Read arguments.
   $N = trim($NumDigits);
   $B = trim($Base);

// Return result as decimal value, if indicated.
   $F = ($RadixFlag === TRUE)? '0.' : '';

// Select random numerical sign, if indicated.
   $S = '';
   if ($RadixFlag === TRUE)
      {
       $w = random_Int(0, 1000000000000000);
       $S = ($w % 2 <> 0)? '-' : '';
      }

// Set to minimum of 1 digit if N < 1.
   if ($N < 1) {$N = 1;}

// Error if either argument is non-numeric.
   if (!Is_Numeric($N) or !Is_Numeric($B))
  {
   return "ERROR: random_Digits()\n\nNon-numeric argument: $N, $B (Both arguments must be numeric.)";
  }

// Truncate both arguments
// to positive integers.
   $N = floor(abs($N));
   $B = floor(abs($B));

// Error if base is out of legal range from 2 to 36.
   if ($B < 2 or $B > 36)
  {
   return "ERROR: random_Digits()\n\nInvalid base value: $B (Must be from 2 to 36)";
  }

// Define digits used for bases 2 to 36.
   $DIGITS = substr('0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ', 0, $B);

// Execute loop to generate the randomized digits.
   $DigitsString = '';

   for($n=0;   $n < $N;   $n++)
  {
   $DigitsString .= substr($DIGITS, Random_Int(0, $B-1), 1);
  }
   return "$S$F$DigitsString";

} // End of  Rand_Digits(...)





?>


