<?php

/*
  --------------------------------------------------------------------------
  Permutations Calculator

  This program computes the exact number all possible random permutations
  of (R) distinct items from a total of pool of (N) items altogether. In
  permutations, the sequential order in which the items are selected
  is important.

  Author:
  Jay Tanner - 2019

  Current Web Site
  www.PHPScienceLabs.com

  Development Language:
  PHP v7.1.8

  License:
  This program source code and any related data and graphics are released
  to the public domain.

  --------------------------------------------------------------------------
*/


// -----------------------------------------------
// Set the path to the program to be executed when
// the submit button is clicked.  in this case, it
// is this program itself. It modifies itself each
// time it is called.

   $RunThisProgram = $_SERVER["SCRIPT_NAME"];

// ----------------------------------------
// Get current year (UT) from system clock.

   $cYear = gmdate("Y");

// ------------------------------------
// Read input arguments from interface.

   $N = trim(@$_POST["N"]); if ($N == ''){$N = '1';}
   $R = trim(@$_POST["R"]); if ($R == ''){$R = '1';}

// Filter for invalid arguments.
   if ($N < 0 or $N > 9999 or $R < 0 or $R > $N)
  {
   $ErrorFlag = FALSE;
   $out0 = "<b style='color:red;'>ERROR: ";
   $out1 = "";
   $NumRows = 1;

   if ($N < 0)
      {
       $out0 .= "The N value must be a positive integer in the range from 0 to +9999.</b>";
       $ErrorFlag = TRUE;
       $out1 = "";
      }

   if ($R < 0 or $R > $N and $ErrorFlag === FALSE)
      {
       $out0 .= "The R value must be &le; N (or &le; $N in this case).</b>";
       $out1 = "";
      }
  }

else

// ----------------------------------------
// Compute P(N, r) for the given arguments.

  {
   $CalcTimeStart = microtime(TRUE);
   $w = bcPerm_N_R($N, $R);
   $CalcTimeSec = microtime(TRUE) - $CalcTimeStart;
   $CalcTimeSec = ($CalcTimeSec < 0.001)? sprintf("%5.6f", $CalcTimeSec) : sprintf("%5.3f", $CalcTimeSec);

   $CalcTimeStr = '';

   $DigitsCount = strlen($w);
   $s = ($DigitsCount > 1)? "s" : "";
   $DigitsMssg = '';
   $out0 = "The EXACT value of <b>P($N,&nbsp;&nbsp;$R)</b> is computed below and consists of <b>$DigitsCount</b> digit$s.$DigitsMssg$CalcTimeStr";

   $out1 = $w;

   $NumRows = 2 + floor($DigitsCount / 80);
  }



/*
  ========================================================================
  This function returns the count of the total number of possible
  permutations or unique linear sequences of N distinct items
  taken in groups of R at a time.

  THE SEQUENTIAL ORDER OF THE ITEMS IN EACH GROUP IS IMPORTANT.
  ========================================================================
*/

  function bcPerm_N_R ($N, $R)
{
  $P=1;

  for ($i=0;   $i < $R;   $i++)
      {
       $P = bcMul($P, $N-$i);
      }
  return $P;
}



print <<< _HTML

<!DOCTYPE HTML>

<html lang='en'>

<head>

<title>Permutations P(N, R) Calculator</title>
<meta name='viewport' content='width=device-width, initial-scale=1'>
<meta http-equiv='content-type' content='text/html; charset=UTF-8'>
<meta name='description' content='This program computes P(N,R) or the total number of possible random permutations of groups of R items from a pool of N distinct items.'>
<meta name='keywords' content='combinatorics,permutations calculator,permutations,combinations,PHPScienceLabs.com'>
<meta name='author' content='Jay Tanner - PHPScienceLabs.com'>
<meta http-equiv='pragma'  content='no-cache'>
<meta http-equiv='expires' content='-1'>
<meta name='robots'    content='index,follow'>
<meta name='googlebot' content='index,follow'>
<link rel="canonical" href="https://www.phpsciencelabs.com/permutations-calculator/">

<style>
 BODY
{
 color:white; background:black; font-family:Verdana; font-size:110%;
}



 DIV
{
 color:black; background:white; font-family:Verdana; font-size:110%;
 padding:6px; border-radius:8px;
}



PRE
{
 background:white; color:black; font-family:monospace; font-size:110%;
 font-weight:bold; line-height:125%; padding:6px; border-radius:8px;
}



CODE
{
 font-family:monospace; font-size:140%; font-weight:bold;
}



 TD
{
 color:black; background-color:white; line-height:125%; font-size:100%;
 padding:6px; text-align:center;
}



 TEXTAREA
{
 color:black; background:white; font-family:monospace; font-size:120%;
 font-weight:bold; border-radius: 8px; border:1px solid black; padding:6px;
}



 INPUT[type='text']::-ms-clear {width:0; height:0;}

 INPUT[type='text']
{
 font-family:monospace; color:black; background:white; font-size:150%;
 font-weight:bold; text-align:center; box-shadow:2px 2px 3px #666666;
 border:1px solid black; border-radius:4px;
}

 INPUT[type='text']:focus
{
 font-family:monospace; background:white; box-shadow:2px 2px 3px #666666;
 font-size:150%; border:2px solid blue; text-align:center; font-weight:bold;
 border-radius:4px;
}



 INPUT[type='submit']
{
 background:silver; color:black; font-family:Verdana; font-size:100%;
 font-weight:normal; border-radius:4px; border:1px solid black;
 padding:4px;
}

 INPUT[type='submit']:hover
{
 background:cyan; font-size:100%; font-family:Verdana;
 font-weight:normal; border-radius:4px; border:1px solid black;
 padding:4px; box-shadow:2px 2px 3px #666666;
}



 HR {background:black; height:2px; border:0px;}



 A:link
{
 font-size:80%; background:transparent; color:DodgerBlue;
 font-family:Verdana; font-weight:bold; text-decoration:none;
 line-height:175%; padding:3px; border:1px solid transparent;
}

 A:visited
{
 font-size:80%; background:transparent; color:gray;
}

 A:hover
{
 font-size:80%; background:yellow; color:black; border:1px solid black;
 box-shadow:1px 1px 3px #222222;
}

 A:active
{
 font-size:80%; background:yellow; color:black;
}



 ::selection
{
 background-color:yellow !important; color:black !important;
}

 ::-moz-selection
{
 background-color:yellow !important; color:black !important;
}
</style>


</head>

<body>

<table align='top' width='820'>
<tr><td style='color:white; background-color:#000066; border:2px solid white; font-size:150%; text-align:center; font-weight:normal; border-radius:8px 8px 0px 0px;'>Permutations P(N, R) Calculator<br><span style='font-size:60%;'>PHP Program by Jay Tanner</span></td></tr>

<tr><td style='text-align:justify; font-size:90%; font-weight:normal;'>
<br>
This program computes the exact count of all possible unique permutations (unique ordered sequences) of (N) distinct objects if taken in random groups of (R) at a time.

<br><br>
<b style='color:red;'>NOTE:</b><br>
Since the program computes the EXACT value and performs all of its computations in arbitrary-precision, in some cases, the computed values may extend out to tens of thousands of digits and could possibly take up to several seconds to return the computed result.

<br>
<hr>
<div style='text-align:center;'><img src='images/permutations_P(N_R).png' alt=''>
<br><br>
<form  name="form1" method="post"  action="$RunThisProgram" style='text-align:center; background-color:LightCyan; border:1px solid black; padding:8px;'>
<b>N</b> <span style='font-size:11px;'>(0 &nbsp;to&nbsp; 9999)</span> = <input name="N" type="text" value="$N" size='5' maxlength='4'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>R</b> <span style='font-size:11px;'>(0 &nbsp;to&nbsp; N)</span> = <input name="R" type="text" value="$R" size='5' maxlength='4'>&nbsp;&nbsp;&nbsp;
&nbsp;&nbsp;&nbsp;<input name="button1" type="submit" value="Compute P(N, R)" OnClick="TextAreaOut.innerHTML = 'Working ... Please be patient.'; out1.innerHTML = '';">
</form>
</div>

<hr>
<br>
<div style='text-align:center;'>
$out0

<br><br>
<textarea ID="TextAreaOut" style='font-weight:bold; background-color:LightYellow; border:1px solid black; border-radius:8px; padding:6px;' cols='80' rows="$NumRows" readonly='readonly'>
$out1
</textarea>
<br><br>
</div>

</td></tr></table>

<br><br>

<table align='bottom' width='820' align="bottom" cellpadding='6'>
<tr><td style='text-align:justify; border-radius:8px;'>
Permutations are ordered sequences, so the number of permutations means the number of unique ordered sequences in which (R) distinct items may be drawn from a total pool of (N) distinct items.&nbsp; For example we could compute the total number of possible unique numbers we could create using 5 different digits from a total pool of 7 unique digits from which to choose.

<br><br>
All permutations are unique sequences or linear orders in which they can be arranged.&nbsp; Any two sets containing the same (R) items, such as a sequence of letters, are considered identical <i>only if all</i> the letters in both sequences are in the same order as well.&nbsp; The symbols are not limited only to letters, they can be numbers or any other unique items we wish to arrange in a sequence.

<br><br>
The letters EBCAD are <i>not</i> the same as EDCBA or any other combinations of the same characters.&nbsp; That sequence of letters may be one out of many, but it is still unique among all the possible linear permutations of the unique letters A,B,C,D and E.&nbsp; In permutations, the sequential order of the unique items is important.

<br><br>
<hr>
Below is a listing of the PHP function at the heart of the above <i>Permutations Calculator</i> program.&nbsp; It computes the total number of possible unique sequences (permutations) in arbitrary-precision, which could extend out to several thousands of digits.

<br>

<pre style='border:2px solid red;'>
&#47;*
  ===========================================================================
  This function returns the EXACT count of unique permutations of (N) items
  that are possible, selected in random groups of (R) at a time.

  NOTE:  In permutations, the sequential order of the items in each group
         IS important.

  Author   : Jay Tanner - $cYear
  Language : PHP v7.x
  ===========================================================================
*&#47;

  function bcPerm_N_R (&#36;N, &#36;R)
&#123;
  &#36;P=1; for (&#36;i=0;  &#36;i &lt; &#36;R;  &#36;i++) &#123;&#36;P = bcMul(&#36;P, &#36;N-&#36;i);&#125;

  return &#36;P;
&#125;
</pre>
<hr>

</td></tr>

</table>

<br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>

</body>
</html>

_HTML;



?>


