<?php

/*
   ---------------------------------------------------------------------------
   This program is a simple program to numerically solve the maximum volume
   box problem.

   AUTHOR   : Jay Tanner - 2025
   LANGUAGE : PHP v8.2.12
   LICENSE  : Public Domain
   ---------------------------------------------------------------------------
*/


   $cYear = date('Y');

// ---------------------------------------------------------------------------
// READ INPUT ARGUMENTS.

   $L = @trim(Filter_Input(INPUT_POST, 'L'));
   $W = @trim(Filter_Input(INPUT_POST, 'W'));

// ---------------------------------------------------------------------------
// SET DEFAULTS FOR EMPTY ARGUMENTS HERE.
// THE LENGTH WILL ALWAYS BE THE LARGER
// OF THE TWO DEFAULT DIMENSIONS.

   if ($L == '' and $W == '')
      {
       $L = 5 * Random_Int(2, 20);
       $W = 5 * Random_Int(2, 20);
       if ($L < $W){$w = $W;    $W = $L;    $L = $w;}
      }

// ------------------------------
// Compute area of bottom of box.

   $A = RTrim(RTrim(bcMul($L, $W, 16), '0'), '.');


// ---------------------------------------------------------------------------
// ADJUST FOR PROPER ENGLISH.

   $Ls  = ($L  > 1)? 's':'';
   $Ws  = ($W  > 1)? 's':'';
   $As  = ($A  > 1)? 's':'';

// ---------------------------------------------------------------------------
// PERFORM MAIN COMPUTATIONS HERE USING DEFINED ARGUMENTS.

   $Q = Str_Replace('+ (-','- (', Max_Box_Volume ($L, $W));


// ---------------------------------------------------------------------------
// CONSTRUCT OUTPUT TEXT BLOCK.

   $OutputText1 =
"
                    THE MAXIMUM VOLUME BOX PROBLEM
=================================================================
$Q";





// ---------------------------------------------------------------------------
// DETERMINE HOW MANY ROWS AND COLUMNS TO USE FOR OUTPUT TEXTAREA.

   $Text1Rows = 2 + Substr_Count($OutputText1, "\n");
   $Text1Cols = Max(Array_Map('StrLen', PReg_Split("[\n]", trim($OutputText1))));

   if ($Text1Cols <= 80) {$Text1Cols += 1;}



// ---------------------------------------------------------------------------
// GENERATE WEB PAGE TO DISPLAY ABOVE COMPUTATIONS.

   print <<< _HTML_PAGE

<!DOCTYPE HTML>
<HTML>

<head>
<meta http-equiv='content-type' content='text/html; charset=UTF-8'>
<title>Maximum Box Volume Problem</title>

<style type='text/css'>

 BODY
{
 color:white; background-color:black; font-size:100%; font-family:Verdana;
}


 TD
{
 color:black; background-color:white; font-size:11pt; line-height:150%;
 padding:6px; text-align:center;
}




 TEXTAREA
{
 color:black; background-color:white; font-family:monospace; font-size:13pt;
 font-weight:bold; box-shadow:2px 2px 2px #888888; border-radius:8px;
 border:1px solid black; padding:4px; white-space:pre; line-height:125%;
}

 IMG
{
// ---
}

 INPUT[type='text']::-ms-clear {width:0; height:0;}

 INPUT[type='text']
{
 color:black; background-color:white; font-family:monospace; font-size:11pt;
 font-weight:bold; text-align:left; box-shadow:2px 2px 3px #999999;
 border:2px solid black; padding:3px; border-radius:6px;
}

 INPUT[type='text']:focus
{
 color:black; background-color:white; font-family:monospace; font-size:11pt;
 padding:3px; font-weight:bold; text-align:left; border:2px solid red;
 border-radius:6px; box-shadow:2px 2px 3px #666666;
}



 INPUT[type='submit']{font-weight:bold;}
 INPUT[type='submit']:hover{font-weight:bold; box-shadow:2px 2px 5px #222222;}

 HR {background-color:black; height:2px; border:0px;}

 A:link
{
 font-size:100%; background:transparent; color:blue; font-family:Verdana;
 font-weight:bold; text-decoration:none; line-height:175%; padding:3px;
 border:1px solid transparent;
}

 A:visited {font-size:100%; background:transparent; color:blue;}

 A:hover
{
 font-size:100%; background:yellow; color:black; border:1px solid black;
 box-shadow:1px 1px 3px #222222;
}

 A:active  {font-size:100%; background:yellow; color:black;}

::selection      {background-color:yellow; color:black;}
::-moz-selection {background-color:yellow; color:black;}

</style>

</head>

<body>
<form name='form1' method='post' action=''>



<table width='600' align='center' cellspacing='1' style='border-radius:8px 8px 0px 0px;'>

<tr><td style='background:#000066; color:white; font-size:15pt; text-align:center; border:2px solid white; border-radius:8px 8px 0px 0px;'>The Maximum Volume Box Problem<br><span style='font-size:10pt;'>PHP Program by Jay Tanner - $cYear</span></td></tr>

<tr>
<td>
Length <input type='text' name='L' value = "$L" size='13' maxlength='12'> units
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
Width <input type='text' name='W' value = "$W" size='13' maxlength='12'> units
</td>
</tr>

<tr><td><input type='submit' name='ComputeButton' value='C O M P U T E' /></td></tr>



<!-- Yellow source code view / download link. --->
<table width="600" align='center' cellspacing='1' cellpadding='3'>
<tr>
<td colspan='3' style='background:transparent; color:black; font-size:10pt;
                       text-align:center;'>
                       &nbsp;
<a href='View-Source-Code.php' target='_blank'
   style='font-family:Verdana; color:black; background:yellow;
         text-decoration:none; border:1px solid black; padding:4px;
         border-radius:4px;'>
         &nbsp;<span style='font-weight:normal;'>View/Copy PHP Source Code</span>&nbsp;
</a>
&nbsp;
<a href='Maximum-Volume-Box-Folding-Calculator.7z' target='_blank'
   style='font-family:Verdana; color:black; background:yellow;
         text-decoration:none; border:1px solid black; padding:4px;
         border-radius:4px;'>&nbsp;
         <span style='font-weight:normal;'>Download this PHP Program</span>&nbsp;
</a>
</td>
</tr>


<tr><td style='background:black; text-align:center;'>
<br>
<span style='font-size:10pt; color:GreenYellow;'>Double-Click Within Text Area To Select ALL Text</span><br>
<textarea name='TextArea1' rows="$Text1Rows" cols="$Text1Cols" ReadOnly OnDblClick='this.select();' OnMouseUp='return true;'>$OutputText1</textarea></td></tr>

<tr><td><img src='images/max-volume-box-problem.png'></td></tr>

<tr><td style='font-size:12pt; background:black; color:silver; text-align:center; border-radius:0px 0px 8px 8px;'>Jay Tanner - $cYear</td></tr>

<tr><td style='font-family:Verdana; font-size:11pt; text-align:justify;'>
<h3>The Box</h3>
This is a common problem often encountered in basic algebra and differential calculus in the study of general cubic and quadratic
polynomial equations.&nbsp; It involves finding the maximum possible volume of a box cut out
from a piece of rectangular cardboard with dimensions (<b><i style='font-family:Roman; font-size:14pt;'>L</i></b> x <b><i style='font-family:Roman; font-size:14pt;'>W</i></b>) where (<b><i style='font-family:Roman; font-size:14pt;'>L</i></b>) and (<b><i style='font-family:Roman; font-size:14pt;'>W</i></b>) are the
length and width.&nbsp; The numerical values can represent any convenient units of measure, inches, cm, feet, meters, etc..
<br><br>
The standard quadratic equation and its solution looks like:
<br>
<img src='images/standard-quadratic-equation.png'>
<br>
We often see lessons showing the solution to standard quadratic equations, but where the coefficient values <b><i style='font-family:Roman; font-size:14pt;'>A</i></b>, <b><i style='font-family:Roman; font-size:14pt;'>B</i></b> and <b><i style='font-family:Roman; font-size:14pt;'>C</i></b> come from and what they mean is not always clear.&nbsp; A quadratic equation does not only apply to parabolic curves. &nbsp;This practical example shows the creation of a quadratic equation derived as the first derivative of a cubic volume equation, demonstrating one means by which the quadratic coefficients <b><i style='font-family:Roman; font-size:14pt;'>A</i></b>, <b><i style='font-family:Roman; font-size:14pt;'>B</i></b> and <b><i style='font-family:Roman; font-size:14pt;'>C</i></b> originate and also the general solution to the resulting equation.
<br><br>
Quadratic equations are fundamental to multiple fields, such as mathematics, statistics, electronics and engineering, the physical sciences and more.&nbsp; Even some problems in relativity can be reduced to quadratic solutions.

<br><br>
<hr>
CARDBOARD SHEET WITH DIMENSIONS (<b><i style='font-family:Roman; font-size:14pt;'>L</i></b> &#215; <b><i style='font-family:Roman; font-size:14pt;'>W</i></b>) TO BE CUT<br>
AND FOLDED INTO A BOX OF MAXIMUM POSSIBLE VOLUME<br>
<img src='images/cardboard-sheet.png'>
<br>
Below we will derive the specific equation needed to solve ALL<br>maximum volume box problems of this type in general in terms<br>of<b>&nbsp;&nbsp;<i style='font-family:Roman; font-size:14pt;'>L</i></b>, <b><i style='font-family:Roman; font-size:14pt;'>W</i></b> &nbsp;and&nbsp; <b><i style='font-family:Roman; font-size:14pt;'>x</i></b>.

<br><br>
<hr>
Given the piece of cardboard with dimensions (<b><i style='font-family:Roman; font-size:14pt;'>L</i></b> &#215; <b><i style='font-family:Roman; font-size:14pt;'>W</i></b>), we cut out 4 identical squares with edges of length (<b><i style='font-family:Roman; font-size:14pt;'>x</i></b>) from each corner of the cardboard as shown below. The value of (<b><i style='font-family:Roman; font-size:14pt;'>x</i></b>) will be the depth of the resulting box.&nbsp; However, at this point, we do not yet know what that optimum value of (<b><i style='font-family:Roman; font-size:14pt;'>x</i></b>) should be to solve the maximum volume problem.&nbsp; By varying (<b><i style='font-family:Roman; font-size:14pt;'>x</i></b>), an indefinite number of boxes could be created from the cardboard, but only one value of (<b><i style='font-family:Roman; font-size:14pt;'>x</i></b>) solves the problem at hand.
<br><br>
The problem is to find the <i><b>optimum value</b></i> (<b><i style='font-family:Roman; font-size:14pt;'>x</i></b>) of the lengths of the sides of the squares that need to be cut out of the cardboard to yield the <i><b>maximum possible volume</b></i> (<b><i style='font-family:Roman; font-size:14pt;'>V</i></b>), using the source cardboard with the dimensions given above.
<br><br>
<img src='images/cardboard-sheet-after-cuts.png'>
<br>
The cardboard would look something like this after cutting out the corners, but we still have to find that special optimal value of (<b><i style='font-family:Roman; font-size:14pt;'>x</i></b>) for maximum volume.&nbsp; We can now see what will be the sides of the box.

<br><br>
<hr>
Now, the sides could then be folded upward to form a box with the dimensions and volume (<b><i style='font-family:Roman; font-size:14pt;'>V</i></b>), similar to that shown here.
<br><br>
<img src='images/quad-box-folded.png'>
<br>
Now, we can proceed to find the optimum value (<b><i style='font-family:Roman; font-size:14pt;'>x</i></b>) of the lengths of the sides of the squares that need to be cut out of the cardboard to yield the <i>maximum possible</i> box volume (<b><i style='font-family:Roman; font-size:14pt;'>V</i></b>).&nbsp; The value of (<b><i style='font-family:Roman; font-size:14pt;'>x</i></b>) equates to the depth of the resulting box.

<br><br>
To do this, first expand and express (<b><i style='font-family:Roman; font-size:14pt;'>V</i></b>) in the form of a cubic polynomial equation:
<br><br>
<img src='images/cubic-volume-equation.png'>
<br>
Next, we find the first derivative of the volume (<b><i style='font-family:Roman; font-size:14pt;'>V</i></b>) with respect to (<b><i style='font-family:Roman; font-size:14pt;'>x</i></b>) which results in a quadratic equation  which we equate to zero to find the optimum value of (<b><i style='font-family:Roman; font-size:14pt;'>x</i></b> = Depth) that yields the maximum possible volume (<b><i style='font-family:Roman; font-size:14pt;'>V</i></b>).
<br><br>
<img src='images/first-derivative-of-V=0.png'>
<br><br>
This gives the extremum (in this case, maximum) value.&nbsp; The solution (<b><i style='font-family:Roman; font-size:14pt;'>x</i></b>) to the quadratic equation is the value we seek.&nbsp; The quadratic equation has two solution roots, but only one of the (<b><i style='font-family:Roman; font-size:14pt;'>x</i></b>) values is the correct solution to the physical problem at hand.&nbsp; It is not difficult to determine which value applies.
<br><br>
In the form of a standard quadratic equation, the elements are:
<br>
<img src='images/quadratic-elements-A-B-C.png'>
<br>
Substituting the expressions for <b><i style='font-family:Roman; font-size:14pt;'>A</i></b>, <b><i style='font-family:Roman; font-size:14pt;'>B</i></b> and <b><i style='font-family:Roman; font-size:14pt;'>C</i></b> and reducing the quadratic equation to its simplest form yields the general solution for (<b><i style='font-family:Roman; font-size:14pt;'>x</i></b>) purely in terms of (<b><i style='font-family:Roman; font-size:14pt;'>L</i></b>) and (<b><i style='font-family:Roman; font-size:14pt;'>W</i></b>).&nbsp; The quadratic equation will have two solutions for (<b><i style='font-family:Roman; font-size:14pt;'>x</i></b>), of which only one will apply to the physical problem.
<br><br>
<img src='images/reduced-quadratic-solution.png'>
<br><br>
Now, solving for the two quadratic roots gives:<br>
<img src='images/quad-box-solution-x1.png' align='middle'> &nbsp;=&nbsp;<b>$X1</b> unit$X1s
<br>
and
<br>
<img src='images/quad-box-solution-x2.png' align='middle'> &nbsp;=&nbsp;<b>$X2</b> unit$X2s

<br>
Of the above two quadratic (<b><i style='font-family:Roman; font-size:14pt;'>x</i></b>) roots, only (<b><i style='font-family:Roman; font-size:14pt;'>x</i></b><sub>1</sub>) applies. The alternate root (<b><i style='font-family:Roman; font-size:14pt;'>x</i></b><sub>2</sub>) can be ignored as physically inapplicable to the problem.&nbsp; Calling the applicable (<b><i style='font-family:Roman; font-size:14pt;'>x</i></b><sub>1</sub>) value simply (<b><i style='font-family:Roman; font-size:14pt;'>x</i></b>), the final general solution we seek is:<br>
<img src='images/final-quad-box-formula-solution.png' align='middle'> &nbsp;=&nbsp;<b>$X1</b> unit$X1s

<br>
Thus, this final equation for (<b><i style='font-family:Roman; font-size:14pt;'>x</i></b>), the optimum depth, solves the general case of the maximum volume box problem given the (<b><i style='font-family:Roman; font-size:14pt;'>L</i></b>) and (<b><i style='font-family:Roman; font-size:14pt;'>W</i></b>) dimensions of the cardboard or whatever material is used, ignoring the thickness of the material as negligible.

<br><br>
Given the value of (<b><i style='font-family:Roman; font-size:14pt;'>x</i></b>), the volume of the box can be found from:<br>
<img src='images/cubic-volume-equation-2.png' align='middle'> &nbsp;=&nbsp;<b>$V1</b> cubic unit$V1s
<br><br>
Summary for this case:<br>
L &nbsp; = Length of original cardboard sheet = <b>$L</b> unit$Ls<br>
W &nbsp;= Width of original cardboard sheet = <b>$W</b> unit$Ws<br>
A &nbsp; = Area of bottom of created box  = <b>$A</b> square unit$As<br>

<br><br>
x<sub>1</sub> &nbsp;= Optimum (x) Value = Box Depth = <b>$X1</b> units
<br>
V<sub>1</sub> &nbsp;= Maximum possible volume of the folded box = <b>$V1</b> cubic unit$V1s

<br><br>
The alternate (inapplicable) values are:<br>
x<sub>2</sub> &nbsp;=&nbsp; <b>$X2</b> unit$X2s<br>
V<sub>2</sub> &nbsp;=&nbsp; <b>$V2</b> cubic unit$V2s
<hr>
</td></tr>

</table>
</form>

<br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>

</body>
</HTML>

_HTML_PAGE;


// TEST CODE.

// ************************************************************************
// ************************************************************************

   function Max_Box_Volume ($Length, $Width)
{
   GLOBAL $X1,$X1s,$V1,$V1s,$X2,$X2s,$V2,$V2s;


   $L = trim($Length);
   $W = trim($Width);

// -----------------------------
// Compute both quadratic roots.

   $P  = ($L + $W) / 6;
   $Q  = SqRt(($L+$W)*($L+$W) - 3*$L*$W) / 6;

   $X1 = $P - $Q;
   $X2 = $P + $Q;

   $Y1 = ($L - 2*$X1);
   $Z1 = ($W - 2*$X1);

   $Y2 = ($L - 2*$X2);
   $Z2 = ($W - 2*$X2);

// ----------------------------------
// Compute horizontal perimeter of box.

   $HP = RTrim(RTrim(bcMul('2', bcAdd($L, $W, 16), 16), '0'), '.');

// ----------------------------------
// Compute vertical perimeter of box.

   $VP = RTrim(RTrim(bcMul('2', bcAdd($L, $X1, 16), 16), '0'), '.');


// -------------------------------------------
// Compute volumes corresponding to (X) roots.

//   $V1 = $X1 * $Y1 * $Z1;
//   $V2 = $X2 * $Y2 * $Z2;

   $V1 = ($P - $Q) * ($L - 2*$X1) * ($W - 2*$X1);
   $V2 = ($P + $Q) * ($L - 2*$X2) * ($W - 2*$X2);

   $Ls = $Ws = $X1s = $X2s = $V1s = $V2s = 's';

   $Ls  = ($L  > 1)? 's':'';
   $Ws  = ($W  > 1)? 's':'';
   $X1s = (abs($X1) > 1)? 's':'';
   $X2s = (abs($X2) > 1)? 's':'';

   $V1s = (abs($V1) > 1 or abs($V1) == 0)? 's':'';
   $V2s = (abs($V2) > 1 or abs($V2) == 0)? 's':'';

   $HPs = (abs($HP) > 1 or abs($HP) == 0)? 's':'';
   $VPs = (abs($VP) > 1 or abs($VP) == 0)? 's':'';



   return
"This program solves the  problem of computing the  maximum possible
volume of a box that can be made from a cardboard rectangle with the
the following surface dimensions of:

Length : $L unit$Ls
Width  : $W unit$Ws

Four squares with edges of length (x) are cut out from each of
the corners of the cardboard. When the sides are folded upward
the value of (x) will be the depth of the resulting box.  The
problem is to find the optimum value of (x) that will produce
a box with the maximum possible volume (V).

The units of measure can mean anything such as inches, centimeters,
feet, meters, etc., whatever you want the units to mean.

The thickness of the cardboard is ignored and treated as negligible.

L = Length = $L unit$Ls
W = Width  = $W unit$Ws

------------------------------
OPTIMUM QUADRATIC (x) SOLUTION

x1 = Optimum value of (x) to obtain maximum possible volume (V)
   = (L + W - SqRt((L+W)^2 - 3*L*W)) / 6
   = $X1 unit$X1s

V1 = Maximum possible volume of derived box
   = (L - 2*x1) * (W - 2*x1) * x1
   = $V1 cubic unit$V1s

Hp = Horizontal Perimeter
   = $HP unit$HPs

Vp = Vertical Perimeter
   = $VP unit$VPs

-------------------------------------
ALTERNATE (INAPPLICABLE) (x) SOLUTION

x2 = Alternate solution
   = (L + W + SqRt((L+W)^2 - 3*L*W)) / 6
   = $X2 unit$X2s

V2 = Volume of derived box
   = (L - 2*x2) * (W - 2*x2) * x2
   = $V2 cubic unit$V2s
   = Inapplicable as physical solution.";
}






?>



