<?php

/*
   ###########################################################################
   SINGLE ARGUMENT INPUT TEMPLATE - WITH 30-DAY COOKIE

   AUTHOR   : Jay Tanner - 2025
   LANGUAGE : PHP v8.2.12
   LICENSE  : Public Domain

   This program is a simple numerical quadratic equation calculator.

  ###########################################################################
*/

   ob_start(); // Initialize output buffer

   $cYear = date('Y');

// ---------------------------------------------------------------
// Define the program cookie name and set it to expire in 30 days.

   $CookieName = 'Quadratic-Equation-Calculator';
   $ExpiresIn30Days = time() + 30*86400;


// ---------------------------------
// Define PHP program and HTML info.

   $_AUTHOR_           = "Jay Tanner";
   $_PROGRAM_VERSION_  = 'v2.0 - '; $at = "&#97;&#116;&#32;&#76;&#111;&#99;&#97;&#108;&#32;&#84;&#105;&#109;&#101;&#32;"; $LTC = "&#85;&#84;&#67;";
   $_SCRIPT_FILE_PATH_ = Filter_Input(INPUT_SERVER, 'SCRIPT_FILENAME');
   $_REVISION_DATE_    = $_PROGRAM_VERSION_ .'Revised: '. date("Y-F-d-l $at h:i:s A   ($LTC", FileMTime($_SCRIPT_FILE_PATH_))."&minus;05:00)";
   $_BROWSER_TAB_TEXT_ = "Quadratic Equation Calculator";
   $_INTERFACE_TITLE_  = "<span style='font-size:14pt;'>Quadratic Equation Calculator</span><br><span style='font-size:11pt;'>By Jay Tanner of Waterloo, NY, USA</span>";


/* -------------------------------------
   Define main TextArea text and background
   colors and HTML table row span. If an
   error is reported, then these colors
   will change internally to red/white.
*/
   $TxColor = 'black';
   $BgColor = 'white';


// ---------------------------------------------
// Do this only if [SUBMIT] button was clicked.

   $w = Filter_Input(INPUT_POST, 'SubmitButton');

   if (!IsSet($w))
  {

/* ----------------------------------------------------------------------
   If this program is being called externally, rather than being executed
   by clicking the [SUBMIT] button, and an active cookie also exists,
   then restore the previously saved interface settings from it. If
   the user leaves and comes back later, all the interface settings
   will be remembered and restored if the cookie was not deleted.
*/
   $w = Filter_Input(INPUT_COOKIE, $CookieName);

   if (IsSet($w))
      {
       $CookieDataString = Filter_Input(INPUT_COOKIE, $CookieName);
       list($A,$B,$C) = Preg_Split("[\|]", $CookieDataString);
      }

   else

/* -----------------------------------------------------------
   If there is no previous cookie with the interface settings,
   then set the initial default interface startup values and
   store them in a new cookie.
*/
 {
  $A = '1';
  $B = '1';
  $C = '1';


// -------------------------------------------
// Store current interface settings in cookie.

   $CookieDataString = "$A|$B|$C";
   SetCookie ($CookieName, $CookieDataString, $ExpiresIn30Days);
  } // End of  else {...}

  } // End of  if (!isset(_POST['SubmitButton']))


// ------------------------------------------
// Read values of all interface arguments and
// set any empty arguments to default values.

   $w = Filter_Input(INPUT_POST, 'SubmitButton');

   if (isset($w))
{
   $A = trim(Filter_Input(INPUT_POST, 'A'));
   $B = trim(Filter_Input(INPUT_POST, 'B'));
   $C = trim(Filter_Input(INPUT_POST, 'C'));

// ------------------
// Set default value.

   if ($A == '') {$A = '1';}
   if ($B == '') {$B = '1';}
   if ($C == '') {$C = '1';}

// --------------------------------------
// Store interface arguments in a cookie.

   $CookieDataString = "$A|$B|$C";
   SetCookie ($CookieName, $CookieDataString, $ExpiresIn30Days);
}


// ---------------------------------------------
// Check (A,B,C) values for validity.
// On error, set error flag and message values.

   $ErrFlag = FALSE;
   $ErrMssg = '';

   if (!Is_Numeric($A) or !Is_Numeric($B) or !Is_Numeric($C) or $A == 0)
  {
   $ErrFlag = TRUE;
   $ErrMssg = "An invalid argument was detected.\n\nA = $A\nB = $B\nC = $C\n\nAll arguments must be purely numeric values with (A) not equal to zero.";
  }


// *******************************************************************
// *******************************************************************
// START MAIN FUNCTION CALL CODE HERE.



// -----------------------------
// Set initial uniform width for
// tables alignment in pixels.

   $TableWidth = '780';


// ******************************************
// ******************************************
// If error was reported (TRUE), then display
// the error message on a red background.

   if ($ErrFlag === TRUE)
  {
   $TxColor = 'white';
   $BgColor = '#CC0000';
   $TextArea2Text = '';

   $TextArea1Text =
"=== ERROR ===

$ErrMssg";
  }

else


  {
// *********************************************************
// BEGIN MAIN COMPUTATIONS HERE IF NO ERRORS DETECTED ABOVE.
// *********************************************************




// -------------------------------------
// Call the quadratic solution function.

   $solution = BC_Quad_Solve($A,$B,$C, 25);



// *******************************************
// DROP THROUGH HERE AFTER COMPUTATIONS ABOVE
// TO PRINT OUT THE RESULTS OF THE OPERATIONS.
// *******************************************

   $TextArea1Text =
"
GIVEN THE QUADRATIC EQUATION:
ax&#178; &plus; bx + c = 0

AND THE COEFFICIENTS:
a = $A
b = $B
c = $C

---------------------------------
THE NUMERICAL SOLUTION ROOTS ARE:
$solution
";
  }


// ****************************
// Define TextArea2 text block.

   $TextArea2Text =
"TEXT AREA 2 = OPTIONAL SECOND TEXT AREA

For optional program info or other use or it can be removed entirely or more
text areas could be added as needed.    This text area is independent of the
text area above.
";



/* **************************************************************************
   Determine number of text columns and rows to use in the output text areas.
   These values vary randomly according to the text block width and length.
   The idea is to eliminate the need for scroll-bars within the text areas
   or worry as much about the variable dimensions of a text display area.
*/

// --------------------------------------------
// Text Area 1 - Default = At least 80 columns.

   $Text1Cols = 1 + Max(Array_Map('StrLen', PReg_Split("[\n]", trim($TextArea1Text))));
   if ($Text1Cols < 80) {$Text1Cols = 80;}  // Default
   $Text1Rows = 2 + Substr_Count($TextArea1Text, "\n");

// --------------------------------------------
// Text Area 2 - Default = At least 80 columns.

   $Text2Cols = 1 + Max(Array_Map('StrLen', PReg_Split("[\n]", trim($TextArea2Text))));
   if ($Text2Cols < 80) {$Text2Cols = 80;} // Default
   $Text2Rows = 2 + Substr_Count($TextArea2Text, "\n");



// ******************************************
// ******************************************
// GENERATE CLIENT WEB PAGE TO DISPLAY OUTPUT

   print <<< HTML_PAGE

<!DOCTYPE HTML>
<HTML>

<head>
<title>$_BROWSER_TAB_TEXT_</title>

<meta name='viewport' content='width=device-width, initial-scale=0.8'>

<meta http-equiv='content-type' content='text/html; charset=UTF-8'>
<meta http-equiv='pragma'       content='no-cache'>
<meta http-equiv='expires'      content='-1'>
<meta name='description'        content='Quadratic Equation Calculator'>
<meta name='keywords'           content='PHPScienceLabs.com'>
<meta name='author'             content='Jay Tanner - https://www.NeoProgrammics.com'>
<meta name='robots'             content='index,follow'>
<meta name='googlebot'          content='index,follow'>

<style>

 BODY {color:white; background:black; font-family:Verdana; font-size:12pt; line-height:125%;}

 TABLE
{font-size:13pt; border: 1px solid black;}


 TD
{
 color:black; background:white; line-height:150%; font-size:10pt;
 padding:6px; text-align:center;
}


 UL
{font-family:Verdana; font-size:12pt; line-height:150%; text-align:justify;}


IMG {box-shadow:2px 2px 3px #666666;}

 PRE
{
 background:white; color:black; font-family:monospace; font-size:12.5pt;
 font-weight:bold; text-align:left; line-height:125%; padding:6px;
 border:2px solid black; border-radius:8px;
 page-break-before:page;
}


 DIV
{
 background:white; color:black; font-family:Verdana; font-size:11pt;
 font-weight:normal; line-height:125%; padding:6px;
}


 TEXTAREA
{
 background:white; color:black; font-family:monospace; font-size:13pt;
 font-weight:bold; padding:4pt; white-space:pre; border-radius:8px;
 line-height:125%;
}


 INPUT[type='text']::-ms-clear {width:0; height:0;}

 INPUT[type='text']
{
 font-family:monospace; color:black; background:white; font-size:13pt;
 font-weight:bold; text-align:center; box-shadow:2px 2px 3px #666666;
 border:2px solid black; border-radius:4px;
}
 INPUT[type='text']:focus
{
 font-family:monospace; background:white; box-shadow:2px 2px 3px #666666;
 font-size:13pt; border:2px solid blue; text-align:center; font-weight:bold;
 border-radius:4px;
}



 INPUT[type='submit']
{
 background:black; color:cyan; font-family:Verdana; font-size:10pt;
 font-weight:bold; border-radius:4px; border:4px solid #777777;
 padding:3pt;
}
 INPUT[type='submit']:hover
{
 background:black; color:white; font-family:Verdana; font-size:10pt;
 font-weight:bold; border-radius:4px; border:4px solid red;
 padding:3pt;
}





// Link states MUST be set in the following order:
// :link, :visited, :hover, :active

 A:link
{
 font-size:10pt; background:transparent; color:#8080FF; border-radius:4px;
 font-family:Verdana; font-weight:bold; text-decoration:none;
 line-height:175%; padding:3px; border:1px solid transparent;
}
 A:visited
{
 font-size:10pt; background:transparent; color:DarkCyan; border-radius:4px;
}
 A:hover
{
 font-size:10pt; background:yellow; color:black; border:1px solid black;
 box-shadow:1px 1px 3px #222222; border-radius:4px;
}
 A:active
{
 font-size:10pt; background:yellow; color:black; border-radius:4px;
}


 HR {background:red; height:4px; border:0px;}


[title-text]:hover:after
{
 opacity:1.0;
 transition:all 1.0s ease 1.0s;
 text-align:left;
 visibility:visible;
}

[title-text]:after
{
 opacity:1.0;
 content:attr(title-text);
 text-align:left;
 left:50%;
 background-color:yellow;
 color:black;
 font-size:10pt;
 position:absolute;
 padding:1px 5px 2px 5px;
 white-space:pre;
 border:1px solid red;
 z-index:1;
 visibility:hidden;
}

[title-text] {position: relative;}


::selection{background-color:yellow !important; color:black !important;}
::-moz-selection{background-color:yellow !important; color:black !important;}
</style>

</head>

<body>

<!-- Define container form --->
<form name="form1" method="post" action="">

<!-- Define main page title/header. --->
<table width="$TableWidth" align="center" border="0" cellspacing="1" cellpadding="3">


<tr><td colspan="99" style="color:white; background-color:#000066; border:2px solid white; border-radius:8px 8px 0px 0px;">$_INTERFACE_TITLE_</td></tr>
</table>


<!-- Define (A,B,C) input text boxes --->
<table width="$TableWidth" align="center" border="0" cellspacing="1" cellpadding="3">
<tr><td style="font-size:14pt; line-height:175%; border-radius:0px 0px 0px 8px;"><b>a</b><br><input name="A"  type="text" value="$A"  size="25" maxlength="24"></td>

<td style="font-size:14pt; line-height:175%;"><b>b</b><br><input name="B"  type="text" value="$B"  size="25" maxlength="24"></td>

<td style="font-size:14pt; line-height:175%; border-radius:0px 0px 8px 0px;"><b>c</b><br><input name="C"  type="text" value="$C"  size="25" maxlength="24"></td></tr>

</table>




<!-- Define [SUBMIT] button --->
<table width="$TableWidth" align="center" border="0" cellspacing="1" cellpadding="3">
<tr><td colspan="99" style="background-color:black;"><input type="submit" name="SubmitButton" value=" S U B M I T "></td></tr>
</table>



<!-- Yellow source code view / download link. --->
<table width="$TableWidth" align='center' cellspacing='1' cellpadding='3'>
<tr>
<td colspan='3' style='background:transparent; color:black; font-size:10pt;
                       text-align:center;'>
                       &nbsp;
<a href='View-Source-Code.php' target='_blank'
   style='font-family:Verdana; color:black; background:yellow;
         text-decoration:none; border:1px solid black; padding:4px;
         border-radius:4px;'>
         &nbsp;<span style='font-weight:normal;'>View/Copy PHP Source Code</span>&nbsp;
</a>
&nbsp;
<a href='Math-Quadratic-Equation-Solutions-Calculator.7z' target='_blank'
   style='font-family:Verdana; color:black; background:yellow;
         text-decoration:none; border:1px solid black; padding:4px;
         border-radius:4px;'>&nbsp;
         <span style='font-weight:normal;'>Download this PHP Program</span>&nbsp;
</a>
</td>
</tr>
</table>


<br>

<!-- Define TextArea1 --->
<table width="$TableWidth" align="center" border="0" cellspacing="1" cellpadding="3">
<tr>
<td colspan="99" style="text-align:center; color:GreenYellow; background-color:black;">Double-Click Within Text Area to Select ALL Text<br>
<textarea ID="TextArea1" name="TextArea1" style="color:$TxColor; background:$BgColor; padding:6px; border:2px solid white;" cols="$Text1Cols" rows="$Text1Rows" ReadOnly OnDblClick="this.select();" OnMouseUp="return true;">
$TextArea1Text
</textarea>
</td>
</tr>
</table>

<table width="$TableWidth" align="center" border="0" cellspacing="1" cellpadding="3">
<tr><td style='font-size:12pt; border-radius:8px;'><br><br>
<img src='images/standard-quadratic-equation.png'><br>This&nbsp;program&nbsp;numerically&nbsp;solves&nbsp;the&nbsp;standard&nbsp;quadratic&nbsp;equation&nbsp;above&nbsp;for&nbsp;root&nbsp;(x).
<br><br>
Where:<br><img src='images/a-not-equal-to-zero.png'>
<br><br>
It applies the standard quadratic solution:<br><br><img src='images/standard-quadratic-solution.png'>
<br><br>
Generally, in practice, there are two (x) roots: (x<sub>1</sub>)&nbsp;and&nbsp;(x<sub>2</sub>),<br>
that will numerically solve the equation because the solutions<br>
graphically represent the X-coordinates of two points on a line<br>
passing through and intersecting with a parabola at two locations<br>
along the curve. However, it could also intersect at a single point<br>
and the possibility exists that both values could be numerically equal.
<br><br>
When applying a solution to a physical problem in the real world,<br>
usually only one of the (x) solutions will apply.
<br><br>
When plotting the equation on a graph,<br>then both solutions may apply.

<br><br>
A Simple Example:<br>
<img src='images/parabola.png'>
<br><br>The possibility exists that both values can be numerically equal.<br>
</td></tr>
</table>


<!-- Define TextArea2
<table width="$TableWidth" align="center" border="0" cellspacing="1" cellpadding="3">
<tr>
<td colspan="99" style="text-align:center; color:GreenYellow; background:black;">Double-Click Within Text Area to Select ALL Text<br>
<textarea ID="TextArea2" name="TextArea2" style="color:black; background:white; padding:6px;" cols="$Text2Cols" rows="$Text2Rows" ReadOnly OnDblClick="this.select();" OnMouseUp="return true;">
$TextArea2Text
</textarea>
</tr>
</table>
--->

<!-- Define page footer --->
<table width="$TableWidth" align="center" border="0" cellspacing="1" cellpadding="3">
<tr>
<td colspan="99" style="color:GreenYellow; background:black;">PHP Program by $_AUTHOR_<br><span style="color:silver; background:black;">$_REVISION_DATE_</span></td>
</tr>
</table>

</form>
<!-- End of container form --->


<!-- Extra bottom scroll space --->
<br><br><br><br><br><br><br><br><br><br><br><br>
<br><br><br><br><br><br><br><br><br><br><br><br>

</body>
</HTML>



HTML_PAGE;



// This function computes the numerical roots of a simple
// quadratic equation of the form: Ax² + Bx + C = 0
//
// This function solves for both real and complex (imaginary) roots.

   function BC_Quad_Solve ($a, $b, $c, $Decimals=16)

{

// ---------------------
// READ a,b,c ARGUMENTS.

   $A = trim($a);
   $B = trim($b);
   $C = trim($c);

// --------------------------------
// SET INTERNAL DECIMALS PRECISION.

   $Q = 50;
   $q = trim($Decimals);

// ------------------------------------------
// COMPUTE DISCRIMINANT D.  IF NEGATIVE, THEN
// THE SOLUTIONS ARE COMPLEX (IMAGINARY).

   $w1 = bcMul($B, $B, $Q); // B*B
//exit("$A | $B | $C");
   $w2 = bcMul("4", bcMul($A, $C, $Q), $Q); // 4*A*C

    $D = bcSub($w1, $w2, $Q);

// -------------------------------------------------
// DETERMINE IF QUADRATIC ROOTS ARE REAL OR COMPLEX.

   $i = "";

   if (bcComp($D, "0", $Q) < 0)

      {
       $i = "i";  $D = bcSub("0", $D, $Q);
      }

//  -------------------------
//  COMPUTE VALUES OF u AND v

    $u = bcDiv(bcSub("0", $B, $Q), bcMul("2", $A, $Q), $Q); // -B/2A

   $w3 = bcSqRt($D, $Q); // SqRt(B² - 4AC) = SqRt(D)

    $v = bcDiv($w3, bcMul("2", $A, $Q), $Q); // SqRt(B² - 4AC) / 2A

// ---------------------------------
// RETURN THIS IF ROOTS ARE COMPLEX.

   if ($i != "")
      {
       $u = bcAdd($u, '0', $q);
       $v = bcAdd($v, '0', $q);
       $u = RTrim(RTrim($u, "0"), ".");
       $v = RTrim(RTrim($v, "0"), ".");

       $w = "\nx1 = $u + $v$i\nand\nx2 = $u - $v$i\n\nThe roots are complex (imaginary).\n";
       $w = Str_Replace('+ -', '- ', $w);
       $w = Str_Replace('- -', '+ ', $w);

       return $w;
      }

// ------------------------------
// RETURN THIS IF ROOTS ARE REAL.

   $x1 = RTrim(RTrim(bcSub($u, $v, $q), "0"), ".");
   $x2 = RTrim(RTrim(bcAdd($u, $v, $q), "0"), ".");

   if ($x1 >= 0) {$x1 = "+$x1";}
   if ($x2 >= 0) {$x2 = "+$x2";}

   return "\nx1 = $x1\nand\nx2 = $x2\n\nThe roots are real.\n";


} // End of  bcQuad_Solve()




// END OF PROGRAM



?>



