<?php

/*

Sphere Properties Calculator

LANGUAGE : PHP v8.2.12
AUTHOR   : Jay Tanner - Revised 2025
LICENSE  : Public Domain

Given any ONE of the four spherical properties (R, C, A or V),
this program will compute the other three unknown properties.

NOTE:
This is an old program with a revised appearance.

    --------------------------------------------------------------------

NOTES:
   ii = Index of single known variable (0 to 4)
   kk = Total blank variables count    (0 to 4)

   if ii == 0, then all variables are blank.

   if kk == 0, then all variables are filled.
   if kk == 3, then only 1 variable is filled.
   if kk == 4, then all the variables are blank.

   Here it is required that one valiable be filled
   and all others remain empty. These empty values
   will be computed from the single known variable
   based on the simple relationships between them.

   R = Radius of sphere
   C = Circumference of
   A = Total surface area
   V = Total volume
*/

   $_PROGRAM_VERSION_ = '2.2';

   $cY = date('Y');

   $Out1Color = 'red';

   $out1 = $err = '';
     $ii = $kk = 0;
     $d  = 16; // Set internal working decimals precision.

// Get current name of this program (script).
   $_RUN_THIS_PROGRAM_ = $_SERVER['SCRIPT_NAME'];

// Read input variables.
   $R = @trim($_POST['R']); if ($R == '') {$kk++;} else {$ii=1;}
   $C = @trim($_POST['C']); if ($C == '') {$kk++;} else {$ii=2;}
   $A = @trim($_POST['A']); if ($A == '') {$kk++;} else {$ii=3;}
   $V = @trim($_POST['V']); if ($V == '') {$kk++;} else {$ii=4;}

// If [Clear] button was clicked, then clear and
// reset ALL input variables.
  if (@trim($_POST['reset_button']) == 'Clear')
      {
       $R = $C = $A = $V = '';  $ii = $kk = 0;
      }

// Copy input variables.
   $r = $R = str_replace('-', '', $R); $R = ($R == 0)? '':$r;
   $c = $C = str_replace('-', '', $C); $C = ($C == 0)? '':$c;
   $a = $A = str_replace('-', '', $A); $A = ($A == 0)? '':$a;
   $v = $V = str_replace('-', '', $V); $V = ($V == 0)? '':$v;

// Input is valid only if  ii > 0 and kk == 3
   if ($ii > 0 and $kk == 3)
{

// Determine which computations to perform.
   switch ($ii)
{

// --------------
// If R is given.
   case 1:
   $Out1Color   = 'black';
   $Out1BGColor = 'white';

   $w = Sphere_Properties ("R = $r", $d);
   list($r, $c, $a, $v) = preg_split("[ ]", $w);
   $as = ($a > 1)? 's':'';
   $cs = ($c > 1)? 's':'';
   $vs = ($v > 1)? 's':'';
   $rs = ($r > 1)? 's':'';

   $out1 .=
"Given Sphere Radius
R = $R unit$rs

C = $c unit$cs
A = $a sq unit$as
V = $v cu unit$vs
";
   break;

// --------------
// If C is given.
   case 2:
   $Out1Color   = 'black';
   $Out1BGColor = 'LightYellow';

   $w = Sphere_Properties ("C = $c", $d);
   list($r, $c, $a, $v) = preg_split("[ ]", $w);
   $as = ($a > 1)? 's':'';
   $cs = ($c > 1)? 's':'';
   $vs = ($v > 1)? 's':'';
   $rs = ($r > 1)? 's':'';

   $out1 .=
"Given Sphere Circumference
C = $C unit$cs

R = $r unit$rs
A = $a square unit$as
V = $v cubic unit$vs
";
   break;

// --------------
// If A is given.
   case 3:
   $Out1Color   = 'black';
   $Out1BGColor = 'LightYellow';

   $w = Sphere_Properties ("A = $a", $d);
   list($r, $c, $a, $v) = preg_split("[ ]", $w);
   $as = ($a > 1)? 's':'';
   $cs = ($c > 1)? 's':'';
   $vs = ($v > 1)? 's':'';
   $rs = ($r > 1)? 's':'';

   $out1 .=
"Given Sphere Surface Area
A = $A square unit$as

R = $r unit$rs
C = $c unit$cs
V = $v cubic unit$vs
";
   break;

// --------------
// If V is given.
   case 4:
   $Out1Color   = 'black';
   $Out1BGColor = 'LightYellow';

   $w = Sphere_Properties ("V = $v", $d);
   list($r, $c, $a, $v) = preg_split("[ ]", $w);
   $as = ($a > 1)? 's':'';
   $cs = ($c > 1)? 's':'';
   $vs = ($v > 1)? 's':'';
   $rs = ($r > 1)? 's':'';

   $out1 .=
"Given Sphere Volume
V = $V cubic unit$vs

R = $r unit$rs
C = $c unit$cs
A = $a square unit$as
";
   break;

// ----------------------------
// If all variables are filled.
   default:
   break;

} // END OF  switch(ii)


}

else

{
   $Out1Color = 'white';
   $Out1BGColor = '#AA0000';
   $out1 .= "\n\n   Enter ONLY ONE known property and leave all the others blank.\n\n";
   $out1 .= "   Those unknown properties will be computed and displayed here.\n";

}



// $out1 = "ii=$ii   kk=$kk | " . $out1;



print <<< _HTML

<!DOCTYPE HTML>

<HTML lang='en'>

<HEAD>

<title>Sphere Properties Calculator</title>

<meta name='viewport' content='width=device-width, initial-scale=1'>
<meta http-equiv="content-type" content="text/html; charset=UTF-8">
<meta name="description" content="Sphere Properties Calculator">
<meta name="keywords" content="sphere,calculator">
<meta name="author" content="Jay Tanner - NeoProgrammics / PHPScienceLabs">
<meta http-equiv='pragma'  content='no-cache'>
<meta http-equiv='expires' content='-1'>
<meta name='robots'    content='index,follow'>
<meta name='googlebot' content='index,follow'>

<style>
BODY {background:black; color:white; font-family:Verdana; font-size:100%;}

TEXTAREA {font-family:monospace; text-align:left; font-size:11pt; font-weight:bold; padding:4px; border:1px solid black;}

TABLE {background:black; font-family:Verdana; font-size:14px;}

TD {background:white; color:black; font-size:100%; text-align:center; line-height:150%;}

HR {background:black; height:2px; border:0px;}

IMG {border:1px solid #BBBBBB; border-radius:4px;}


INPUT[type="submit"] {box-shadow:3px 3px 4px #999999;}

INPUT[type="text"]::-ms-clear {width:0; height:0;}

INPUT[type="text"] {box-shadow:3px 3px 4px #999999; background-color:white; font-family:monospace; font-size:110%; font-weight:bold; text-align:center; border:1px solid black; border-radius:4px;}

INPUT[type="text"]:focus {box-shadow:3px 3px 4px #999999;background-color:white; font-family:monospace; font-size:110%; border:1px solid blue; border-radius:5px; text-align:center; font-weight:bold;}

::-ms-selection  {background-color:yellow; color:black;}  /* Only applies to IE9+ and Safari     */
::-moz-selection {background-color:yellow; color:black;}  /* Only applies to Mozilla and FireFox */
</style>


</head>

<body>

<TABLE align='left' WIDTH="650" style='color:black; background-color:black; font-size:100%;'>

<TR><TD style='background:black;'>
<DIV style='background:black;'>
<FORM name="form1" METHOD="post" ACTION="$_RUN_THIS_PROGRAM_">
<TABLE WIDTH="650" ALIGN="center">

<TR><TD rowspan='1' COLSPAN="3" ALIGN="center" style='color:white; background:#000066; font-size:150%; font-weight:normal; border:2px solid white; border-radius:8px 8px 0px 0px;'>Basic Sphere Properties Calculator<br><span style='font-size:8pt;'>PHP Program by Jay Tanner of Waterloo, NY, USA</span></td></tr>


<tr><td rowspan='8'><IMG SRC="images/tiny_wiki_wireframe_sphere.png" ALT="" style='border:none; box-shadow:none;'></td></tr>


<TR><TD COLSPAN="2" style='font-size:90%; text-align:justify; padding:6px;'>
Enter any ONE of the four spherical properties (<B>R</B>, <B>C</B>, <B>A</B> or <B>V</B>) and this program will compute the other three unknown properties.<br><br>The units of measure can be interpreted as anything, such as meters, inches, miles, feet, etc., whatever units you decide the numerical values represent.
</TD></TR>

<TR><TD style='color:black; background-color:white; text-align:left;'>&nbsp;<B>R</B>&nbsp;=&nbsp;Radius&nbsp;&nbsp;</TD><TD style='text-align:left; color:black; background-color:LightCyan; padding:6px;'><INPUT NAME="R" size='38' maxlength='36' TYPE="text" VALUE="$R"  style='text-align:left; padding:4px;'><br>unit<z>(</z>s<z>)</z></TD></TR>

<TR><TD style='color:white; background-color:black; text-align:left;'>&nbsp;<B>C</B>&nbsp;=&nbsp;Circumference&nbsp;&nbsp;</TD><TD style='text-align:left; color:black; background-color:LightCyan; padding:6px;'><INPUT NAME="C" size='38' maxlength='36'  TYPE="text" VALUE="$C" style='text-align:left; padding:4px;'><br>unit<z>(</z>s<z>)</z></TD></TR>

<TR><TD style='color:black; background-color:GreenYellow; text-align:left;'>&nbsp;<B>A</B>&nbsp;=&nbsp;Area&nbsp;of&nbsp;Surface&nbsp;&nbsp;</TD><TD style='text-align:left; color:black; background-color:LightCyan; padding:6px;'><INPUT NAME="A" size='38' maxlength='36'  TYPE="text" VALUE="$A" style='text-align:left; padding:4px;'><br>square&nbsp;unit<z>(</z>s<z>)</z></TD></TR>

<TR><TD style='color:black; background-color:cyan; text-align:left;'>&nbsp;<B>V</B>&nbsp;=&nbsp;Volume&nbsp;&nbsp;</TD><TD style='text-align:left; color:black; background-color:LightCyan; padding:6px;'><INPUT NAME="V" size='38' maxlength='36' TYPE="text" VALUE="$V" style='text-align:left; padding:4px;'><br>cubic&nbsp;unit<z>(</z>s<z>)</z></TD></TR>

<TR><TD COLSPAN="2" ALIGN="center" style='background-color:white; padding:8px;'>
<INPUT TYPE="submit" NAME="compute_button" VALUE="Compute">&nbsp;&nbsp;
<INPUT TYPE="submit" NAME="reset_button"   VALUE="Clear">
</TD></TR>

</table>

<br>

<!-- Yellow source code view link. --->
<table width='666' align='center' cellspacing='1' cellpadding='3'>
<!-- Yellow source code view link. --->
<tr>
<td colspan='3' style='background:transparent; color:black; font-size:10pt;
                       text-align:center;'>
<a href='View-Source-Code.php' target='_blank'
   style='font-family:Verdana; color:black; background:yellow;
         text-decoration:none; border:1px solid black; padding:4px;
         border-radius:4px;'>
         <span style='font-weight:normal;'>View/Copy PHP Source Code</span>
</a>
&nbsp;
<a href='Math-Sphere-Properties-Calculator.7z' target='_blank'
   style='font-family:Verdana; color:black; background:yellow;
         text-decoration:none; border:1px solid black; padding:4px;
         border-radius:4px;'>
         <span style='font-weight:normal;'>Download This Program</span>
</a>
</td>
</tr>

</table>

</form>

<span style='color:white; font-size:9pt;'>Double-Click to Select ALL Text</span><br>
<textarea rows='8' cols='66' readonly style="color:$Out1Color; background-color:$Out1BGColor; text-align:left; border:2px solid black; border-radius:8px;" OnDblClick="this.select();" OnMouseUp="return true;">
$out1</textarea>

<hr>
<div align="center" style='color:GreenYellow; font-size:90%;'>
The Basic Spherical Elements
<br>
<img src='images/sphere_parameters.png'>
<br>
<hr>
The Relevant Spherical Equations
<br>
<img src='images/sphere_equations.png'>


<HR>

<DIV style='color:silver; font-size:75%; text-align:center;'>Jay Tanner - $cY
<br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>
</DIV>

_HTML;






/*
 This function computes the four basic properties of a sphere
 from any given any one of the other basic properties.

 The (R,C,A,V) symbols are NOT case sensitive.

 R = Radius of sphere value
 C = Circumference or perimeter value
 A = Surface area value
 V = Volume value

 Given any ONE known variable, the other three can be
 directly computed from it.

 EXAMPLE 1:
 The arguments ('R = 1.62125', 10)
 Should return:
 '1.6212500000 10.1866141792 33.0300964762 17.8500146373'

 EXAMPLE 2:
 The single argument ('V = 2.5')
 Should return:
 '0.8419451504803148 5.2900973989490201 8.9079437012273097 2.5000000000000000'
 Default decimals = 16

 Returned values will be an 'R C A V' string with the
 numerical 'R C A V' values separated by single spaces.
*/

   function Sphere_Properties ($KnownRCAV, $Decimals=16)
{
   $KVStr = strtoupper(str_replace(' ', '', trim($KnownRCAV)));

// _____________________________________________
// Define local  constant pi to 110 decimals and
// related derived values. These constants could
// also be made global.

   $PI   = '3.141592653589793238462643383279502884197169399375105820974944592307816406286208998628034825342117067982148';
   $PIx2 = bcmul('2', $PI, 110);
   $PIx4 = bcmul('4', $PI, 110);

// __________________________________________
// Read decimals value from 0 to 100 maximum.

   $decimals = abs(intval(trim($Decimals)));
   if ($decimals > 100) {$decimals = 100;}
   $d = $decimals + 5 + floor($decimals / 4);

// _________________________________________
// Assume initial ERROR state by default.  A
// successful operation will set it to FALSE.

   $ERROR_FLAG_SET = TRUE;

// ____________________________________
// Handle the case of known radius (R).

   if (substr($KVStr,0, 2) == 'R=')
  {
   $R  = substr($KVStr,2, strlen($KVStr));
   $R2 = bcmul($R,$R, $d);
   $R3 = bcmul($R, bcmul($R,$R, $d), $d);
   $C  = bcmul($PIx2, $R, $d);
   $A  = bcmul($PIx4, $R2, $d);
   $V  = bcdiv(bcmul($PIx4, $R3, $d), '3', $d);
   $R  = bcadd($R, '0', $d);
   $ERROR_FLAG_SET = FALSE;
  }

// ___________________________________________
// Handle the case of known circumference (C).

   if (substr($KVStr,0,2) == 'C=')
  {
   $C  = substr($KVStr,2, strlen($KVStr));
   $R  = bcdiv($C, bcmul('2', $PI, $d), $d);
   $R2 = bcmul($R,$R, $d);
   $R3 = bcmul($R, bcmul($R,$R, $d), $d);
   $A  = bcmul($PIx4, $R2, $d);
   $V  = bcdiv(bcmul($PIx4, $R3, $d), '3', $d);
   $C  = bcadd($C, '0', $d);
   $ERROR_FLAG_SET = FALSE;
  }

// __________________________________________
// Handle the case of known surface area (A).

   if (substr($KVStr,0,2) == 'A=')
  {
   $A  = substr($KVStr,2, strlen($KVStr));
   $R  = bcsqrt(bcdiv($A, $PIx4, $d), $d);
   $R2 = bcmul($R,$R, $d);
   $R3 = bcmul($R, bcmul($R,$R, $d), $d);
   $C  = bcmul($PIx2, $R, $d);
   $V  = bcdiv(bcmul($PIx4, $R3, $d), '3', $d);
   $A  = bcadd($A, '0', $d);
   $R  = bcadd($R, '0', $d);
   $ERROR_FLAG_SET = FALSE;
  }

// ____________________________________
// Handle the case of known volume (V).

   if (substr($KVStr,0,2) == 'V=')
  {
   $V = substr($KVStr,2, strlen($KVStr));
   $x = bcdiv(bcmul('3', $V, $d), $PIx4, $d);
   $r = sprintf("%1.16f", pow($x, 1/3));

   for ($i=1;  $i <= 100;   $i++)
  {
   $R = bcdiv(bcadd(bcmul('2',$r,$d),bcdiv($x, bcpow($r,'2',$d),$d),$d),'3',$d);
        if (bccomp($r,$R,$d) == 0) {break;} else {$r = $R;}
  }
   $C  = bcmul($PIx2, $R, $d);
   $A  = bcmul($PIx4, bcmul($R,$R, $d), $d);
   $R  = bcadd($R, '0', $d);
   $V  = bcadd($V, '0', $d);
   $ERROR_FLAG_SET = FALSE;
  }

// _______________________
// Check error flag state.

   if ($ERROR_FLAG_SET) {return "ERROR: Invalid or missing R, C, A or V argument.";}

// _________________________________
// Round-off all values to the given
// number of output decimals.

   $Z = '0.' . str_repeat('0', $decimals) . '5';
   $R = bcadd($R, $Z, $decimals);
   $C = bcadd($C, $Z, $decimals);
   $A = bcadd($A, $Z, $decimals);
   $V = bcadd($V, $Z, $decimals);

   return "$R $C $A $V";

} // END OF  Sphere_Properties (...)





?>


