<?php

/*
  --------------------------------------------------------------------------
  Variance and Standard Deviation Calculator

  Given a numerical data table, this program computes the variance and the
  standard deviation of the given data.

  AUTHOR   : Jay Tanner - 2026
  LANGUAGE : PHP v8.2.12
  LICENSE  : Public Domain
  --------------------------------------------------------------------------

*/



// Initialize for cookies
   ob_start();

   $cYear = gmdate("Y");

   $_PROGRAM_VERSION_  = "v2.3";

   $n = $SUMdata = $mean = $SUMsquaresOfDiffs = $iInit = 0;
   $variance0 = $variance1 = $StdDev0 = $StdDev1 = 0;
   $WorkString = '';

// Local server path to this PHP program script.
// This script calls itself and self-modifies
// when the [COMPUTE] button is clicked.
   $_RUN_THIS_PROGRAM_ = $_SERVER['SCRIPT_NAME'];

   $_HTML_TITLE_ = "Variance and Standard Deviation Statistics Calculator - ";
   $_HEADER_     = "Variance and Standard Deviation Statistics Calculator";

// Give the cookie a name.  This cookie data can be shared
// with any other scripts running within the same folder.
// SPECIAL CASE NOTE: This program uses no cookie data.
// It creates a cookie with the string: 'Empty cookie.'
   $_COOKIE_NAME_ = "Std_Dev_Interface_Settings";

// ===========================================================
// Set cookie expiration date to 1 standard month (30 days).
//
// This value must be the number of seconds as measured from
// the moment the cookie is refreshed. To set the cookie to
// expire in 30 days, simply multiply the number of days
// by 86400 seconds per day.  Each time the cookie is
// used, it will be refreshed. It will expire only if
// called later than 30 days from the last time it
// was refreshed.

   $ExpiresIn30Days = time() + (30 * 86400);

// =======================================
// Do this if "COMPUTE" button was clicked.

   if (IsSet($_POST["COMPUTE_Button"]))
  {
// Read interface input text area.
   $NumericDataString = HTMLentities(trim(@$_POST["NumericDataString"]),ENT_QUOTES,'UTF-8');

   $w = str_replace(',',  ' ', $NumericDataString);
   $w = str_replace(';',  ' ', $w);
   $w = str_replace('\n', ' ', $w);
   $WorkString = preg_replace('/\s+/', ' ', trim($w));

// Write/save interface settings to cookie.  In this
// case, no cookie data are used.
   $CookieDataString = '';

   setcookie ($_COOKIE_NAME_, $CookieDataString, $ExpiresIn30Days);
  }

   else

// ======================================================
// Do this if program was called externally via URL link.

      {

// =========================================================
// If a cookie exists, then recall interface value from it.

   if (isset($_COOKIE[$_COOKIE_NAME_]))
  {
// Recall interface text field settings from cookie.
   $CookieDataString = $_COOKIE[$_COOKIE_NAME_];

// Parse cookie data and get values into their respective variables.
// SPECIAL CASE NOTE: This program uses no cookie data.
// list($NumericDataString) = preg_split("[\|]", $CookieDataString);
   $WorkString = $NumericDataString = '';
  }

   else

// ===============================================
// If no cookie exists, then set default interface
// values and copy to an initial cookie.

  {
// Set initial random default/test data values.
   if (@$WorkString == '')
      {
       $RBase = mt_rand(10, 100);
       $RRange = mt_rand(1, floor(SqRt($RBase)));
       $N = mt_rand(30, 100); // Random number of data elements.
       for($n=0;   $n < $N;   $n++)
          {
           $rd = mt_rand(1, 3); // Random number of decimals.
           $rn = $RBase + $RRange*floatval(Random_Decimals($rd));
           $rn = sprintf("%1.".$rd."f", $rn);
           $WorkString .= "$rn, ";
          }
      }
   $WorkString = rtrim(trim($WorkString), ',');
   $CookieDataString = '';
   $NumericDataString = $WorkString;

   setcookie ($_COOKIE_NAME_, $CookieDataString, $ExpiresIn30Days);
  }
}



// **********************************
// **********************************
// AT THIS POINT, THE INPUT INTERFACE
// VALUES SHOULD BE READY FOR USE




// -------------------------------------------
// THIS IS WHERE THE INPUT ERROR FILTER(S) GO.
// DEFAULT IS NO ERROR CHECKING (0==0).



   if (strpos(trim($WorkString), ' ') === FALSE)
  {
   $out =
"
ENTER a data string or table above with at least two numbers to be evaluated.

The data are given as a space-delimited numeric string.  However, the data can
also be delimited by commas or semicolons as well.
";
  }

   else

/*
  ============================
  CONTINUE BELOW IF NO ERRORS.
  MAIN COMPUTATIONS START HERE. THE STATISTICS RETURNED ARE:
  n = Data count
  SUMdata = Sum of all data
  mean = Arithmetic mean of data
  SUMsquaresOfDiffs = Sum of squares of all differences from the mean
  variance0 = Population variance
  StdDev0
  variance1
  StdDev1
*/

  {
// Call function to compute the standard deviation and variance statistics.
   $StdDevStatsStr = Std_Dev_Stats ($WorkString);

   list($n,$SUMdata,$mean,$SUMsquaresOfDiffs,$variance0,$StdDev0,$variance1,$StdDev1) =
   preg_split("[ ]", $StdDevStatsStr);

// If n > 0, the set initial i=1
   $iInit  = ($n > 0)? 1:0;


// ======================================
// CONSTRUCT FORMATTED TEXT OUTPUT BLOCK.
//
// After the computations are done, the raw numeric results can be
// formatted for text output here, usually in a PRE block to make
// sure the text output is neatly aligned.

// Format computed results for neat output display.
// $n $SUMdata $mean $SUMsquaresOfDiffs $variance0 $StdDev0 $variance1 $StdDev1




   $out =
"
n = Data count = $n
Sum of all data = $SUMdata
Arithmetic mean of data = $mean
Sum of squares of all differences from the mean = $SUMsquaresOfDiffs
Sample variance = $variance1
Sample standard deviation = $StdDev1
Population variance = $variance0
Population standard deviation = $StdDev0

";



  }





/*
  ------------------------------------------------------------------------------
  THIS FUNCTION IS THE FOUNDATION UPON WHICH THIS PROGRAM IS BUILT.
  REVISED VERSION AS OF: 2014 AUG 30
  OUTPUT SEQUENCE IS DIFFERENT THAN EARLIER VERSIONS AND MAY CHANGE
  ADDING MORE STATISTICS IN FUTURE VERSIONS.

  This function computes the standard statistics for a numerical data string.

  The returned string contains the following computed statistics:
  n                  = Number of data elements (numbers to be processed)
  $SUMdata           = Sum of all the data
  $mean              = Arithmetic mean of the data
  $SUMsquaresOfDiffs = Sum of the squares of the differences from the mean
  $variance0         = Population variance
  $StdDev0           = Population standard deviation
  $variance1         = Sample variance
  $StdDev1           = Sample standard deviation"
*/

   function Std_Dev_Stats ($NumericDataString)
{
   $w = str_replace(',',  ' ', $NumericDataString);
   $w = str_replace(';',  ' ', $w);
   $w = str_replace('\n', ' ', $w);
   $WorkString = preg_replace('/\s+/', ' ', trim($w));

   $n = $SUMdata = 0;

   while ($WorkString != '')
  {
   $n++;

   $i = strpos($WorkString, ' ');

   if ($i === FALSE)
      {
       $SUMdata += $WorkString;
       $mean = $SUMdata / $n;
       break;
      }

   $xi = trim(substr($WorkString, 0, $i));
   $SUMdata += $xi;
   $mean = $SUMdata / $n;

   $WorkString = trim(substr($WorkString, $i, strlen($WorkString)));
  }

// *************************************************************************
// Cycle through data computing the sum of squares of differences from mean.
// The mean of this summation of squares is the population variance.

   $w = str_replace(",", " ", $NumericDataString);
   $w = str_replace(";", " ", $w);
   $WorkString = preg_replace('/\s+/', ' ', trim($w));

   $n = $SUMsquaresOfDiffs = 0;

   while ($WorkString != '')
  {
   $n++;

   $i = strpos($WorkString, ' ');

   if ($i === FALSE)
      {
       $diff = $WorkString - $mean;
       $SUMsquaresOfDiffs += ($diff * $diff);
       break;
      }

   $xi = trim(substr($WorkString, 0, $i));
   $diff = $xi - $mean;
   $SUMsquaresOfDiffs += ($diff * $diff);
   $WorkString = trim(substr($WorkString, $i, strlen($WorkString)));
  }

   $variance0 = $SUMsquaresOfDiffs / ($n-0); // sigma
   $StdDev0 = sqrt($variance0); // SqRt(sigma)

   $variance1 = $SUMsquaresOfDiffs / ($n-1); // s
   $StdDev1 = sqrt($variance1); // SqRt(s)

// DO SOME OUTPUT FORMATTING.

   $SUMdata = RTrim(RTrim(sprintf("%1.12f", $SUMdata), '0'), '.');
   $mean = RTrim(RTrim(sprintf("%1.12f", $mean), '0'), '.');
   $SUMsquaresOfDiffs = RTrim(RTrim(sprintf("%1.12f", $SUMsquaresOfDiffs), '0'), '.');
   $variance0 = RTrim(RTrim(sprintf("%1.12f", $variance0), '0'), '.');
   $StdDev0 = RTrim(RTrim(sprintf("%1.12f", $StdDev0), '0'), '.');
   $variance1 = RTrim(RTrim(sprintf("%1.12f", $variance1), '0'), '.');
   $StdDev1 = RTrim(RTrim(sprintf("%1.12f", $StdDev1), '0'), '.');
   $StdDevStats = "$n $SUMdata $mean $SUMsquaresOfDiffs $variance0 $StdDev0 $variance1 $StdDev1";

   return $StdDevStats;

} // End of  Std_Dev_Stats(...)



/*
   ========================================================================
   This function generates a string of any number of
   random digits in any given base from 2 to 36.

   All letters (A to Z) used as digits will be returned in uppercase.

   ERRORS:
   On error, FALSE is returned for invalid argument(s).
   ========================================================================
*/

   function Random_Digits_BaseB ($NumDigits=1, $BaseB=10, $LZeroSuppressed=FALSE)
{

// Read arguments.
   $N = intval($NumDigits);
   $B = intval($BaseB);

// Check for invalid argument(s).
   if ($B < 2 or $B > 36 or $N < 1) {return FALSE;}

// Define digits spectrum for the given base.
   $DigitsSpectrum = substr("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ",0,$B);

// Construct an N-digit random sequence in base B, one digit at
// a time, using a random 50/50 digit alternation method. There
// will be at least one random base B digit returned.
   $RandomDigits = "";

   for ($i=0;   $i < $N;   $i++)
  {
   if (mt_rand() % 2 == 0)
  {$RandomDigits .= substr($DigitsSpectrum, mt_rand(0,$B-1),1);}
   else
  {$RandomDigits = substr($DigitsSpectrum, mt_rand(0,$B-1),1) . $RandomDigits;}
  }

// If LZeroSuppressed flag === TRUE, then leftmost digit of returned
// random digits string must NOT be zero.  If it is, then another
// random non-zero digit will be attached to the left of it and
// the rightmost digit dropped.  The result will be a normal
// integer value with the required number of digits, but
// never starting with 0 (zero) as the first digit.
   if ($LZeroSuppressed === TRUE)
  {
   $RandomDigits = substr($DigitsSpectrum, mt_rand(1,$B-1),1) . $RandomDigits;
  }
   return substr("$RandomDigits", 0, $N);

} // End of  Random_Digits_BaseB(...)



// Special custom routine to add an d-digit random decimal value.

   function Random_Decimals($NumDecimals)
{
   if ($NumDecimals == 0) {return '';};

   return '.' . Random_Digits_BaseB ($NumDecimals);
}



// Set number of output TEXTAREA rows according
// to the length of the output string.

   $TextOutRows = 3 + floor(StrLen($NumericDataString) / 64);


// ===========================================
// DYNAMIC HTML DOCUMENT OUTPUT FOLLOWS BELOW.

print <<< _HTML

<!DOCTYPE HTML>

<HTML lang='en-us'>

<head>

<meta http-equiv="content-type" content="text/html; charset=UTF-8">

<title>Variance and Standard Deviation Calculator</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta http-equiv="content-type" content="text/html; charset=UTF-8">
<meta name="description" content="This PHP program is a statistical variance and standard deviation calculator.">
<meta name="keywords" content="variance,standard deviation,calculate variance,calculate standard deviation,PHPScienceLabs.com">
<meta name="author" content="Jay Tanner - https://www.PHPScienceLabs.com">
<meta http-equiv="pragma"  content="no-cache">
<meta http-equiv="expires" content="-1">
<meta name="robots"    content="index,follow">
<meta name="googlebot" content="index,follow">

<style type='text/css' rel='stylesheet'>
BODY {background-color:black; color:white; font-family:Verdana; font-size:14px;}

TEXTAREA {font-family:monospace; text-align:left; font-size:15px; font-weight:bold; padding:4px; border:1px solid black;}

CODE {; font-family:monospace; font-size:18px;}

TABLE {background-color:black; font-family:Verdana; font-size:14px;}

TD {background-color:white; color:black; font-family:Verdana; font-size:80%; text-align:center; border:1px solid black; line-height:200%;}

HR {background-color:black; height:2px; border:0px;}

IMG {box-shadow:2px 2px 2px #999999; border:1px solid #808080; border-radius:8px;}

INPUT[type="submit"] {box-shadow:3px 3px 2px #999999;}

INPUT[type="text"] {box-shadow:3px 3px 2px #999999; background-color:white; font-family:monospace; font-size:18px; font-weight:bold; text-align:center; border:2px solid black;}

INPUT[type="text"]::-ms-clear {width:0; height:0;}

INPUT[type="text"]:focus {box-shadow:3px 3px 2px #999999;background-color:white; font-family:monospace; font-size:18px; border:2px solid red; text-align:center; font-weight:bold;}

A:link,  A:visited {background-color:transparent; color:blue; font-family:Verdana; font-size:80%; font-weight:bold; text-decoration:none; line-height:150%; padding:2px;}
A:hover, A:active  {background-color:transparent; color:red;  font-family:Verdana; font-size:80%; font-weight:bold; text-decoration:none; line-height:150%; padding:2px;}

::-ms-selection  {background-color:yellow; color:black;}  /* Only applies to IE9+ and Safari     */
::-moz-selection {background-color:yellow; color:black;}  /* Only applies to Mozilla and FireFox */
</style>

</head>

<body style='background-color:black;'>

<table align='center' width='666'>
<tr><td style='color:white; background-color:#000066; font-size:150%; border:2px solid white; border-radius:8px 8px 0px 0px; text-align:center;'><b style='font-weight:normal;'>$_HEADER_</b><br><span style='font-size:70%;'>PHP Program by Jay Tanner</span>
</td></tr>

<tr><td style='border:1px solid black; font-family:verdana; font-size:80%;'>
<br>
<b>Simply enter the delimited numerical data table/string and click [COMPUTE].<br>
The numerical data elements can be separated by commas, spaces or semicolons.<br>
<span style='color:red;'>The initial example data is randomly generated.&nbsp; Copy/Paste/Replace with your own data table.</span></b>

<br><br>
<form name="form2" method="post"  action="$_RUN_THIS_PROGRAM_" style='background-color:LightYellow; text-align:center; padding:4px; border:1px solid black;'>

<br>
<textarea name='NumericDataString' style="background-color:white; border:1px solid black; box-shadow:3px 2px 6px #666666; border-radius:8px;" cols="60" rows="$TextOutRows">
$NumericDataString
</textarea>

<br>
<input name="COMPUTE_Button" type="submit" value="C O M P U T E" style='font-weight:bold;'><br><br>
</form>

</td></tr>

<tr>
<td colspan='3' style='background:transparent; color:black; font-size:10pt;
                       text-align:center;'>
                       &nbsp;
<a href='View-Source-Code.php' target='_blank'
   style='font-family:Verdana; color:black; background:yellow;
          text-decoration:none; border:1px solid black; padding:4px;
          border-radius:4px;'>
          &nbsp;<span style='font-weight:normal;'>View/Copy PHP Source Code</span>&nbsp;
</a>
&nbsp;
<a href='Variance-and-Standard-Deviation-Calculator.7z' target='_blank'
   style='font-family:Verdana; color:black; background:yellow;
          text-decoration:none; border:1px solid black; padding:4px;
          border-radius:4px;'>&nbsp;
          <span style='font-weight:normal;'>Download this PHP Program</span>&nbsp;
</a>
</td>
</tr>

<!-- Start a sub-table within this table cell -->
<tr><td style='background-color:white; border-radius:8px 8px 0px 0px;'>

<table width='100%' align='center' cellpadding='8' cellspacing='1' style='background-color:transparent; font-family:monospace; font-size:125%; border-radius:8px 8px 0px 0px;'>

<tr><td colspan='2' style='color:white; background-color:maroon; font-weight:normal; font-family:Verdana; font-size:130%; border:1px solid white; border-radius:8px 8px 0px 0px;'>Statistics Computed From The Above Data Table</td></tr>

<tr><td style='background-color:black; color:white; font-weight:bold;'>Mathematical&nbsp;&nbsp;Expression</td><td align='center' style='background-color:GreenYellow; font-weight:bold; font-family:Verdana;'>&nbsp;Numerical&nbsp;&nbsp;Evaluation&nbsp;</td></tr>

<tr><td><img src='images/N_cap.png' alt='' style='border:none; box-shadow:none;'><br>Data elements count<br></td><td align='center' style='font-weight:bold;  font-size:120%; font-family:monospace; background-color:#EEEEEE;'>$n</td></tr>

<tr><td><img src='images/i.png' alt='' style='border:none; box-shadow:none;'><br>Data element index<br></td><td align='center' style='font-size:120%; font-family:monospace;'><b>$iInit</b> to <b>$n</b></td></tr>

<tr><td><img src='images/xi.png' alt='' style='border:none; box-shadow:none;'><br><img src='images/i.png' alt='' style='border:none; box-shadow:none;'><sub>th</sub>&nbsp; indexed value of (<img src='images/x.png' alt='' style='border:none; box-shadow:none;'>) within the data table<br></td><td align='center' style='font-size:120%; font-family:monospace;'><b><img src='images/x.png' alt='' style='border:none; box-shadow:none;'><sub>$iInit</sub></b> to <b><img src='images/x.png' alt='' style='border:none; box-shadow:none;'><sub>$n</sub></b></td></tr>

<tr><td><img src='images/sum_of_all_data.png' alt=''><br>Sum of all given numerical data</td><td align='center' style='font-weight:bold; font-size:120%; font-family:monospace; background-color:#FFDDDD;'>$SUMdata<br><span style='font-family:Verdana; font-size:66%; font-weight:normal;'>Sum of All Data</span></td></tr>

<tr><td><img src='images/sample_or_population_mean_bar_x_mu.png' alt=''><br>Arithmetic mean (average) of sample or population</td><td align='center' style='color:black; background-color:#DDFFDD; font-weight:bold; font-size:120%; font-family:monospace;'>$mean<br><span style='font-family:Verdana; font-size:66%; font-weight:normal;'>Arithmetic Mean</span></td></tr>

<tr><td><img src='images/sum_of_squares_of_diffs.png' alt=''><br>&nbsp;Sum&nbsp;of&nbsp;squares&nbsp;of&nbsp;all&nbsp;differences&nbsp;from&nbsp;the&nbsp;mean&nbsp;</td><td align='center' style='font-weight:bold; font-size:120%; font-family:monospace;'>$SUMsquaresOfDiffs</td></tr>

<tr><td><img src='images/sample_variance.png' alt=''><br>Sample variance</td><td align='center' style='font-weight:bold; font-size:120%; background-color:LightCyan; font-family:monospace;'>$variance1<br><span style='font-family:Verdana; font-size:66%; font-weight:normal;'>Sample Variance</span></td></tr>

<tr><td><img src='images/sample_std_dev.png' alt=''><br>Standard deviation within sample</td><td align='center' style='color:black; background-color:LightCyan; font-weight:bold; font-size:120%; font-family:monospace;'>&plusmn;&nbsp;$StdDev1<br><span style='font-family:Verdana; font-size:66%; font-weight:normal;'>Sample Standard Deviation</span></td></tr>

<tr><td><img src='images/population_variance.png' alt=''><br>Population variance</td><td align='center' style='font-weight:bold; font-size:120%; background-color:LightYellow; font-family:monospace;'>$variance0<br><span style='font-family:Verdana; font-size:66%; font-weight:normal;'>Population Variance</span></td></tr>

<tr><td><img src='images/population_std_dev.png' alt=''><br>Standard deviation within population</td><td align='center' style='color:black; background-color:LightYellow; font-weight:bold; font-size:120%; font-family:monospace;'>&plusmn;&nbsp;$StdDev0<br><span style='font-family:Verdana; font-size:66%; font-weight:normal;'>Population Standard Deviation</span></td></tr>
</table>
</td></tr>
<!-- End sub-table within this table cell -->

<tr><td colspan='4' style='font-size:80%; color:black; background-color:white;'>PHP Math Tool by Jay Tanner - $cYear</td></tr>

</table>

<br><br><br><br><br><br><br><br><br><br>
<br><br><br><br><br><br><br><br><br><br>

</body>
</HTML>


_HTML;



?>



